# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2QueueObservationScoredAgent

class V2QueueObservationObservation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2QueueObservationObservation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'observation_date': 'datetime',
            'conversation_id': 'str',
            'session_id': 'str',
            'requested_routing_skill_ids': 'list[str]',
            'requested_language_id': 'str',
            'routing_priority': 'int',
            'participant_name': 'str',
            'user_id': 'str',
            'direction': 'str',
            'converted_from': 'str',
            'converted_to': 'str',
            'address_from': 'str',
            'address_to': 'str',
            'ani': 'str',
            'dnis': 'str',
            'team_id': 'str',
            'scored_agents': 'list[V2QueueObservationScoredAgent]',
            'requested_routings': 'list[str]',
            'used_routing': 'str'
        }

        self.attribute_map = {
            'observation_date': 'observationDate',
            'conversation_id': 'conversationId',
            'session_id': 'sessionId',
            'requested_routing_skill_ids': 'requestedRoutingSkillIds',
            'requested_language_id': 'requestedLanguageId',
            'routing_priority': 'routingPriority',
            'participant_name': 'participantName',
            'user_id': 'userId',
            'direction': 'direction',
            'converted_from': 'convertedFrom',
            'converted_to': 'convertedTo',
            'address_from': 'addressFrom',
            'address_to': 'addressTo',
            'ani': 'ani',
            'dnis': 'dnis',
            'team_id': 'teamId',
            'scored_agents': 'scoredAgents',
            'requested_routings': 'requestedRoutings',
            'used_routing': 'usedRouting'
        }

        self._observation_date = None
        self._conversation_id = None
        self._session_id = None
        self._requested_routing_skill_ids = None
        self._requested_language_id = None
        self._routing_priority = None
        self._participant_name = None
        self._user_id = None
        self._direction = None
        self._converted_from = None
        self._converted_to = None
        self._address_from = None
        self._address_to = None
        self._ani = None
        self._dnis = None
        self._team_id = None
        self._scored_agents = None
        self._requested_routings = None
        self._used_routing = None

    @property
    def observation_date(self) -> datetime:
        """
        Gets the observation_date of this V2QueueObservationObservation.
        The timestamp when the observation started

        :return: The observation_date of this V2QueueObservationObservation.
        :rtype: datetime
        """
        return self._observation_date

    @observation_date.setter
    def observation_date(self, observation_date: datetime) -> None:
        """
        Sets the observation_date of this V2QueueObservationObservation.
        The timestamp when the observation started

        :param observation_date: The observation_date of this V2QueueObservationObservation.
        :type: datetime
        """
        

        self._observation_date = observation_date

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this V2QueueObservationObservation.
        Unique identifier of the conversation to which this observation belongs

        :return: The conversation_id of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this V2QueueObservationObservation.
        Unique identifier of the conversation to which this observation belongs

        :param conversation_id: The conversation_id of this V2QueueObservationObservation.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this V2QueueObservationObservation.
        Unique identifier of the user session associated with this observation

        :return: The session_id of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this V2QueueObservationObservation.
        Unique identifier of the user session associated with this observation

        :param session_id: The session_id of this V2QueueObservationObservation.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def requested_routing_skill_ids(self) -> List[str]:
        """
        Gets the requested_routing_skill_ids of this V2QueueObservationObservation.
        Unique identifiers for skills requested for an interaction

        :return: The requested_routing_skill_ids of this V2QueueObservationObservation.
        :rtype: list[str]
        """
        return self._requested_routing_skill_ids

    @requested_routing_skill_ids.setter
    def requested_routing_skill_ids(self, requested_routing_skill_ids: List[str]) -> None:
        """
        Sets the requested_routing_skill_ids of this V2QueueObservationObservation.
        Unique identifiers for skills requested for an interaction

        :param requested_routing_skill_ids: The requested_routing_skill_ids of this V2QueueObservationObservation.
        :type: list[str]
        """
        

        self._requested_routing_skill_ids = requested_routing_skill_ids

    @property
    def requested_language_id(self) -> str:
        """
        Gets the requested_language_id of this V2QueueObservationObservation.
        Unique identifier for the language requested for an interaction

        :return: The requested_language_id of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._requested_language_id

    @requested_language_id.setter
    def requested_language_id(self, requested_language_id: str) -> None:
        """
        Sets the requested_language_id of this V2QueueObservationObservation.
        Unique identifier for the language requested for an interaction

        :param requested_language_id: The requested_language_id of this V2QueueObservationObservation.
        :type: str
        """
        

        self._requested_language_id = requested_language_id

    @property
    def routing_priority(self) -> int:
        """
        Gets the routing_priority of this V2QueueObservationObservation.
        Routing priority for the current interaction

        :return: The routing_priority of this V2QueueObservationObservation.
        :rtype: int
        """
        return self._routing_priority

    @routing_priority.setter
    def routing_priority(self, routing_priority: int) -> None:
        """
        Sets the routing_priority of this V2QueueObservationObservation.
        Routing priority for the current interaction

        :param routing_priority: The routing_priority of this V2QueueObservationObservation.
        :type: int
        """
        

        self._routing_priority = routing_priority

    @property
    def participant_name(self) -> str:
        """
        Gets the participant_name of this V2QueueObservationObservation.
        A human readable name identifying the participant

        :return: The participant_name of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._participant_name

    @participant_name.setter
    def participant_name(self, participant_name: str) -> None:
        """
        Sets the participant_name of this V2QueueObservationObservation.
        A human readable name identifying the participant

        :param participant_name: The participant_name of this V2QueueObservationObservation.
        :type: str
        """
        

        self._participant_name = participant_name

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this V2QueueObservationObservation.
        Unique identifier for the user

        :return: The user_id of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this V2QueueObservationObservation.
        Unique identifier for the user

        :param user_id: The user_id of this V2QueueObservationObservation.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def direction(self) -> str:
        """
        Gets the direction of this V2QueueObservationObservation.
        The direction of the communication

        :return: The direction of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this V2QueueObservationObservation.
        The direction of the communication

        :param direction: The direction of this V2QueueObservationObservation.
        :type: str
        """
        

        self._direction = direction

    @property
    def converted_from(self) -> str:
        """
        Gets the converted_from of this V2QueueObservationObservation.
        Session media type that was converted from in case of a media type conversion

        :return: The converted_from of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._converted_from

    @converted_from.setter
    def converted_from(self, converted_from: str) -> None:
        """
        Sets the converted_from of this V2QueueObservationObservation.
        Session media type that was converted from in case of a media type conversion

        :param converted_from: The converted_from of this V2QueueObservationObservation.
        :type: str
        """
        

        self._converted_from = converted_from

    @property
    def converted_to(self) -> str:
        """
        Gets the converted_to of this V2QueueObservationObservation.
        Session media type that was converted to in case of a media type conversion

        :return: The converted_to of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._converted_to

    @converted_to.setter
    def converted_to(self, converted_to: str) -> None:
        """
        Sets the converted_to of this V2QueueObservationObservation.
        Session media type that was converted to in case of a media type conversion

        :param converted_to: The converted_to of this V2QueueObservationObservation.
        :type: str
        """
        

        self._converted_to = converted_to

    @property
    def address_from(self) -> str:
        """
        Gets the address_from of this V2QueueObservationObservation.
        The address that initiated an action

        :return: The address_from of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._address_from

    @address_from.setter
    def address_from(self, address_from: str) -> None:
        """
        Sets the address_from of this V2QueueObservationObservation.
        The address that initiated an action

        :param address_from: The address_from of this V2QueueObservationObservation.
        :type: str
        """
        

        self._address_from = address_from

    @property
    def address_to(self) -> str:
        """
        Gets the address_to of this V2QueueObservationObservation.
        The address receiving an action

        :return: The address_to of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._address_to

    @address_to.setter
    def address_to(self, address_to: str) -> None:
        """
        Sets the address_to of this V2QueueObservationObservation.
        The address receiving an action

        :param address_to: The address_to of this V2QueueObservationObservation.
        :type: str
        """
        

        self._address_to = address_to

    @property
    def ani(self) -> str:
        """
        Gets the ani of this V2QueueObservationObservation.
        Automatic Number Identification (caller's number)

        :return: The ani of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._ani

    @ani.setter
    def ani(self, ani: str) -> None:
        """
        Sets the ani of this V2QueueObservationObservation.
        Automatic Number Identification (caller's number)

        :param ani: The ani of this V2QueueObservationObservation.
        :type: str
        """
        

        self._ani = ani

    @property
    def dnis(self) -> str:
        """
        Gets the dnis of this V2QueueObservationObservation.
        Dialed number identification service (number dialed by the calling party)

        :return: The dnis of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._dnis

    @dnis.setter
    def dnis(self, dnis: str) -> None:
        """
        Sets the dnis of this V2QueueObservationObservation.
        Dialed number identification service (number dialed by the calling party)

        :param dnis: The dnis of this V2QueueObservationObservation.
        :type: str
        """
        

        self._dnis = dnis

    @property
    def team_id(self) -> str:
        """
        Gets the team_id of this V2QueueObservationObservation.
        The team Id the user is a member of

        :return: The team_id of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._team_id

    @team_id.setter
    def team_id(self, team_id: str) -> None:
        """
        Sets the team_id of this V2QueueObservationObservation.
        The team Id the user is a member of

        :param team_id: The team_id of this V2QueueObservationObservation.
        :type: str
        """
        

        self._team_id = team_id

    @property
    def scored_agents(self) -> List['V2QueueObservationScoredAgent']:
        """
        Gets the scored_agents of this V2QueueObservationObservation.
        Scored agents for this conversation

        :return: The scored_agents of this V2QueueObservationObservation.
        :rtype: list[V2QueueObservationScoredAgent]
        """
        return self._scored_agents

    @scored_agents.setter
    def scored_agents(self, scored_agents: List['V2QueueObservationScoredAgent']) -> None:
        """
        Sets the scored_agents of this V2QueueObservationObservation.
        Scored agents for this conversation

        :param scored_agents: The scored_agents of this V2QueueObservationObservation.
        :type: list[V2QueueObservationScoredAgent]
        """
        

        self._scored_agents = scored_agents

    @property
    def requested_routings(self) -> List[str]:
        """
        Gets the requested_routings of this V2QueueObservationObservation.
        All routing types for requested/attempted routing methods.

        :return: The requested_routings of this V2QueueObservationObservation.
        :rtype: list[str]
        """
        return self._requested_routings

    @requested_routings.setter
    def requested_routings(self, requested_routings: List[str]) -> None:
        """
        Sets the requested_routings of this V2QueueObservationObservation.
        All routing types for requested/attempted routing methods.

        :param requested_routings: The requested_routings of this V2QueueObservationObservation.
        :type: list[str]
        """
        

        self._requested_routings = requested_routings

    @property
    def used_routing(self) -> str:
        """
        Gets the used_routing of this V2QueueObservationObservation.
        Complete routing method

        :return: The used_routing of this V2QueueObservationObservation.
        :rtype: str
        """
        return self._used_routing

    @used_routing.setter
    def used_routing(self, used_routing: str) -> None:
        """
        Sets the used_routing of this V2QueueObservationObservation.
        Complete routing method

        :param used_routing: The used_routing of this V2QueueObservationObservation.
        :type: str
        """
        if isinstance(used_routing, int):
            used_routing = str(used_routing)
        allowed_values = ["Bullseye", "Conditional", "Direct", "Last", "Manual", "Predictive", "Preferred", "Standard", "Vip"]
        if used_routing.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for used_routing -> " + used_routing)
            self._used_routing = "outdated_sdk_version"
        else:
            self._used_routing = used_routing

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

