# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class V2ReprocessJobStateChangedTopicJobStateChanged(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ReprocessJobStateChangedTopicJobStateChanged - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'organization_id': 'str',
            'job_id': 'str',
            'job_status': 'str',
            'processed_interactions_count': 'int',
            'failed_interactions_count': 'int',
            'total_interactions': 'int'
        }

        self.attribute_map = {
            'organization_id': 'organizationId',
            'job_id': 'jobId',
            'job_status': 'jobStatus',
            'processed_interactions_count': 'processedInteractionsCount',
            'failed_interactions_count': 'failedInteractionsCount',
            'total_interactions': 'totalInteractions'
        }

        self._organization_id = None
        self._job_id = None
        self._job_status = None
        self._processed_interactions_count = None
        self._failed_interactions_count = None
        self._total_interactions = None

    @property
    def organization_id(self) -> str:
        """
        Gets the organization_id of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The organization_id of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id: str) -> None:
        """
        Sets the organization_id of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param organization_id: The organization_id of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: str
        """
        

        self._organization_id = organization_id

    @property
    def job_id(self) -> str:
        """
        Gets the job_id of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The job_id of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id: str) -> None:
        """
        Sets the job_id of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param job_id: The job_id of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: str
        """
        

        self._job_id = job_id

    @property
    def job_status(self) -> str:
        """
        Gets the job_status of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The job_status of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: str
        """
        return self._job_status

    @job_status.setter
    def job_status(self, job_status: str) -> None:
        """
        Sets the job_status of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param job_status: The job_status of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: str
        """
        if isinstance(job_status, int):
            job_status = str(job_status)
        allowed_values = ["Unknown", "Queued", "InProgress", "Completed", "Failed"]
        if job_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for job_status -> " + job_status)
            self._job_status = "outdated_sdk_version"
        else:
            self._job_status = job_status

    @property
    def processed_interactions_count(self) -> int:
        """
        Gets the processed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The processed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: int
        """
        return self._processed_interactions_count

    @processed_interactions_count.setter
    def processed_interactions_count(self, processed_interactions_count: int) -> None:
        """
        Sets the processed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param processed_interactions_count: The processed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: int
        """
        

        self._processed_interactions_count = processed_interactions_count

    @property
    def failed_interactions_count(self) -> int:
        """
        Gets the failed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The failed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: int
        """
        return self._failed_interactions_count

    @failed_interactions_count.setter
    def failed_interactions_count(self, failed_interactions_count: int) -> None:
        """
        Sets the failed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param failed_interactions_count: The failed_interactions_count of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: int
        """
        

        self._failed_interactions_count = failed_interactions_count

    @property
    def total_interactions(self) -> int:
        """
        Gets the total_interactions of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :return: The total_interactions of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :rtype: int
        """
        return self._total_interactions

    @total_interactions.setter
    def total_interactions(self, total_interactions: int) -> None:
        """
        Sets the total_interactions of this V2ReprocessJobStateChangedTopicJobStateChanged.


        :param total_interactions: The total_interactions of this V2ReprocessJobStateChangedTopicJobStateChanged.
        :type: int
        """
        

        self._total_interactions = total_interactions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

