# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction
    from . import V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage
    from . import V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage
    from . import V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity
    from . import V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage

class V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'created_date': 'datetime',
            'summary_id': 'str',
            'session_id': 'str',
            'user_id': 'str',
            'summary_settings_id': 'str',
            'language': 'str',
            'media_type': 'str',
            'summary': 'V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage',
            'reason': 'V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage',
            'resolution': 'V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage',
            'followup_actions': 'list[V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction]',
            'extracted_entities': 'list[V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity]',
            'error_type': 'str',
            'duration_ms': 'int'
        }

        self.attribute_map = {
            'created_date': 'createdDate',
            'summary_id': 'summaryId',
            'session_id': 'sessionId',
            'user_id': 'userId',
            'summary_settings_id': 'summarySettingsId',
            'language': 'language',
            'media_type': 'mediaType',
            'summary': 'summary',
            'reason': 'reason',
            'resolution': 'resolution',
            'followup_actions': 'followupActions',
            'extracted_entities': 'extractedEntities',
            'error_type': 'errorType',
            'duration_ms': 'durationMs'
        }

        self._created_date = None
        self._summary_id = None
        self._session_id = None
        self._user_id = None
        self._summary_settings_id = None
        self._language = None
        self._media_type = None
        self._summary = None
        self._reason = None
        self._resolution = None
        self._followup_actions = None
        self._extracted_entities = None
        self._error_type = None
        self._duration_ms = None

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The created_date of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param created_date: The created_date of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def summary_id(self) -> str:
        """
        Gets the summary_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The summary_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._summary_id

    @summary_id.setter
    def summary_id(self, summary_id: str) -> None:
        """
        Sets the summary_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param summary_id: The summary_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        

        self._summary_id = summary_id

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The session_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param session_id: The session_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The user_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param user_id: The user_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def summary_settings_id(self) -> str:
        """
        Gets the summary_settings_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The summary_settings_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._summary_settings_id

    @summary_settings_id.setter
    def summary_settings_id(self, summary_settings_id: str) -> None:
        """
        Sets the summary_settings_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param summary_settings_id: The summary_settings_id of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        

        self._summary_settings_id = summary_settings_id

    @property
    def language(self) -> str:
        """
        Gets the language of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The language of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param language: The language of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        

        self._language = language

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The media_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param media_type: The media_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["UNKNOWN", "MESSAGE", "CALL", "EMAIL"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def summary(self) -> 'V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage':
        """
        Gets the summary of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The summary of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage
        """
        return self._summary

    @summary.setter
    def summary(self, summary: 'V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage') -> None:
        """
        Sets the summary of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param summary: The summary of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: V2SessionConversationsSummarySettingsPreviewEventConversationSummaryMessage
        """
        

        self._summary = summary

    @property
    def reason(self) -> 'V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage':
        """
        Gets the reason of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The reason of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage
        """
        return self._reason

    @reason.setter
    def reason(self, reason: 'V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage') -> None:
        """
        Sets the reason of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param reason: The reason of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: V2SessionConversationsSummarySettingsPreviewEventConversationReasonMessage
        """
        

        self._reason = reason

    @property
    def resolution(self) -> 'V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage':
        """
        Gets the resolution of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The resolution of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution: 'V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage') -> None:
        """
        Sets the resolution of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param resolution: The resolution of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: V2SessionConversationsSummarySettingsPreviewEventConversationResolutionMessage
        """
        

        self._resolution = resolution

    @property
    def followup_actions(self) -> List['V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction']:
        """
        Gets the followup_actions of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The followup_actions of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: list[V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction]
        """
        return self._followup_actions

    @followup_actions.setter
    def followup_actions(self, followup_actions: List['V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction']) -> None:
        """
        Sets the followup_actions of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param followup_actions: The followup_actions of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: list[V2SessionConversationsSummarySettingsPreviewEventConversationFollowupAction]
        """
        

        self._followup_actions = followup_actions

    @property
    def extracted_entities(self) -> List['V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity']:
        """
        Gets the extracted_entities of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The extracted_entities of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: list[V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity]
        """
        return self._extracted_entities

    @extracted_entities.setter
    def extracted_entities(self, extracted_entities: List['V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity']) -> None:
        """
        Sets the extracted_entities of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param extracted_entities: The extracted_entities of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: list[V2SessionConversationsSummarySettingsPreviewEventConversationSummaryExtractedEntity]
        """
        

        self._extracted_entities = extracted_entities

    @property
    def error_type(self) -> str:
        """
        Gets the error_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The error_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: str
        """
        return self._error_type

    @error_type.setter
    def error_type(self, error_type: str) -> None:
        """
        Sets the error_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param error_type: The error_type of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: str
        """
        if isinstance(error_type, int):
            error_type = str(error_type)
        allowed_values = ["UNKNOWN", "CONVERSATION_TOO_LONG", "CONVERSATION_TOO_SHORT", "RATE_LIMITED"]
        if error_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for error_type -> " + error_type)
            self._error_type = "outdated_sdk_version"
        else:
            self._error_type = error_type

    @property
    def duration_ms(self) -> int:
        """
        Gets the duration_ms of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :return: The duration_ms of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms: int) -> None:
        """
        Sets the duration_ms of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.


        :param duration_ms: The duration_ms of this V2SessionConversationsSummarySettingsPreviewEventConversationSummarySettingsPreviewMessage.
        :type: int
        """
        

        self._duration_ms = duration_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

