# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2StaEmpathyOverallTopicAgentEmpathyScore

class V2StaEmpathyOverallTopicOverallEmpathyMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2StaEmpathyOverallTopicOverallEmpathyMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'queue_ids': 'list[str]',
            'division_ids': 'list[str]',
            'agents': 'list[V2StaEmpathyOverallTopicAgentEmpathyScore]'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'queue_ids': 'queueIds',
            'division_ids': 'divisionIds',
            'agents': 'agents'
        }

        self._conversation_id = None
        self._queue_ids = None
        self._division_ids = None
        self._agents = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :return: The conversation_id of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :param conversation_id: The conversation_id of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def queue_ids(self) -> List[str]:
        """
        Gets the queue_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :return: The queue_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :rtype: list[str]
        """
        return self._queue_ids

    @queue_ids.setter
    def queue_ids(self, queue_ids: List[str]) -> None:
        """
        Sets the queue_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :param queue_ids: The queue_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :type: list[str]
        """
        

        self._queue_ids = queue_ids

    @property
    def division_ids(self) -> List[str]:
        """
        Gets the division_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :return: The division_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids: List[str]) -> None:
        """
        Sets the division_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :param division_ids: The division_ids of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :type: list[str]
        """
        

        self._division_ids = division_ids

    @property
    def agents(self) -> List['V2StaEmpathyOverallTopicAgentEmpathyScore']:
        """
        Gets the agents of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :return: The agents of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :rtype: list[V2StaEmpathyOverallTopicAgentEmpathyScore]
        """
        return self._agents

    @agents.setter
    def agents(self, agents: List['V2StaEmpathyOverallTopicAgentEmpathyScore']) -> None:
        """
        Sets the agents of this V2StaEmpathyOverallTopicOverallEmpathyMessage.


        :param agents: The agents of this V2StaEmpathyOverallTopicOverallEmpathyMessage.
        :type: list[V2StaEmpathyOverallTopicAgentEmpathyScore]
        """
        

        self._agents = agents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

