# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class V2StaTopicsDetectedTopicParticipant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2StaTopicsDetectedTopicParticipant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'queue_id': 'str',
            'division_id': 'str',
            'purpose': 'str'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'queue_id': 'queueId',
            'division_id': 'divisionId',
            'purpose': 'purpose'
        }

        self._user_id = None
        self._queue_id = None
        self._division_id = None
        self._purpose = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this V2StaTopicsDetectedTopicParticipant.


        :return: The user_id of this V2StaTopicsDetectedTopicParticipant.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this V2StaTopicsDetectedTopicParticipant.


        :param user_id: The user_id of this V2StaTopicsDetectedTopicParticipant.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this V2StaTopicsDetectedTopicParticipant.


        :return: The queue_id of this V2StaTopicsDetectedTopicParticipant.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this V2StaTopicsDetectedTopicParticipant.


        :param queue_id: The queue_id of this V2StaTopicsDetectedTopicParticipant.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def division_id(self) -> str:
        """
        Gets the division_id of this V2StaTopicsDetectedTopicParticipant.


        :return: The division_id of this V2StaTopicsDetectedTopicParticipant.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id: str) -> None:
        """
        Sets the division_id of this V2StaTopicsDetectedTopicParticipant.


        :param division_id: The division_id of this V2StaTopicsDetectedTopicParticipant.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def purpose(self) -> str:
        """
        Gets the purpose of this V2StaTopicsDetectedTopicParticipant.


        :return: The purpose of this V2StaTopicsDetectedTopicParticipant.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose: str) -> None:
        """
        Sets the purpose of this V2StaTopicsDetectedTopicParticipant.


        :param purpose: The purpose of this V2StaTopicsDetectedTopicParticipant.
        :type: str
        """
        

        self._purpose = purpose

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

