# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2StaTopicsDetectedTopicParticipant
    from . import V2StaTopicsDetectedTopicTopicDetected

class V2StaTopicsDetectedTopicTopicsDetectedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2StaTopicsDetectedTopicTopicsDetectedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'communication_id': 'str',
            'recording_id': 'str',
            'transcript_id': 'str',
            'media_type': 'str',
            'topics': 'list[V2StaTopicsDetectedTopicTopicDetected]',
            'participants': 'list[V2StaTopicsDetectedTopicParticipant]'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'communication_id': 'communicationId',
            'recording_id': 'recordingId',
            'transcript_id': 'transcriptId',
            'media_type': 'mediaType',
            'topics': 'topics',
            'participants': 'participants'
        }

        self._conversation_id = None
        self._communication_id = None
        self._recording_id = None
        self._transcript_id = None
        self._media_type = None
        self._topics = None
        self._participants = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The conversation_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param conversation_id: The conversation_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def communication_id(self) -> str:
        """
        Gets the communication_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The communication_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id: str) -> None:
        """
        Sets the communication_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param communication_id: The communication_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: str
        """
        

        self._communication_id = communication_id

    @property
    def recording_id(self) -> str:
        """
        Gets the recording_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The recording_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: str
        """
        return self._recording_id

    @recording_id.setter
    def recording_id(self, recording_id: str) -> None:
        """
        Sets the recording_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param recording_id: The recording_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: str
        """
        

        self._recording_id = recording_id

    @property
    def transcript_id(self) -> str:
        """
        Gets the transcript_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The transcript_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: str
        """
        return self._transcript_id

    @transcript_id.setter
    def transcript_id(self, transcript_id: str) -> None:
        """
        Sets the transcript_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param transcript_id: The transcript_id of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: str
        """
        

        self._transcript_id = transcript_id

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The media_type of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param media_type: The media_type of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: str
        """
        

        self._media_type = media_type

    @property
    def topics(self) -> List['V2StaTopicsDetectedTopicTopicDetected']:
        """
        Gets the topics of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The topics of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: list[V2StaTopicsDetectedTopicTopicDetected]
        """
        return self._topics

    @topics.setter
    def topics(self, topics: List['V2StaTopicsDetectedTopicTopicDetected']) -> None:
        """
        Sets the topics of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param topics: The topics of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: list[V2StaTopicsDetectedTopicTopicDetected]
        """
        

        self._topics = topics

    @property
    def participants(self) -> List['V2StaTopicsDetectedTopicParticipant']:
        """
        Gets the participants of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :return: The participants of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :rtype: list[V2StaTopicsDetectedTopicParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['V2StaTopicsDetectedTopicParticipant']) -> None:
        """
        Sets the participants of this V2StaTopicsDetectedTopicTopicsDetectedMessage.


        :param participants: The participants of this V2StaTopicsDetectedTopicTopicsDetectedMessage.
        :type: list[V2StaTopicsDetectedTopicParticipant]
        """
        

        self._participants = participants

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

