# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2WebMessagingUndeliveredMessageTopicMessage

class V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'deployment_id': 'str',
            'participant_id': 'str',
            'external_contact_id': 'str',
            'communication_id': 'str',
            'session_expiry': 'int',
            'messages': 'list[V2WebMessagingUndeliveredMessageTopicMessage]',
            'event_time_ms': 'int'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'deployment_id': 'deploymentId',
            'participant_id': 'participantId',
            'external_contact_id': 'externalContactId',
            'communication_id': 'communicationId',
            'session_expiry': 'sessionExpiry',
            'messages': 'messages',
            'event_time_ms': 'eventTimeMs'
        }

        self._conversation_id = None
        self._deployment_id = None
        self._participant_id = None
        self._external_contact_id = None
        self._communication_id = None
        self._session_expiry = None
        self._messages = None
        self._event_time_ms = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The conversation_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param conversation_id: The conversation_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def deployment_id(self) -> str:
        """
        Gets the deployment_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The deployment_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id: str) -> None:
        """
        Sets the deployment_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param deployment_id: The deployment_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: str
        """
        

        self._deployment_id = deployment_id

    @property
    def participant_id(self) -> str:
        """
        Gets the participant_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The participant_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: str
        """
        return self._participant_id

    @participant_id.setter
    def participant_id(self, participant_id: str) -> None:
        """
        Sets the participant_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param participant_id: The participant_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: str
        """
        

        self._participant_id = participant_id

    @property
    def external_contact_id(self) -> str:
        """
        Gets the external_contact_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The external_contact_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: str
        """
        return self._external_contact_id

    @external_contact_id.setter
    def external_contact_id(self, external_contact_id: str) -> None:
        """
        Sets the external_contact_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param external_contact_id: The external_contact_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: str
        """
        

        self._external_contact_id = external_contact_id

    @property
    def communication_id(self) -> str:
        """
        Gets the communication_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The communication_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id: str) -> None:
        """
        Sets the communication_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param communication_id: The communication_id of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: str
        """
        

        self._communication_id = communication_id

    @property
    def session_expiry(self) -> int:
        """
        Gets the session_expiry of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The session_expiry of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: int
        """
        return self._session_expiry

    @session_expiry.setter
    def session_expiry(self, session_expiry: int) -> None:
        """
        Sets the session_expiry of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param session_expiry: The session_expiry of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: int
        """
        

        self._session_expiry = session_expiry

    @property
    def messages(self) -> List['V2WebMessagingUndeliveredMessageTopicMessage']:
        """
        Gets the messages of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The messages of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: list[V2WebMessagingUndeliveredMessageTopicMessage]
        """
        return self._messages

    @messages.setter
    def messages(self, messages: List['V2WebMessagingUndeliveredMessageTopicMessage']) -> None:
        """
        Sets the messages of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param messages: The messages of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: list[V2WebMessagingUndeliveredMessageTopicMessage]
        """
        

        self._messages = messages

    @property
    def event_time_ms(self) -> int:
        """
        Gets the event_time_ms of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :return: The event_time_ms of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :rtype: int
        """
        return self._event_time_ms

    @event_time_ms.setter
    def event_time_ms(self, event_time_ms: int) -> None:
        """
        Sets the event_time_ms of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.


        :param event_time_ms: The event_time_ms of this V2WebMessagingUndeliveredMessageTopicWebMessagingUndeliveredMessageEventBody.
        :type: int
        """
        

        self._event_time_ms = event_time_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

