# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2WemEngagementCelebrationUpdatesTopicContestMetrics
    from . import V2WemEngagementCelebrationUpdatesTopicContestPrizes
    from . import V2WemEngagementCelebrationUpdatesTopicContestWinners

class V2WemEngagementCelebrationUpdatesTopicContestCompleteData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2WemEngagementCelebrationUpdatesTopicContestCompleteData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_end': 'str',
            'anonymization': 'str',
            'metrics': 'list[V2WemEngagementCelebrationUpdatesTopicContestMetrics]',
            'prizes': 'list[V2WemEngagementCelebrationUpdatesTopicContestPrizes]',
            'winners': 'list[V2WemEngagementCelebrationUpdatesTopicContestWinners]'
        }

        self.attribute_map = {
            'date_end': 'dateEnd',
            'anonymization': 'anonymization',
            'metrics': 'metrics',
            'prizes': 'prizes',
            'winners': 'winners'
        }

        self._date_end = None
        self._anonymization = None
        self._metrics = None
        self._prizes = None
        self._winners = None

    @property
    def date_end(self) -> str:
        """
        Gets the date_end of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :return: The date_end of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :rtype: str
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: str) -> None:
        """
        Sets the date_end of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :param date_end: The date_end of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :type: str
        """
        

        self._date_end = date_end

    @property
    def anonymization(self) -> str:
        """
        Gets the anonymization of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :return: The anonymization of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :rtype: str
        """
        return self._anonymization

    @anonymization.setter
    def anonymization(self, anonymization: str) -> None:
        """
        Sets the anonymization of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :param anonymization: The anonymization of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :type: str
        """
        if isinstance(anonymization, int):
            anonymization = str(anonymization)
        allowed_values = ["UNKNOWN", "NO_ANONYMIZATION", "ALL", "ALL_EXCEPT_TOP"]
        if anonymization.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for anonymization -> " + anonymization)
            self._anonymization = "outdated_sdk_version"
        else:
            self._anonymization = anonymization

    @property
    def metrics(self) -> List['V2WemEngagementCelebrationUpdatesTopicContestMetrics']:
        """
        Gets the metrics of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :return: The metrics of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :rtype: list[V2WemEngagementCelebrationUpdatesTopicContestMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['V2WemEngagementCelebrationUpdatesTopicContestMetrics']) -> None:
        """
        Sets the metrics of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :param metrics: The metrics of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :type: list[V2WemEngagementCelebrationUpdatesTopicContestMetrics]
        """
        

        self._metrics = metrics

    @property
    def prizes(self) -> List['V2WemEngagementCelebrationUpdatesTopicContestPrizes']:
        """
        Gets the prizes of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :return: The prizes of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :rtype: list[V2WemEngagementCelebrationUpdatesTopicContestPrizes]
        """
        return self._prizes

    @prizes.setter
    def prizes(self, prizes: List['V2WemEngagementCelebrationUpdatesTopicContestPrizes']) -> None:
        """
        Sets the prizes of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :param prizes: The prizes of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :type: list[V2WemEngagementCelebrationUpdatesTopicContestPrizes]
        """
        

        self._prizes = prizes

    @property
    def winners(self) -> List['V2WemEngagementCelebrationUpdatesTopicContestWinners']:
        """
        Gets the winners of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :return: The winners of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :rtype: list[V2WemEngagementCelebrationUpdatesTopicContestWinners]
        """
        return self._winners

    @winners.setter
    def winners(self, winners: List['V2WemEngagementCelebrationUpdatesTopicContestWinners']) -> None:
        """
        Sets the winners of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.


        :param winners: The winners of this V2WemEngagementCelebrationUpdatesTopicContestCompleteData.
        :type: list[V2WemEngagementCelebrationUpdatesTopicContestWinners]
        """
        

        self._winners = winners

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

