# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2WemEngagementCelebrationUpdatesTopicSourceEntity
    from . import V2WemEngagementCelebrationUpdatesTopicUserId

class V2WemEngagementCelebrationUpdatesTopicEngagementCelebration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2WemEngagementCelebrationUpdatesTopicEngagementCelebration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'recipient': 'V2WemEngagementCelebrationUpdatesTopicUserId',
            'created_by': 'V2WemEngagementCelebrationUpdatesTopicUserId',
            'date_created': 'str',
            'type': 'str',
            'title': 'str',
            'note': 'str',
            'source_entity': 'V2WemEngagementCelebrationUpdatesTopicSourceEntity'
        }

        self.attribute_map = {
            'id': 'id',
            'recipient': 'recipient',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'type': 'type',
            'title': 'title',
            'note': 'note',
            'source_entity': 'sourceEntity'
        }

        self._id = None
        self._recipient = None
        self._created_by = None
        self._date_created = None
        self._type = None
        self._title = None
        self._note = None
        self._source_entity = None

    @property
    def id(self) -> str:
        """
        Gets the id of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The id of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param id: The id of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: str
        """
        

        self._id = id

    @property
    def recipient(self) -> 'V2WemEngagementCelebrationUpdatesTopicUserId':
        """
        Gets the recipient of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The recipient of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: V2WemEngagementCelebrationUpdatesTopicUserId
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient: 'V2WemEngagementCelebrationUpdatesTopicUserId') -> None:
        """
        Sets the recipient of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param recipient: The recipient of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: V2WemEngagementCelebrationUpdatesTopicUserId
        """
        

        self._recipient = recipient

    @property
    def created_by(self) -> 'V2WemEngagementCelebrationUpdatesTopicUserId':
        """
        Gets the created_by of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The created_by of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: V2WemEngagementCelebrationUpdatesTopicUserId
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'V2WemEngagementCelebrationUpdatesTopicUserId') -> None:
        """
        Sets the created_by of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param created_by: The created_by of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: V2WemEngagementCelebrationUpdatesTopicUserId
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> str:
        """
        Gets the date_created of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The date_created of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: str
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: str) -> None:
        """
        Sets the date_created of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param date_created: The date_created of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: str
        """
        

        self._date_created = date_created

    @property
    def type(self) -> str:
        """
        Gets the type of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The type of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param type: The type of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["UNKNOWN", "RECOGNITION", "CONTEST_COMPLETE"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def title(self) -> str:
        """
        Gets the title of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The title of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param title: The title of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: str
        """
        

        self._title = title

    @property
    def note(self) -> str:
        """
        Gets the note of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The note of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note: str) -> None:
        """
        Sets the note of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param note: The note of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: str
        """
        

        self._note = note

    @property
    def source_entity(self) -> 'V2WemEngagementCelebrationUpdatesTopicSourceEntity':
        """
        Gets the source_entity of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :return: The source_entity of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :rtype: V2WemEngagementCelebrationUpdatesTopicSourceEntity
        """
        return self._source_entity

    @source_entity.setter
    def source_entity(self, source_entity: 'V2WemEngagementCelebrationUpdatesTopicSourceEntity') -> None:
        """
        Sets the source_entity of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.


        :param source_entity: The source_entity of this V2WemEngagementCelebrationUpdatesTopicEngagementCelebration.
        :type: V2WemEngagementCelebrationUpdatesTopicSourceEntity
        """
        

        self._source_entity = source_entity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

