# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class VoicemailEndDetailEventTopicVoicemailEndEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        VoicemailEndDetailEventTopicVoicemailEndEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_time': 'int',
            'conversation_id': 'str',
            'participant_id': 'str',
            'session_id': 'str',
            'disconnect_type': 'str',
            'media_type': 'str',
            'provider': 'str',
            'direction': 'str',
            'ani': 'str',
            'dnis': 'str',
            'user_id': 'str',
            'queue_id': 'str',
            'division_id': 'str',
            'voicemail_duration_ms': 'int',
            'conversation_external_contact_ids': 'list[str]',
            'conversation_external_organization_ids': 'list[str]'
        }

        self.attribute_map = {
            'event_time': 'eventTime',
            'conversation_id': 'conversationId',
            'participant_id': 'participantId',
            'session_id': 'sessionId',
            'disconnect_type': 'disconnectType',
            'media_type': 'mediaType',
            'provider': 'provider',
            'direction': 'direction',
            'ani': 'ani',
            'dnis': 'dnis',
            'user_id': 'userId',
            'queue_id': 'queueId',
            'division_id': 'divisionId',
            'voicemail_duration_ms': 'voicemailDurationMs',
            'conversation_external_contact_ids': 'conversationExternalContactIds',
            'conversation_external_organization_ids': 'conversationExternalOrganizationIds'
        }

        self._event_time = None
        self._conversation_id = None
        self._participant_id = None
        self._session_id = None
        self._disconnect_type = None
        self._media_type = None
        self._provider = None
        self._direction = None
        self._ani = None
        self._dnis = None
        self._user_id = None
        self._queue_id = None
        self._division_id = None
        self._voicemail_duration_ms = None
        self._conversation_external_contact_ids = None
        self._conversation_external_organization_ids = None

    @property
    def event_time(self) -> int:
        """
        Gets the event_time of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The event_time of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: int
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time: int) -> None:
        """
        Sets the event_time of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param event_time: The event_time of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: int
        """
        

        self._event_time = event_time

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The conversation_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param conversation_id: The conversation_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def participant_id(self) -> str:
        """
        Gets the participant_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The participant_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._participant_id

    @participant_id.setter
    def participant_id(self, participant_id: str) -> None:
        """
        Sets the participant_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param participant_id: The participant_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._participant_id = participant_id

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The session_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param session_id: The session_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The disconnect_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param disconnect_type: The disconnect_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["UNKNOWN", "ENDPOINT", "CLIENT", "SYSTEM", "TRANSFER", "ERROR", "PEER", "OTHER", "SPAM", "TIMEOUT", "TRANSPORT_FAILURE", "CONFERENCE_TRANSFER", "CONSULT_TRANSFER", "FORWARD_TRANSFER", "NO_ANSWER_TRANSFER", "NOT_AVAILABLE_TRANSFER", "UNCALLABLE", "DND_ENDPOINT", "DND_TRANSFER", "INACTIVITY"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The media_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param media_type: The media_type of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["UNKNOWN", "VOICE", "CHAT", "EMAIL", "CALLBACK", "COBROWSE", "VIDEO", "SCREENSHARE", "MESSAGE", "INTERNALMESSAGE"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def provider(self) -> str:
        """
        Gets the provider of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The provider of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param provider: The provider of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._provider = provider

    @property
    def direction(self) -> str:
        """
        Gets the direction of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The direction of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param direction: The direction of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["UNKNOWN", "INBOUND", "OUTBOUND"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def ani(self) -> str:
        """
        Gets the ani of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The ani of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._ani

    @ani.setter
    def ani(self, ani: str) -> None:
        """
        Sets the ani of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param ani: The ani of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._ani = ani

    @property
    def dnis(self) -> str:
        """
        Gets the dnis of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The dnis of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._dnis

    @dnis.setter
    def dnis(self, dnis: str) -> None:
        """
        Sets the dnis of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param dnis: The dnis of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._dnis = dnis

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The user_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param user_id: The user_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The queue_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param queue_id: The queue_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def division_id(self) -> str:
        """
        Gets the division_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The division_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id: str) -> None:
        """
        Sets the division_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param division_id: The division_id of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def voicemail_duration_ms(self) -> int:
        """
        Gets the voicemail_duration_ms of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The voicemail_duration_ms of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: int
        """
        return self._voicemail_duration_ms

    @voicemail_duration_ms.setter
    def voicemail_duration_ms(self, voicemail_duration_ms: int) -> None:
        """
        Sets the voicemail_duration_ms of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param voicemail_duration_ms: The voicemail_duration_ms of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: int
        """
        

        self._voicemail_duration_ms = voicemail_duration_ms

    @property
    def conversation_external_contact_ids(self) -> List[str]:
        """
        Gets the conversation_external_contact_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The conversation_external_contact_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: list[str]
        """
        return self._conversation_external_contact_ids

    @conversation_external_contact_ids.setter
    def conversation_external_contact_ids(self, conversation_external_contact_ids: List[str]) -> None:
        """
        Sets the conversation_external_contact_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param conversation_external_contact_ids: The conversation_external_contact_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: list[str]
        """
        

        self._conversation_external_contact_ids = conversation_external_contact_ids

    @property
    def conversation_external_organization_ids(self) -> List[str]:
        """
        Gets the conversation_external_organization_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :return: The conversation_external_organization_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :rtype: list[str]
        """
        return self._conversation_external_organization_ids

    @conversation_external_organization_ids.setter
    def conversation_external_organization_ids(self, conversation_external_organization_ids: List[str]) -> None:
        """
        Sets the conversation_external_organization_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.


        :param conversation_external_organization_ids: The conversation_external_organization_ids of this VoicemailEndDetailEventTopicVoicemailEndEvent.
        :type: list[str]
        """
        

        self._conversation_external_organization_ids = conversation_external_organization_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

