# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import PINConfiguration

class VoicemailOrganizationPolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        VoicemailOrganizationPolicy - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'alert_timeout_seconds': 'int',
            'pin_configuration': 'PINConfiguration',
            'voicemail_extension': 'str',
            'pin_required': 'bool',
            'interactive_response_required': 'bool',
            'send_email_notifications': 'bool',
            'include_email_transcriptions': 'bool',
            'disable_email_pii': 'bool',
            'maximum_recording_time_seconds': 'int',
            'modified_date': 'datetime'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'alert_timeout_seconds': 'alertTimeoutSeconds',
            'pin_configuration': 'pinConfiguration',
            'voicemail_extension': 'voicemailExtension',
            'pin_required': 'pinRequired',
            'interactive_response_required': 'interactiveResponseRequired',
            'send_email_notifications': 'sendEmailNotifications',
            'include_email_transcriptions': 'includeEmailTranscriptions',
            'disable_email_pii': 'disableEmailPii',
            'maximum_recording_time_seconds': 'maximumRecordingTimeSeconds',
            'modified_date': 'modifiedDate'
        }

        self._enabled = None
        self._alert_timeout_seconds = None
        self._pin_configuration = None
        self._voicemail_extension = None
        self._pin_required = None
        self._interactive_response_required = None
        self._send_email_notifications = None
        self._include_email_transcriptions = None
        self._disable_email_pii = None
        self._maximum_recording_time_seconds = None
        self._modified_date = None

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this VoicemailOrganizationPolicy.
        Whether voicemail is enabled for this organization

        :return: The enabled of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this VoicemailOrganizationPolicy.
        Whether voicemail is enabled for this organization

        :param enabled: The enabled of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def alert_timeout_seconds(self) -> int:
        """
        Gets the alert_timeout_seconds of this VoicemailOrganizationPolicy.
        The organization's default number of seconds to ring a user's phone before a call is transferred to voicemail

        :return: The alert_timeout_seconds of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._alert_timeout_seconds

    @alert_timeout_seconds.setter
    def alert_timeout_seconds(self, alert_timeout_seconds: int) -> None:
        """
        Sets the alert_timeout_seconds of this VoicemailOrganizationPolicy.
        The organization's default number of seconds to ring a user's phone before a call is transferred to voicemail

        :param alert_timeout_seconds: The alert_timeout_seconds of this VoicemailOrganizationPolicy.
        :type: int
        """
        

        self._alert_timeout_seconds = alert_timeout_seconds

    @property
    def pin_configuration(self) -> 'PINConfiguration':
        """
        Gets the pin_configuration of this VoicemailOrganizationPolicy.
        The configuration for user PINs to access their voicemail from a phone

        :return: The pin_configuration of this VoicemailOrganizationPolicy.
        :rtype: PINConfiguration
        """
        return self._pin_configuration

    @pin_configuration.setter
    def pin_configuration(self, pin_configuration: 'PINConfiguration') -> None:
        """
        Sets the pin_configuration of this VoicemailOrganizationPolicy.
        The configuration for user PINs to access their voicemail from a phone

        :param pin_configuration: The pin_configuration of this VoicemailOrganizationPolicy.
        :type: PINConfiguration
        """
        

        self._pin_configuration = pin_configuration

    @property
    def voicemail_extension(self) -> str:
        """
        Gets the voicemail_extension of this VoicemailOrganizationPolicy.
        The extension for voicemail retrieval.  The default value is *86.

        :return: The voicemail_extension of this VoicemailOrganizationPolicy.
        :rtype: str
        """
        return self._voicemail_extension

    @voicemail_extension.setter
    def voicemail_extension(self, voicemail_extension: str) -> None:
        """
        Sets the voicemail_extension of this VoicemailOrganizationPolicy.
        The extension for voicemail retrieval.  The default value is *86.

        :param voicemail_extension: The voicemail_extension of this VoicemailOrganizationPolicy.
        :type: str
        """
        

        self._voicemail_extension = voicemail_extension

    @property
    def pin_required(self) -> bool:
        """
        Gets the pin_required of this VoicemailOrganizationPolicy.
        If this is true, a PIN is required when accessing a user's voicemail from a phone.

        :return: The pin_required of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._pin_required

    @pin_required.setter
    def pin_required(self, pin_required: bool) -> None:
        """
        Sets the pin_required of this VoicemailOrganizationPolicy.
        If this is true, a PIN is required when accessing a user's voicemail from a phone.

        :param pin_required: The pin_required of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._pin_required = pin_required

    @property
    def interactive_response_required(self) -> bool:
        """
        Gets the interactive_response_required of this VoicemailOrganizationPolicy.
        Whether user should be prompted with a confirmation prompt when connecting to a Group Ring call

        :return: The interactive_response_required of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._interactive_response_required

    @interactive_response_required.setter
    def interactive_response_required(self, interactive_response_required: bool) -> None:
        """
        Sets the interactive_response_required of this VoicemailOrganizationPolicy.
        Whether user should be prompted with a confirmation prompt when connecting to a Group Ring call

        :param interactive_response_required: The interactive_response_required of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._interactive_response_required = interactive_response_required

    @property
    def send_email_notifications(self) -> bool:
        """
        Gets the send_email_notifications of this VoicemailOrganizationPolicy.
        Whether email notifications are sent for new voicemails in the organization. If false, new voicemail email notifications are not be sent for the organization overriding any user or group setting.

        :return: The send_email_notifications of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._send_email_notifications

    @send_email_notifications.setter
    def send_email_notifications(self, send_email_notifications: bool) -> None:
        """
        Sets the send_email_notifications of this VoicemailOrganizationPolicy.
        Whether email notifications are sent for new voicemails in the organization. If false, new voicemail email notifications are not be sent for the organization overriding any user or group setting.

        :param send_email_notifications: The send_email_notifications of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._send_email_notifications = send_email_notifications

    @property
    def include_email_transcriptions(self) -> bool:
        """
        Gets the include_email_transcriptions of this VoicemailOrganizationPolicy.
        Whether to include the voicemail transcription in the notification email

        :return: The include_email_transcriptions of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._include_email_transcriptions

    @include_email_transcriptions.setter
    def include_email_transcriptions(self, include_email_transcriptions: bool) -> None:
        """
        Sets the include_email_transcriptions of this VoicemailOrganizationPolicy.
        Whether to include the voicemail transcription in the notification email

        :param include_email_transcriptions: The include_email_transcriptions of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._include_email_transcriptions = include_email_transcriptions

    @property
    def disable_email_pii(self) -> bool:
        """
        Gets the disable_email_pii of this VoicemailOrganizationPolicy.
        Removes any PII from emails. This overrides any analogous group configuration value. This is always true if HIPAA is enabled or unknown for an organization.

        :return: The disable_email_pii of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._disable_email_pii

    @disable_email_pii.setter
    def disable_email_pii(self, disable_email_pii: bool) -> None:
        """
        Sets the disable_email_pii of this VoicemailOrganizationPolicy.
        Removes any PII from emails. This overrides any analogous group configuration value. This is always true if HIPAA is enabled or unknown for an organization.

        :param disable_email_pii: The disable_email_pii of this VoicemailOrganizationPolicy.
        :type: bool
        """
        

        self._disable_email_pii = disable_email_pii

    @property
    def maximum_recording_time_seconds(self) -> int:
        """
        Gets the maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        Default value for the maximum length of time in seconds of a recorded voicemail

        :return: The maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._maximum_recording_time_seconds

    @maximum_recording_time_seconds.setter
    def maximum_recording_time_seconds(self, maximum_recording_time_seconds: int) -> None:
        """
        Sets the maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        Default value for the maximum length of time in seconds of a recorded voicemail

        :param maximum_recording_time_seconds: The maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :type: int
        """
        

        self._maximum_recording_time_seconds = maximum_recording_time_seconds

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this VoicemailOrganizationPolicy.
        The date the policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The modified_date of this VoicemailOrganizationPolicy.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this VoicemailOrganizationPolicy.
        The date the policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param modified_date: The modified_date of this VoicemailOrganizationPolicy.
        :type: datetime
        """
        

        self._modified_date = modified_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

