# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Warning(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Warning - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'value': 'int',
            'range_type': 'str',
            'color': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'range_type': 'rangeType',
            'color': 'color'
        }

        self._value = None
        self._range_type = None
        self._color = None

    @property
    def value(self) -> int:
        """
        Gets the value of this Warning.
        The value for the warning configuration.

        :return: The value of this Warning.
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value: int) -> None:
        """
        Sets the value of this Warning.
        The value for the warning configuration.

        :param value: The value of this Warning.
        :type: int
        """
        

        self._value = value

    @property
    def range_type(self) -> str:
        """
        Gets the range_type of this Warning.
        The range type for the warning configuration.

        :return: The range_type of this Warning.
        :rtype: str
        """
        return self._range_type

    @range_type.setter
    def range_type(self, range_type: str) -> None:
        """
        Sets the range_type of this Warning.
        The range type for the warning configuration.

        :param range_type: The range_type of this Warning.
        :type: str
        """
        if isinstance(range_type, int):
            range_type = str(range_type)
        allowed_values = ["OVER", "UNDER", "BETWEEN"]
        if range_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for range_type -> " + range_type)
            self._range_type = "outdated_sdk_version"
        else:
            self._range_type = range_type

    @property
    def color(self) -> str:
        """
        Gets the color of this Warning.
        The color for the warning configuration in RGB hexadecimal format (for example \"#FF0000\" represents red).

        :return: The color of this Warning.
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color: str) -> None:
        """
        Sets the color of this Warning.
        The color for the warning configuration in RGB hexadecimal format (for example \"#FF0000\" represents red).

        :param color: The color of this Warning.
        :type: str
        """
        

        self._color = color

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

