# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FlowVersion

class WebDeploymentFlowEntityRef(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebDeploymentFlowEntityRef - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'self_uri': 'str',
            'flow_description': 'str',
            'publish_version': 'FlowVersion'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'self_uri': 'selfUri',
            'flow_description': 'flowDescription',
            'publish_version': 'publishVersion'
        }

        self._id = None
        self._name = None
        self._self_uri = None
        self._flow_description = None
        self._publish_version = None

    @property
    def id(self) -> str:
        """
        Gets the id of this WebDeploymentFlowEntityRef.
        The Flow ID

        :return: The id of this WebDeploymentFlowEntityRef.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WebDeploymentFlowEntityRef.
        The Flow ID

        :param id: The id of this WebDeploymentFlowEntityRef.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this WebDeploymentFlowEntityRef.
        The Flow name

        :return: The name of this WebDeploymentFlowEntityRef.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WebDeploymentFlowEntityRef.
        The Flow name

        :param name: The name of this WebDeploymentFlowEntityRef.
        :type: str
        """
        

        self._name = name

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this WebDeploymentFlowEntityRef.


        :return: The self_uri of this WebDeploymentFlowEntityRef.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this WebDeploymentFlowEntityRef.


        :param self_uri: The self_uri of this WebDeploymentFlowEntityRef.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def flow_description(self) -> str:
        """
        Gets the flow_description of this WebDeploymentFlowEntityRef.
        The flow description for the webdeployment

        :return: The flow_description of this WebDeploymentFlowEntityRef.
        :rtype: str
        """
        return self._flow_description

    @flow_description.setter
    def flow_description(self, flow_description: str) -> None:
        """
        Sets the flow_description of this WebDeploymentFlowEntityRef.
        The flow description for the webdeployment

        :param flow_description: The flow_description of this WebDeploymentFlowEntityRef.
        :type: str
        """
        

        self._flow_description = flow_description

    @property
    def publish_version(self) -> 'FlowVersion':
        """
        Gets the publish_version of this WebDeploymentFlowEntityRef.
        The published config version for the associated deployment

        :return: The publish_version of this WebDeploymentFlowEntityRef.
        :rtype: FlowVersion
        """
        return self._publish_version

    @publish_version.setter
    def publish_version(self, publish_version: 'FlowVersion') -> None:
        """
        Sets the publish_version of this WebDeploymentFlowEntityRef.
        The published config version for the associated deployment

        :param publish_version: The publish_version of this WebDeploymentFlowEntityRef.
        :type: FlowVersion
        """
        

        self._publish_version = publish_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

