# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Browser
    from . import CustomEventAttribute
    from . import Device
    from . import JourneyCampaign
    from . import JourneyGeolocation
    from . import JourneyPage
    from . import Referrer

class WebEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_name': 'str',
            'total_event_count': 'int',
            'total_pageview_count': 'int',
            'page': 'JourneyPage',
            'user_agent_string': 'str',
            'browser': 'Browser',
            'device': 'Device',
            'geolocation': 'JourneyGeolocation',
            'ip_address': 'str',
            'ip_organization': 'str',
            'mkt_campaign': 'JourneyCampaign',
            'referrer': 'Referrer',
            'attributes': 'dict(str, CustomEventAttribute)',
            'traits': 'dict(str, CustomEventAttribute)',
            'search_query': 'str',
            'authenticated': 'bool'
        }

        self.attribute_map = {
            'event_name': 'eventName',
            'total_event_count': 'totalEventCount',
            'total_pageview_count': 'totalPageviewCount',
            'page': 'page',
            'user_agent_string': 'userAgentString',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'mkt_campaign': 'mktCampaign',
            'referrer': 'referrer',
            'attributes': 'attributes',
            'traits': 'traits',
            'search_query': 'searchQuery',
            'authenticated': 'authenticated'
        }

        self._event_name = None
        self._total_event_count = None
        self._total_pageview_count = None
        self._page = None
        self._user_agent_string = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._ip_address = None
        self._ip_organization = None
        self._mkt_campaign = None
        self._referrer = None
        self._attributes = None
        self._traits = None
        self._search_query = None
        self._authenticated = None

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this WebEvent.
        Represents the action the customer performed. A good event name is typically an object followed by the action performed in past tense (e.g. page_viewed, order_completed, user_registered).

        :return: The event_name of this WebEvent.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this WebEvent.
        Represents the action the customer performed. A good event name is typically an object followed by the action performed in past tense (e.g. page_viewed, order_completed, user_registered).

        :param event_name: The event_name of this WebEvent.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def total_event_count(self) -> int:
        """
        Gets the total_event_count of this WebEvent.
        The total count of events performed by the customer across all sessions.

        :return: The total_event_count of this WebEvent.
        :rtype: int
        """
        return self._total_event_count

    @total_event_count.setter
    def total_event_count(self, total_event_count: int) -> None:
        """
        Sets the total_event_count of this WebEvent.
        The total count of events performed by the customer across all sessions.

        :param total_event_count: The total_event_count of this WebEvent.
        :type: int
        """
        

        self._total_event_count = total_event_count

    @property
    def total_pageview_count(self) -> int:
        """
        Gets the total_pageview_count of this WebEvent.
        The total count of pageviews performed by the customer across all sessions.

        :return: The total_pageview_count of this WebEvent.
        :rtype: int
        """
        return self._total_pageview_count

    @total_pageview_count.setter
    def total_pageview_count(self, total_pageview_count: int) -> None:
        """
        Sets the total_pageview_count of this WebEvent.
        The total count of pageviews performed by the customer across all sessions.

        :param total_pageview_count: The total_pageview_count of this WebEvent.
        :type: int
        """
        

        self._total_pageview_count = total_pageview_count

    @property
    def page(self) -> 'JourneyPage':
        """
        Gets the page of this WebEvent.
        The webpage where the user interaction occurred.

        :return: The page of this WebEvent.
        :rtype: JourneyPage
        """
        return self._page

    @page.setter
    def page(self, page: 'JourneyPage') -> None:
        """
        Sets the page of this WebEvent.
        The webpage where the user interaction occurred.

        :param page: The page of this WebEvent.
        :type: JourneyPage
        """
        

        self._page = page

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this WebEvent.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :return: The user_agent_string of this WebEvent.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this WebEvent.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :param user_agent_string: The user_agent_string of this WebEvent.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def browser(self) -> 'Browser':
        """
        Gets the browser of this WebEvent.
        Customer's browser.

        :return: The browser of this WebEvent.
        :rtype: Browser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'Browser') -> None:
        """
        Sets the browser of this WebEvent.
        Customer's browser.

        :param browser: The browser of this WebEvent.
        :type: Browser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'Device':
        """
        Gets the device of this WebEvent.
        Customer's device.

        :return: The device of this WebEvent.
        :rtype: Device
        """
        return self._device

    @device.setter
    def device(self, device: 'Device') -> None:
        """
        Sets the device of this WebEvent.
        Customer's device.

        :param device: The device of this WebEvent.
        :type: Device
        """
        

        self._device = device

    @property
    def geolocation(self) -> 'JourneyGeolocation':
        """
        Gets the geolocation of this WebEvent.
        Customer's geolocation.

        :return: The geolocation of this WebEvent.
        :rtype: JourneyGeolocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyGeolocation') -> None:
        """
        Sets the geolocation of this WebEvent.
        Customer's geolocation.

        :param geolocation: The geolocation of this WebEvent.
        :type: JourneyGeolocation
        """
        

        self._geolocation = geolocation

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this WebEvent.
        Customer's IP address. May be null if the business configures the tracker to not collect IP addresses.

        :return: The ip_address of this WebEvent.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this WebEvent.
        Customer's IP address. May be null if the business configures the tracker to not collect IP addresses.

        :param ip_address: The ip_address of this WebEvent.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this WebEvent.
        Customer's IP-based organization or ISP name.

        :return: The ip_organization of this WebEvent.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this WebEvent.
        Customer's IP-based organization or ISP name.

        :param ip_organization: The ip_organization of this WebEvent.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def mkt_campaign(self) -> 'JourneyCampaign':
        """
        Gets the mkt_campaign of this WebEvent.
        Marketing / traffic source information.

        :return: The mkt_campaign of this WebEvent.
        :rtype: JourneyCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyCampaign') -> None:
        """
        Sets the mkt_campaign of this WebEvent.
        Marketing / traffic source information.

        :param mkt_campaign: The mkt_campaign of this WebEvent.
        :type: JourneyCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def referrer(self) -> 'Referrer':
        """
        Gets the referrer of this WebEvent.
        Identifies the page URL that originally generated the request for the current page being viewed.

        :return: The referrer of this WebEvent.
        :rtype: Referrer
        """
        return self._referrer

    @referrer.setter
    def referrer(self, referrer: 'Referrer') -> None:
        """
        Sets the referrer of this WebEvent.
        Identifies the page URL that originally generated the request for the current page being viewed.

        :param referrer: The referrer of this WebEvent.
        :type: Referrer
        """
        

        self._referrer = referrer

    @property
    def attributes(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the attributes of this WebEvent.
        User-defined attributes associated with a particular event.

        :return: The attributes of this WebEvent.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the attributes of this WebEvent.
        User-defined attributes associated with a particular event.

        :param attributes: The attributes of this WebEvent.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._attributes = attributes

    @property
    def traits(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the traits of this WebEvent.
        User-defined traits associated with a particular event.

        :return: The traits of this WebEvent.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._traits

    @traits.setter
    def traits(self, traits: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the traits of this WebEvent.
        User-defined traits associated with a particular event.

        :param traits: The traits of this WebEvent.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._traits = traits

    @property
    def search_query(self) -> str:
        """
        Gets the search_query of this WebEvent.
        Represents the keywords in a customer search query.

        :return: The search_query of this WebEvent.
        :rtype: str
        """
        return self._search_query

    @search_query.setter
    def search_query(self, search_query: str) -> None:
        """
        Sets the search_query of this WebEvent.
        Represents the keywords in a customer search query.

        :param search_query: The search_query of this WebEvent.
        :type: str
        """
        

        self._search_query = search_query

    @property
    def authenticated(self) -> bool:
        """
        Gets the authenticated of this WebEvent.
        Indicates whether the event was produced during an authenticated session.

        :return: The authenticated of this WebEvent.
        :rtype: bool
        """
        return self._authenticated

    @authenticated.setter
    def authenticated(self, authenticated: bool) -> None:
        """
        Sets the authenticated of this WebEvent.
        Indicates whether the event was produced during an authenticated session.

        :param authenticated: The authenticated of this WebEvent.
        :type: bool
        """
        

        self._authenticated = authenticated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

