# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CustomEventAttribute
    from . import RequestPage
    from . import WebEventBrowser
    from . import WebEventDevice

class WebEventRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebEventRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'customer_cookie_id': 'str',
            'event_name': 'str',
            'page': 'RequestPage',
            'user_agent_string': 'str',
            'browser': 'WebEventBrowser',
            'device': 'WebEventDevice',
            'search_query': 'str',
            'ip_address': 'str',
            'referrer_url': 'str',
            'attributes': 'dict(str, CustomEventAttribute)',
            'traits': 'dict(str, CustomEventAttribute)',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'customer_cookie_id': 'customerCookieId',
            'event_name': 'eventName',
            'page': 'page',
            'user_agent_string': 'userAgentString',
            'browser': 'browser',
            'device': 'device',
            'search_query': 'searchQuery',
            'ip_address': 'ipAddress',
            'referrer_url': 'referrerUrl',
            'attributes': 'attributes',
            'traits': 'traits',
            'created_date': 'createdDate'
        }

        self._customer_cookie_id = None
        self._event_name = None
        self._page = None
        self._user_agent_string = None
        self._browser = None
        self._device = None
        self._search_query = None
        self._ip_address = None
        self._referrer_url = None
        self._attributes = None
        self._traits = None
        self._created_date = None

    @property
    def customer_cookie_id(self) -> str:
        """
        Gets the customer_cookie_id of this WebEventRequest.
        A UUID representing the customer making the request.

        :return: The customer_cookie_id of this WebEventRequest.
        :rtype: str
        """
        return self._customer_cookie_id

    @customer_cookie_id.setter
    def customer_cookie_id(self, customer_cookie_id: str) -> None:
        """
        Sets the customer_cookie_id of this WebEventRequest.
        A UUID representing the customer making the request.

        :param customer_cookie_id: The customer_cookie_id of this WebEventRequest.
        :type: str
        """
        

        self._customer_cookie_id = customer_cookie_id

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this WebEventRequest.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.

        :return: The event_name of this WebEventRequest.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this WebEventRequest.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.

        :param event_name: The event_name of this WebEventRequest.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def page(self) -> 'RequestPage':
        """
        Gets the page of this WebEventRequest.
        The webpage where the user interaction occurred.

        :return: The page of this WebEventRequest.
        :rtype: RequestPage
        """
        return self._page

    @page.setter
    def page(self, page: 'RequestPage') -> None:
        """
        Sets the page of this WebEventRequest.
        The webpage where the user interaction occurred.

        :param page: The page of this WebEventRequest.
        :type: RequestPage
        """
        

        self._page = page

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this WebEventRequest.
        Override for HTTP User-Agent string from request header (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :return: The user_agent_string of this WebEventRequest.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this WebEventRequest.
        Override for HTTP User-Agent string from request header (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :param user_agent_string: The user_agent_string of this WebEventRequest.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def browser(self) -> 'WebEventBrowser':
        """
        Gets the browser of this WebEventRequest.
        Customer's browser.

        :return: The browser of this WebEventRequest.
        :rtype: WebEventBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'WebEventBrowser') -> None:
        """
        Sets the browser of this WebEventRequest.
        Customer's browser.

        :param browser: The browser of this WebEventRequest.
        :type: WebEventBrowser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'WebEventDevice':
        """
        Gets the device of this WebEventRequest.
        Customer's device.

        :return: The device of this WebEventRequest.
        :rtype: WebEventDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'WebEventDevice') -> None:
        """
        Sets the device of this WebEventRequest.
        Customer's device.

        :param device: The device of this WebEventRequest.
        :type: WebEventDevice
        """
        

        self._device = device

    @property
    def search_query(self) -> str:
        """
        Gets the search_query of this WebEventRequest.
        Represents the keywords in a customer search query.

        :return: The search_query of this WebEventRequest.
        :rtype: str
        """
        return self._search_query

    @search_query.setter
    def search_query(self, search_query: str) -> None:
        """
        Sets the search_query of this WebEventRequest.
        Represents the keywords in a customer search query.

        :param search_query: The search_query of this WebEventRequest.
        :type: str
        """
        

        self._search_query = search_query

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this WebEventRequest.
        Customer's IP address.

        :return: The ip_address of this WebEventRequest.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this WebEventRequest.
        Customer's IP address.

        :param ip_address: The ip_address of this WebEventRequest.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def referrer_url(self) -> str:
        """
        Gets the referrer_url of this WebEventRequest.
        Identifies the referrer URL that originally generated the request for the current page being viewed.

        :return: The referrer_url of this WebEventRequest.
        :rtype: str
        """
        return self._referrer_url

    @referrer_url.setter
    def referrer_url(self, referrer_url: str) -> None:
        """
        Sets the referrer_url of this WebEventRequest.
        Identifies the referrer URL that originally generated the request for the current page being viewed.

        :param referrer_url: The referrer_url of this WebEventRequest.
        :type: str
        """
        

        self._referrer_url = referrer_url

    @property
    def attributes(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the attributes of this WebEventRequest.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :return: The attributes of this WebEventRequest.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the attributes of this WebEventRequest.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :param attributes: The attributes of this WebEventRequest.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._attributes = attributes

    @property
    def traits(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the traits of this WebEventRequest.
        Traits are attributes intrinsic to the customer that may be sent in selected events, e.g. email, givenName, cellPhone. Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :return: The traits of this WebEventRequest.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._traits

    @traits.setter
    def traits(self, traits: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the traits of this WebEventRequest.
        Traits are attributes intrinsic to the customer that may be sent in selected events, e.g. email, givenName, cellPhone. Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :param traits: The traits of this WebEventRequest.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._traits = traits

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this WebEventRequest.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this WebEventRequest.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this WebEventRequest.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this WebEventRequest.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

