# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WebMessagingRecipient

class WebMessagingChannel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebMessagingChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'pcFrom': 'WebMessagingRecipient',
            'to': 'WebMessagingRecipient',
            'time': 'datetime',
            'message_id': 'str'
        }

        self.attribute_map = {
            'pcFrom': 'from',
            'to': 'to',
            'time': 'time',
            'message_id': 'messageId'
        }

        self._pcFrom = None
        self._to = None
        self._time = None
        self._message_id = None

    @property
    def pcFrom(self) -> 'WebMessagingRecipient':
        """
        Gets the pcFrom of this WebMessagingChannel.
        Information about the recipient the message is received from.

        :return: The pcFrom of this WebMessagingChannel.
        :rtype: WebMessagingRecipient
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: 'WebMessagingRecipient') -> None:
        """
        Sets the pcFrom of this WebMessagingChannel.
        Information about the recipient the message is received from.

        :param pcFrom: The pcFrom of this WebMessagingChannel.
        :type: WebMessagingRecipient
        """
        

        self._pcFrom = pcFrom

    @property
    def to(self) -> 'WebMessagingRecipient':
        """
        Gets the to of this WebMessagingChannel.
        Information about the recipient the message is sent to.

        :return: The to of this WebMessagingChannel.
        :rtype: WebMessagingRecipient
        """
        return self._to

    @to.setter
    def to(self, to: 'WebMessagingRecipient') -> None:
        """
        Sets the to of this WebMessagingChannel.
        Information about the recipient the message is sent to.

        :param to: The to of this WebMessagingChannel.
        :type: WebMessagingRecipient
        """
        

        self._to = to

    @property
    def time(self) -> datetime:
        """
        Gets the time of this WebMessagingChannel.
        When the message was processed by Genesys Cloud. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The time of this WebMessagingChannel.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time: datetime) -> None:
        """
        Sets the time of this WebMessagingChannel.
        When the message was processed by Genesys Cloud. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param time: The time of this WebMessagingChannel.
        :type: datetime
        """
        

        self._time = time

    @property
    def message_id(self) -> str:
        """
        Gets the message_id of this WebMessagingChannel.
        Unique provider ID of the message.

        :return: The message_id of this WebMessagingChannel.
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id: str) -> None:
        """
        Sets the message_id of this WebMessagingChannel.
        Unique provider ID of the message.

        :param message_id: The message_id of this WebMessagingChannel.
        :type: str
        """
        

        self._message_id = message_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

