# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WemCoachingUserNotificationTopicCoachingAppointmentReference

class WemCoachingUserNotificationTopicCoachingUserNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WemCoachingUserNotificationTopicCoachingUserNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'marked_as_read': 'bool',
            'action_type': 'str',
            'relationship': 'str',
            'appointment': 'WemCoachingUserNotificationTopicCoachingAppointmentReference',
            'date_start': 'datetime',
            'length_in_minutes': 'int',
            'status': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'marked_as_read': 'markedAsRead',
            'action_type': 'actionType',
            'relationship': 'relationship',
            'appointment': 'appointment',
            'date_start': 'dateStart',
            'length_in_minutes': 'lengthInMinutes',
            'status': 'status'
        }

        self._id = None
        self._name = None
        self._marked_as_read = None
        self._action_type = None
        self._relationship = None
        self._appointment = None
        self._date_start = None
        self._length_in_minutes = None
        self._status = None

    @property
    def id(self) -> str:
        """
        Gets the id of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The id of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param id: The id of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The name of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param name: The name of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: str
        """
        

        self._name = name

    @property
    def marked_as_read(self) -> bool:
        """
        Gets the marked_as_read of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The marked_as_read of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: bool
        """
        return self._marked_as_read

    @marked_as_read.setter
    def marked_as_read(self, marked_as_read: bool) -> None:
        """
        Sets the marked_as_read of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param marked_as_read: The marked_as_read of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: bool
        """
        

        self._marked_as_read = marked_as_read

    @property
    def action_type(self) -> str:
        """
        Gets the action_type of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The action_type of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type: str) -> None:
        """
        Sets the action_type of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param action_type: The action_type of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: str
        """
        if isinstance(action_type, int):
            action_type = str(action_type)
        allowed_values = ["Create", "Update", "Delete", "StatusChange"]
        if action_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action_type -> " + action_type)
            self._action_type = "outdated_sdk_version"
        else:
            self._action_type = action_type

    @property
    def relationship(self) -> str:
        """
        Gets the relationship of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The relationship of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship: str) -> None:
        """
        Sets the relationship of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param relationship: The relationship of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: str
        """
        if isinstance(relationship, int):
            relationship = str(relationship)
        allowed_values = ["Attendee", "Facilitator", "Creator"]
        if relationship.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for relationship -> " + relationship)
            self._relationship = "outdated_sdk_version"
        else:
            self._relationship = relationship

    @property
    def appointment(self) -> 'WemCoachingUserNotificationTopicCoachingAppointmentReference':
        """
        Gets the appointment of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The appointment of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: WemCoachingUserNotificationTopicCoachingAppointmentReference
        """
        return self._appointment

    @appointment.setter
    def appointment(self, appointment: 'WemCoachingUserNotificationTopicCoachingAppointmentReference') -> None:
        """
        Sets the appointment of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param appointment: The appointment of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: WemCoachingUserNotificationTopicCoachingAppointmentReference
        """
        

        self._appointment = appointment

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The date_start of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param date_start: The date_start of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The length_in_minutes of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param length_in_minutes: The length_in_minutes of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    @property
    def status(self) -> str:
        """
        Gets the status of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :return: The status of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this WemCoachingUserNotificationTopicCoachingUserNotification.


        :param status: The status of this WemCoachingUserNotificationTopicCoachingUserNotification.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Scheduled", "InProgress", "Completed", "InvalidSchedule"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

