# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification
    from . import WfmAdherenceExplanationJobCompleteTopicErrorBody

class WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'status': 'str',
            'adherence_explanation': 'WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification',
            'download_url': 'str',
            'error': 'WfmAdherenceExplanationJobCompleteTopicErrorBody'
        }

        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'status': 'status',
            'adherence_explanation': 'adherenceExplanation',
            'download_url': 'downloadUrl',
            'error': 'error'
        }

        self._id = None
        self._type = None
        self._status = None
        self._adherence_explanation = None
        self._download_url = None
        self._error = None

    @property
    def id(self) -> str:
        """
        Gets the id of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The id of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param id: The id of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: str
        """
        

        self._id = id

    @property
    def type(self) -> str:
        """
        Gets the type of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The type of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param type: The type of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["AddExplanation", "UpdateExplanation", "QueryAgentExplanations", "QueryBuExplanations"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def status(self) -> str:
        """
        Gets the status of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The status of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param status: The status of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Processing", "Complete", "Error"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def adherence_explanation(self) -> 'WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification':
        """
        Gets the adherence_explanation of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The adherence_explanation of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification
        """
        return self._adherence_explanation

    @adherence_explanation.setter
    def adherence_explanation(self, adherence_explanation: 'WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification') -> None:
        """
        Sets the adherence_explanation of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param adherence_explanation: The adherence_explanation of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationChangedNotification
        """
        

        self._adherence_explanation = adherence_explanation

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The download_url of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param download_url: The download_url of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def error(self) -> 'WfmAdherenceExplanationJobCompleteTopicErrorBody':
        """
        Gets the error of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :return: The error of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :rtype: WfmAdherenceExplanationJobCompleteTopicErrorBody
        """
        return self._error

    @error.setter
    def error(self, error: 'WfmAdherenceExplanationJobCompleteTopicErrorBody') -> None:
        """
        Sets the error of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.


        :param error: The error of this WfmAdherenceExplanationJobCompleteTopicAdherenceExplanationJobNotification.
        :type: WfmAdherenceExplanationJobCompleteTopicErrorBody
        """
        

        self._error = error

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

