# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WfmHistoricalAdherenceBulkUserDayMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmHistoricalAdherenceBulkUserDayMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'day_start_offset_seconds': 'int',
            'adherence_schedule_seconds': 'int',
            'conformance_schedule_seconds': 'int',
            'conformance_actual_seconds': 'int',
            'exception_count': 'int',
            'exception_duration_seconds': 'int',
            'impact_seconds': 'int',
            'schedule_length_seconds': 'int',
            'actual_length_seconds': 'int',
            'adherence_percentage': 'float',
            'conformance_percentage': 'float'
        }

        self.attribute_map = {
            'day_start_offset_seconds': 'dayStartOffsetSeconds',
            'adherence_schedule_seconds': 'adherenceScheduleSeconds',
            'conformance_schedule_seconds': 'conformanceScheduleSeconds',
            'conformance_actual_seconds': 'conformanceActualSeconds',
            'exception_count': 'exceptionCount',
            'exception_duration_seconds': 'exceptionDurationSeconds',
            'impact_seconds': 'impactSeconds',
            'schedule_length_seconds': 'scheduleLengthSeconds',
            'actual_length_seconds': 'actualLengthSeconds',
            'adherence_percentage': 'adherencePercentage',
            'conformance_percentage': 'conformancePercentage'
        }

        self._day_start_offset_seconds = None
        self._adherence_schedule_seconds = None
        self._conformance_schedule_seconds = None
        self._conformance_actual_seconds = None
        self._exception_count = None
        self._exception_duration_seconds = None
        self._impact_seconds = None
        self._schedule_length_seconds = None
        self._actual_length_seconds = None
        self._adherence_percentage = None
        self._conformance_percentage = None

    @property
    def day_start_offset_seconds(self) -> int:
        """
        Gets the day_start_offset_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Start of day offset in seconds relative to query start time

        :return: The day_start_offset_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._day_start_offset_seconds

    @day_start_offset_seconds.setter
    def day_start_offset_seconds(self, day_start_offset_seconds: int) -> None:
        """
        Sets the day_start_offset_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Start of day offset in seconds relative to query start time

        :param day_start_offset_seconds: The day_start_offset_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._day_start_offset_seconds = day_start_offset_seconds

    @property
    def adherence_schedule_seconds(self) -> int:
        """
        Gets the adherence_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Duration of schedule in seconds included for adherence percentage calculation

        :return: The adherence_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._adherence_schedule_seconds

    @adherence_schedule_seconds.setter
    def adherence_schedule_seconds(self, adherence_schedule_seconds: int) -> None:
        """
        Sets the adherence_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Duration of schedule in seconds included for adherence percentage calculation

        :param adherence_schedule_seconds: The adherence_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._adherence_schedule_seconds = adherence_schedule_seconds

    @property
    def conformance_schedule_seconds(self) -> int:
        """
        Gets the conformance_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total scheduled duration in seconds for OnQueue activities

        :return: The conformance_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._conformance_schedule_seconds

    @conformance_schedule_seconds.setter
    def conformance_schedule_seconds(self, conformance_schedule_seconds: int) -> None:
        """
        Sets the conformance_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total scheduled duration in seconds for OnQueue activities

        :param conformance_schedule_seconds: The conformance_schedule_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._conformance_schedule_seconds = conformance_schedule_seconds

    @property
    def conformance_actual_seconds(self) -> int:
        """
        Gets the conformance_actual_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total actually worked duration in seconds for OnQueue activities

        :return: The conformance_actual_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._conformance_actual_seconds

    @conformance_actual_seconds.setter
    def conformance_actual_seconds(self, conformance_actual_seconds: int) -> None:
        """
        Sets the conformance_actual_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total actually worked duration in seconds for OnQueue activities

        :param conformance_actual_seconds: The conformance_actual_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._conformance_actual_seconds = conformance_actual_seconds

    @property
    def exception_count(self) -> int:
        """
        Gets the exception_count of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total number of adherence exceptions for this user

        :return: The exception_count of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._exception_count

    @exception_count.setter
    def exception_count(self, exception_count: int) -> None:
        """
        Sets the exception_count of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total number of adherence exceptions for this user

        :param exception_count: The exception_count of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._exception_count = exception_count

    @property
    def exception_duration_seconds(self) -> int:
        """
        Gets the exception_duration_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds of adherence exceptions for this user

        :return: The exception_duration_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._exception_duration_seconds

    @exception_duration_seconds.setter
    def exception_duration_seconds(self, exception_duration_seconds: int) -> None:
        """
        Sets the exception_duration_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds of adherence exceptions for this user

        :param exception_duration_seconds: The exception_duration_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._exception_duration_seconds = exception_duration_seconds

    @property
    def impact_seconds(self) -> int:
        """
        Gets the impact_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        The impact duration in seconds of current adherence state for this user

        :return: The impact_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._impact_seconds

    @impact_seconds.setter
    def impact_seconds(self, impact_seconds: int) -> None:
        """
        Sets the impact_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        The impact duration in seconds of current adherence state for this user

        :param impact_seconds: The impact_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._impact_seconds = impact_seconds

    @property
    def schedule_length_seconds(self) -> int:
        """
        Gets the schedule_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds for all scheduled activities

        :return: The schedule_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._schedule_length_seconds

    @schedule_length_seconds.setter
    def schedule_length_seconds(self, schedule_length_seconds: int) -> None:
        """
        Sets the schedule_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds for all scheduled activities

        :param schedule_length_seconds: The schedule_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._schedule_length_seconds = schedule_length_seconds

    @property
    def actual_length_seconds(self) -> int:
        """
        Gets the actual_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds for all actually worked activities

        :return: The actual_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: int
        """
        return self._actual_length_seconds

    @actual_length_seconds.setter
    def actual_length_seconds(self, actual_length_seconds: int) -> None:
        """
        Sets the actual_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total duration in seconds for all actually worked activities

        :param actual_length_seconds: The actual_length_seconds of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: int
        """
        

        self._actual_length_seconds = actual_length_seconds

    @property
    def adherence_percentage(self) -> float:
        """
        Gets the adherence_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total adherence percentage for this user, in the scale of 0 - 100

        :return: The adherence_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: float
        """
        return self._adherence_percentage

    @adherence_percentage.setter
    def adherence_percentage(self, adherence_percentage: float) -> None:
        """
        Sets the adherence_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total adherence percentage for this user, in the scale of 0 - 100

        :param adherence_percentage: The adherence_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: float
        """
        

        self._adherence_percentage = adherence_percentage

    @property
    def conformance_percentage(self) -> float:
        """
        Gets the conformance_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on-queue time is greater than the scheduled on-queue time for the same period.

        :return: The conformance_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :rtype: float
        """
        return self._conformance_percentage

    @conformance_percentage.setter
    def conformance_percentage(self, conformance_percentage: float) -> None:
        """
        Sets the conformance_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        Total conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on-queue time is greater than the scheduled on-queue time for the same period.

        :param conformance_percentage: The conformance_percentage of this WfmHistoricalAdherenceBulkUserDayMetrics.
        :type: float
        """
        

        self._conformance_percentage = conformance_percentage

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

