# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ViewFilter
    from . import Warning

class Widget(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Widget - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'row': 'int',
            'column': 'int',
            'title': 'str',
            'type': 'str',
            'metrics': 'list[str]',
            'display_text': 'str',
            'display_text_color': 'str',
            'web_content_url': 'str',
            'split_filters': 'bool',
            'split_by_media_type': 'bool',
            'show_longest': 'bool',
            'display_as_table': 'bool',
            'show_duration': 'bool',
            'sort_order': 'str',
            'sort_key': 'str',
            'entity_limit': 'int',
            'display_aggregates': 'bool',
            'is_full_width': 'bool',
            'show_percentage_change': 'bool',
            'show_profile_picture': 'bool',
            'filter': 'ViewFilter',
            'periods': 'list[str]',
            'media_types': 'list[str]',
            'warnings': 'list[Warning]',
            'show_time_in_status': 'bool',
            'show_offline_agents': 'bool',
            'selected_statuses': 'list[str]',
            'selected_segment_types': 'list[str]',
            'agent_interaction_sort_order': 'str'
        }

        self.attribute_map = {
            'row': 'row',
            'column': 'column',
            'title': 'title',
            'type': 'type',
            'metrics': 'metrics',
            'display_text': 'displayText',
            'display_text_color': 'displayTextColor',
            'web_content_url': 'webContentUrl',
            'split_filters': 'splitFilters',
            'split_by_media_type': 'splitByMediaType',
            'show_longest': 'showLongest',
            'display_as_table': 'displayAsTable',
            'show_duration': 'showDuration',
            'sort_order': 'sortOrder',
            'sort_key': 'sortKey',
            'entity_limit': 'entityLimit',
            'display_aggregates': 'displayAggregates',
            'is_full_width': 'isFullWidth',
            'show_percentage_change': 'showPercentageChange',
            'show_profile_picture': 'showProfilePicture',
            'filter': 'filter',
            'periods': 'periods',
            'media_types': 'mediaTypes',
            'warnings': 'warnings',
            'show_time_in_status': 'showTimeInStatus',
            'show_offline_agents': 'showOfflineAgents',
            'selected_statuses': 'selectedStatuses',
            'selected_segment_types': 'selectedSegmentTypes',
            'agent_interaction_sort_order': 'agentInteractionSortOrder'
        }

        self._row = None
        self._column = None
        self._title = None
        self._type = None
        self._metrics = None
        self._display_text = None
        self._display_text_color = None
        self._web_content_url = None
        self._split_filters = None
        self._split_by_media_type = None
        self._show_longest = None
        self._display_as_table = None
        self._show_duration = None
        self._sort_order = None
        self._sort_key = None
        self._entity_limit = None
        self._display_aggregates = None
        self._is_full_width = None
        self._show_percentage_change = None
        self._show_profile_picture = None
        self._filter = None
        self._periods = None
        self._media_types = None
        self._warnings = None
        self._show_time_in_status = None
        self._show_offline_agents = None
        self._selected_statuses = None
        self._selected_segment_types = None
        self._agent_interaction_sort_order = None

    @property
    def row(self) -> int:
        """
        Gets the row of this Widget.
        The row number for the specific dashboard widget configuration.

        :return: The row of this Widget.
        :rtype: int
        """
        return self._row

    @row.setter
    def row(self, row: int) -> None:
        """
        Sets the row of this Widget.
        The row number for the specific dashboard widget configuration.

        :param row: The row of this Widget.
        :type: int
        """
        

        self._row = row

    @property
    def column(self) -> int:
        """
        Gets the column of this Widget.
        The column number for the specific dashboard widget configuration.

        :return: The column of this Widget.
        :rtype: int
        """
        return self._column

    @column.setter
    def column(self, column: int) -> None:
        """
        Sets the column of this Widget.
        The column number for the specific dashboard widget configuration.

        :param column: The column of this Widget.
        :type: int
        """
        

        self._column = column

    @property
    def title(self) -> str:
        """
        Gets the title of this Widget.
        The title for the dashboard widget configuration.

        :return: The title of this Widget.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this Widget.
        The title for the dashboard widget configuration.

        :param title: The title of this Widget.
        :type: str
        """
        

        self._title = title

    @property
    def type(self) -> str:
        """
        Gets the type of this Widget.
        The type of dashboard widget configuration.

        :return: The type of this Widget.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this Widget.
        The type of dashboard widget configuration.

        :param type: The type of this Widget.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["METRIC", "CHART", "PIE", "HEAT_MAP", "FREE_TEXT", "AGENT_STATUS", "REALTIME_ADHERENCE", "WEB_CONTENT_URL", "AGENT_ACTIVITY"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def metrics(self) -> List[str]:
        """
        Gets the metrics of this Widget.
        The list of metrics for the dashboard widget configuration.

        :return: The metrics of this Widget.
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List[str]) -> None:
        """
        Sets the metrics of this Widget.
        The list of metrics for the dashboard widget configuration.

        :param metrics: The metrics of this Widget.
        :type: list[str]
        """
        

        self._metrics = metrics

    @property
    def display_text(self) -> str:
        """
        Gets the display_text of this Widget.
        The display text for the dashboard widget configuration.

        :return: The display_text of this Widget.
        :rtype: str
        """
        return self._display_text

    @display_text.setter
    def display_text(self, display_text: str) -> None:
        """
        Sets the display_text of this Widget.
        The display text for the dashboard widget configuration.

        :param display_text: The display_text of this Widget.
        :type: str
        """
        

        self._display_text = display_text

    @property
    def display_text_color(self) -> str:
        """
        Gets the display_text_color of this Widget.
        The color of the display text for the dashboard widget configuration in RGB hexadecimal format (for example \"#FF0000\" represents red).

        :return: The display_text_color of this Widget.
        :rtype: str
        """
        return self._display_text_color

    @display_text_color.setter
    def display_text_color(self, display_text_color: str) -> None:
        """
        Sets the display_text_color of this Widget.
        The color of the display text for the dashboard widget configuration in RGB hexadecimal format (for example \"#FF0000\" represents red).

        :param display_text_color: The display_text_color of this Widget.
        :type: str
        """
        

        self._display_text_color = display_text_color

    @property
    def web_content_url(self) -> str:
        """
        Gets the web_content_url of this Widget.
        The external web URL for the dashboard widget configuration.

        :return: The web_content_url of this Widget.
        :rtype: str
        """
        return self._web_content_url

    @web_content_url.setter
    def web_content_url(self, web_content_url: str) -> None:
        """
        Sets the web_content_url of this Widget.
        The external web URL for the dashboard widget configuration.

        :param web_content_url: The web_content_url of this Widget.
        :type: str
        """
        

        self._web_content_url = web_content_url

    @property
    def split_filters(self) -> bool:
        """
        Gets the split_filters of this Widget.
        Indicates each filter to be displayed individually.

        :return: The split_filters of this Widget.
        :rtype: bool
        """
        return self._split_filters

    @split_filters.setter
    def split_filters(self, split_filters: bool) -> None:
        """
        Sets the split_filters of this Widget.
        Indicates each filter to be displayed individually.

        :param split_filters: The split_filters of this Widget.
        :type: bool
        """
        

        self._split_filters = split_filters

    @property
    def split_by_media_type(self) -> bool:
        """
        Gets the split_by_media_type of this Widget.
        Indicates that data for each media type should be shown individually.

        :return: The split_by_media_type of this Widget.
        :rtype: bool
        """
        return self._split_by_media_type

    @split_by_media_type.setter
    def split_by_media_type(self, split_by_media_type: bool) -> None:
        """
        Sets the split_by_media_type of this Widget.
        Indicates that data for each media type should be shown individually.

        :param split_by_media_type: The split_by_media_type of this Widget.
        :type: bool
        """
        

        self._split_by_media_type = split_by_media_type

    @property
    def show_longest(self) -> bool:
        """
        Gets the show_longest of this Widget.
        Indicates the display be the longest time.

        :return: The show_longest of this Widget.
        :rtype: bool
        """
        return self._show_longest

    @show_longest.setter
    def show_longest(self, show_longest: bool) -> None:
        """
        Sets the show_longest of this Widget.
        Indicates the display be the longest time.

        :param show_longest: The show_longest of this Widget.
        :type: bool
        """
        

        self._show_longest = show_longest

    @property
    def display_as_table(self) -> bool:
        """
        Gets the display_as_table of this Widget.
        Indicates the widget to be displayed as table.

        :return: The display_as_table of this Widget.
        :rtype: bool
        """
        return self._display_as_table

    @display_as_table.setter
    def display_as_table(self, display_as_table: bool) -> None:
        """
        Sets the display_as_table of this Widget.
        Indicates the widget to be displayed as table.

        :param display_as_table: The display_as_table of this Widget.
        :type: bool
        """
        

        self._display_as_table = display_as_table

    @property
    def show_duration(self) -> bool:
        """
        Gets the show_duration of this Widget.
        Indicates the display to include duration.

        :return: The show_duration of this Widget.
        :rtype: bool
        """
        return self._show_duration

    @show_duration.setter
    def show_duration(self, show_duration: bool) -> None:
        """
        Sets the show_duration of this Widget.
        Indicates the display to include duration.

        :param show_duration: The show_duration of this Widget.
        :type: bool
        """
        

        self._show_duration = show_duration

    @property
    def sort_order(self) -> str:
        """
        Gets the sort_order of this Widget.
        The sort order of the table.

        :return: The sort_order of this Widget.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order: str) -> None:
        """
        Sets the sort_order of this Widget.
        The sort order of the table.

        :param sort_order: The sort_order of this Widget.
        :type: str
        """
        if isinstance(sort_order, int):
            sort_order = str(sort_order)
        allowed_values = ["ascending", "descending"]
        if sort_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_order -> " + sort_order)
            self._sort_order = "outdated_sdk_version"
        else:
            self._sort_order = sort_order

    @property
    def sort_key(self) -> str:
        """
        Gets the sort_key of this Widget.
        The sort key of the table.

        :return: The sort_key of this Widget.
        :rtype: str
        """
        return self._sort_key

    @sort_key.setter
    def sort_key(self, sort_key: str) -> None:
        """
        Sets the sort_key of this Widget.
        The sort key of the table.

        :param sort_key: The sort_key of this Widget.
        :type: str
        """
        if isinstance(sort_key, int):
            sort_key = str(sort_key)
        allowed_values = ["Name", "Duration"]
        if sort_key.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_key -> " + sort_key)
            self._sort_key = "outdated_sdk_version"
        else:
            self._sort_key = sort_key

    @property
    def entity_limit(self) -> int:
        """
        Gets the entity_limit of this Widget.
        Indicates the limit of displayed entities.

        :return: The entity_limit of this Widget.
        :rtype: int
        """
        return self._entity_limit

    @entity_limit.setter
    def entity_limit(self, entity_limit: int) -> None:
        """
        Sets the entity_limit of this Widget.
        Indicates the limit of displayed entities.

        :param entity_limit: The entity_limit of this Widget.
        :type: int
        """
        

        self._entity_limit = entity_limit

    @property
    def display_aggregates(self) -> bool:
        """
        Gets the display_aggregates of this Widget.
        Indicates whether to display aggregate across all entity and media type combination.

        :return: The display_aggregates of this Widget.
        :rtype: bool
        """
        return self._display_aggregates

    @display_aggregates.setter
    def display_aggregates(self, display_aggregates: bool) -> None:
        """
        Sets the display_aggregates of this Widget.
        Indicates whether to display aggregate across all entity and media type combination.

        :param display_aggregates: The display_aggregates of this Widget.
        :type: bool
        """
        

        self._display_aggregates = display_aggregates

    @property
    def is_full_width(self) -> bool:
        """
        Gets the is_full_width of this Widget.
        Indicates whether a widget should take the full width of a dashboard or be shown only in a single slot.

        :return: The is_full_width of this Widget.
        :rtype: bool
        """
        return self._is_full_width

    @is_full_width.setter
    def is_full_width(self, is_full_width: bool) -> None:
        """
        Sets the is_full_width of this Widget.
        Indicates whether a widget should take the full width of a dashboard or be shown only in a single slot.

        :param is_full_width: The is_full_width of this Widget.
        :type: bool
        """
        

        self._is_full_width = is_full_width

    @property
    def show_percentage_change(self) -> bool:
        """
        Gets the show_percentage_change of this Widget.
        Indicates whether a widget should show the percentage diff between two values.

        :return: The show_percentage_change of this Widget.
        :rtype: bool
        """
        return self._show_percentage_change

    @show_percentage_change.setter
    def show_percentage_change(self, show_percentage_change: bool) -> None:
        """
        Sets the show_percentage_change of this Widget.
        Indicates whether a widget should show the percentage diff between two values.

        :param show_percentage_change: The show_percentage_change of this Widget.
        :type: bool
        """
        

        self._show_percentage_change = show_percentage_change

    @property
    def show_profile_picture(self) -> bool:
        """
        Gets the show_profile_picture of this Widget.
        Indicates whether a widget should show the profile picture of an agent.

        :return: The show_profile_picture of this Widget.
        :rtype: bool
        """
        return self._show_profile_picture

    @show_profile_picture.setter
    def show_profile_picture(self, show_profile_picture: bool) -> None:
        """
        Sets the show_profile_picture of this Widget.
        Indicates whether a widget should show the profile picture of an agent.

        :param show_profile_picture: The show_profile_picture of this Widget.
        :type: bool
        """
        

        self._show_profile_picture = show_profile_picture

    @property
    def filter(self) -> 'ViewFilter':
        """
        Gets the filter of this Widget.
        The filters to be applied for dashboard widget configuration

        :return: The filter of this Widget.
        :rtype: ViewFilter
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'ViewFilter') -> None:
        """
        Sets the filter of this Widget.
        The filters to be applied for dashboard widget configuration

        :param filter: The filter of this Widget.
        :type: ViewFilter
        """
        

        self._filter = filter

    @property
    def periods(self) -> List[str]:
        """
        Gets the periods of this Widget.
        The list of periods for the dashboard widget configuration

        :return: The periods of this Widget.
        :rtype: list[str]
        """
        return self._periods

    @periods.setter
    def periods(self, periods: List[str]) -> None:
        """
        Sets the periods of this Widget.
        The list of periods for the dashboard widget configuration

        :param periods: The periods of this Widget.
        :type: list[str]
        """
        

        self._periods = periods

    @property
    def media_types(self) -> List[str]:
        """
        Gets the media_types of this Widget.
        The list of media types for the dashboard widget configuration

        :return: The media_types of this Widget.
        :rtype: list[str]
        """
        return self._media_types

    @media_types.setter
    def media_types(self, media_types: List[str]) -> None:
        """
        Sets the media_types of this Widget.
        The list of media types for the dashboard widget configuration

        :param media_types: The media_types of this Widget.
        :type: list[str]
        """
        

        self._media_types = media_types

    @property
    def warnings(self) -> List['Warning']:
        """
        Gets the warnings of this Widget.
        List of warnings for dashboard widget configuration

        :return: The warnings of this Widget.
        :rtype: list[Warning]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings: List['Warning']) -> None:
        """
        Sets the warnings of this Widget.
        List of warnings for dashboard widget configuration

        :param warnings: The warnings of this Widget.
        :type: list[Warning]
        """
        

        self._warnings = warnings

    @property
    def show_time_in_status(self) -> bool:
        """
        Gets the show_time_in_status of this Widget.
        Indicates the show time in status of a widget configuration.

        :return: The show_time_in_status of this Widget.
        :rtype: bool
        """
        return self._show_time_in_status

    @show_time_in_status.setter
    def show_time_in_status(self, show_time_in_status: bool) -> None:
        """
        Sets the show_time_in_status of this Widget.
        Indicates the show time in status of a widget configuration.

        :param show_time_in_status: The show_time_in_status of this Widget.
        :type: bool
        """
        

        self._show_time_in_status = show_time_in_status

    @property
    def show_offline_agents(self) -> bool:
        """
        Gets the show_offline_agents of this Widget.
        Indicates to show offline agent widget.

        :return: The show_offline_agents of this Widget.
        :rtype: bool
        """
        return self._show_offline_agents

    @show_offline_agents.setter
    def show_offline_agents(self, show_offline_agents: bool) -> None:
        """
        Sets the show_offline_agents of this Widget.
        Indicates to show offline agent widget.

        :param show_offline_agents: The show_offline_agents of this Widget.
        :type: bool
        """
        

        self._show_offline_agents = show_offline_agents

    @property
    def selected_statuses(self) -> List[str]:
        """
        Gets the selected_statuses of this Widget.
        Indicates the selected statuses used to filter the agent widget in the dashboard.

        :return: The selected_statuses of this Widget.
        :rtype: list[str]
        """
        return self._selected_statuses

    @selected_statuses.setter
    def selected_statuses(self, selected_statuses: List[str]) -> None:
        """
        Sets the selected_statuses of this Widget.
        Indicates the selected statuses used to filter the agent widget in the dashboard.

        :param selected_statuses: The selected_statuses of this Widget.
        :type: list[str]
        """
        

        self._selected_statuses = selected_statuses

    @property
    def selected_segment_types(self) -> List[str]:
        """
        Gets the selected_segment_types of this Widget.
        Indicates the selected segment types used to filter the agent activity in the dashboard.

        :return: The selected_segment_types of this Widget.
        :rtype: list[str]
        """
        return self._selected_segment_types

    @selected_segment_types.setter
    def selected_segment_types(self, selected_segment_types: List[str]) -> None:
        """
        Sets the selected_segment_types of this Widget.
        Indicates the selected segment types used to filter the agent activity in the dashboard.

        :param selected_segment_types: The selected_segment_types of this Widget.
        :type: list[str]
        """
        

        self._selected_segment_types = selected_segment_types

    @property
    def agent_interaction_sort_order(self) -> str:
        """
        Gets the agent_interaction_sort_order of this Widget.
        The sort order of the interactions in the agent status widget.

        :return: The agent_interaction_sort_order of this Widget.
        :rtype: str
        """
        return self._agent_interaction_sort_order

    @agent_interaction_sort_order.setter
    def agent_interaction_sort_order(self, agent_interaction_sort_order: str) -> None:
        """
        Sets the agent_interaction_sort_order of this Widget.
        The sort order of the interactions in the agent status widget.

        :param agent_interaction_sort_order: The agent_interaction_sort_order of this Widget.
        :type: str
        """
        if isinstance(agent_interaction_sort_order, int):
            agent_interaction_sort_order = str(agent_interaction_sort_order)
        allowed_values = ["ascending", "descending"]
        if agent_interaction_sort_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for agent_interaction_sort_order -> " + agent_interaction_sort_order)
            self._agent_interaction_sort_order = "outdated_sdk_version"
        else:
            self._agent_interaction_sort_order = agent_interaction_sort_order

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

