# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WidgetClientConfigV1
    from . import WidgetClientConfigV1Http

class WidgetClientConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WidgetClientConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'v1': 'WidgetClientConfigV1',
            'v2': 'object',
            'v1_http': 'WidgetClientConfigV1Http',
            'third_party': 'object'
        }

        self.attribute_map = {
            'v1': 'v1',
            'v2': 'v2',
            'v1_http': 'v1-http',
            'third_party': 'third-party'
        }

        self._v1 = None
        self._v2 = None
        self._v1_http = None
        self._third_party = None

    @property
    def v1(self) -> 'WidgetClientConfigV1':
        """
        Gets the v1 of this WidgetClientConfig.


        :return: The v1 of this WidgetClientConfig.
        :rtype: WidgetClientConfigV1
        """
        return self._v1

    @v1.setter
    def v1(self, v1: 'WidgetClientConfigV1') -> None:
        """
        Sets the v1 of this WidgetClientConfig.


        :param v1: The v1 of this WidgetClientConfig.
        :type: WidgetClientConfigV1
        """
        

        self._v1 = v1

    @property
    def v2(self) -> object:
        """
        Gets the v2 of this WidgetClientConfig.


        :return: The v2 of this WidgetClientConfig.
        :rtype: object
        """
        return self._v2

    @v2.setter
    def v2(self, v2: object) -> None:
        """
        Sets the v2 of this WidgetClientConfig.


        :param v2: The v2 of this WidgetClientConfig.
        :type: object
        """
        

        self._v2 = v2

    @property
    def v1_http(self) -> 'WidgetClientConfigV1Http':
        """
        Gets the v1_http of this WidgetClientConfig.


        :return: The v1_http of this WidgetClientConfig.
        :rtype: WidgetClientConfigV1Http
        """
        return self._v1_http

    @v1_http.setter
    def v1_http(self, v1_http: 'WidgetClientConfigV1Http') -> None:
        """
        Sets the v1_http of this WidgetClientConfig.


        :param v1_http: The v1_http of this WidgetClientConfig.
        :type: WidgetClientConfigV1Http
        """
        

        self._v1_http = v1_http

    @property
    def third_party(self) -> object:
        """
        Gets the third_party of this WidgetClientConfig.


        :return: The third_party of this WidgetClientConfig.
        :rtype: object
        """
        return self._third_party

    @third_party.setter
    def third_party(self, third_party: object) -> None:
        """
        Sets the third_party of this WidgetClientConfig.


        :param third_party: The third_party of this WidgetClientConfig.
        :type: object
        """
        

        self._third_party = third_party

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

