# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemQueryJobFilter
    from . import WorkitemQueryJobQueryFilters
    from . import WorkitemQueryJobSort

class WorkitemQueryJobCreate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemQueryJobCreate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'page_size': 'int',
            'page_number': 'int',
            'filters': 'list[WorkitemQueryJobFilter]',
            'query_filters': 'list[WorkitemQueryJobQueryFilters]',
            'expands': 'list[str]',
            'attributes': 'list[str]',
            'sort': 'WorkitemQueryJobSort',
            'date_interval_start': 'datetime',
            'date_interval_end': 'datetime'
        }

        self.attribute_map = {
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'filters': 'filters',
            'query_filters': 'queryFilters',
            'expands': 'expands',
            'attributes': 'attributes',
            'sort': 'sort',
            'date_interval_start': 'dateIntervalStart',
            'date_interval_end': 'dateIntervalEnd'
        }

        self._page_size = None
        self._page_number = None
        self._filters = None
        self._query_filters = None
        self._expands = None
        self._attributes = None
        self._sort = None
        self._date_interval_start = None
        self._date_interval_end = None

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this WorkitemQueryJobCreate.
        The total page size requested. Default 25

        :return: The page_size of this WorkitemQueryJobCreate.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this WorkitemQueryJobCreate.
        The total page size requested. Default 25

        :param page_size: The page_size of this WorkitemQueryJobCreate.
        :type: int
        """
        
        if page_size > 200:
            raise ValueError("Invalid value for `page_size`, must be a value less than or equal to `200`")

        if page_size < 1:
            raise ValueError("Invalid value for `page_size`, must be a value greater than or equal to `1`")


        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this WorkitemQueryJobCreate.
        The page number requested

        :return: The page_number of this WorkitemQueryJobCreate.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this WorkitemQueryJobCreate.
        The page number requested

        :param page_number: The page_number of this WorkitemQueryJobCreate.
        :type: int
        """
        
        if page_number < 1:
            raise ValueError("Invalid value for `page_number`, must be a value greater than or equal to `1`")


        self._page_number = page_number

    @property
    def filters(self) -> List['WorkitemQueryJobFilter']:
        """
        Gets the filters of this WorkitemQueryJobCreate.
        List of filter objects to be used in the search.

        :return: The filters of this WorkitemQueryJobCreate.
        :rtype: list[WorkitemQueryJobFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters: List['WorkitemQueryJobFilter']) -> None:
        """
        Sets the filters of this WorkitemQueryJobCreate.
        List of filter objects to be used in the search.

        :param filters: The filters of this WorkitemQueryJobCreate.
        :type: list[WorkitemQueryJobFilter]
        """
        

        self._filters = filters

    @property
    def query_filters(self) -> List['WorkitemQueryJobQueryFilters']:
        """
        Gets the query_filters of this WorkitemQueryJobCreate.
        Query filters for nested attributes.

        :return: The query_filters of this WorkitemQueryJobCreate.
        :rtype: list[WorkitemQueryJobQueryFilters]
        """
        return self._query_filters

    @query_filters.setter
    def query_filters(self, query_filters: List['WorkitemQueryJobQueryFilters']) -> None:
        """
        Sets the query_filters of this WorkitemQueryJobCreate.
        Query filters for nested attributes.

        :param query_filters: The query_filters of this WorkitemQueryJobCreate.
        :type: list[WorkitemQueryJobQueryFilters]
        """
        

        self._query_filters = query_filters

    @property
    def expands(self) -> List[str]:
        """
        Gets the expands of this WorkitemQueryJobCreate.
        List of entity attributes to be expanded in the result.

        :return: The expands of this WorkitemQueryJobCreate.
        :rtype: list[str]
        """
        return self._expands

    @expands.setter
    def expands(self, expands: List[str]) -> None:
        """
        Sets the expands of this WorkitemQueryJobCreate.
        List of entity attributes to be expanded in the result.

        :param expands: The expands of this WorkitemQueryJobCreate.
        :type: list[str]
        """
        

        self._expands = expands

    @property
    def attributes(self) -> List[str]:
        """
        Gets the attributes of this WorkitemQueryJobCreate.
        List of entity attributes to be retrieved in the result.

        :return: The attributes of this WorkitemQueryJobCreate.
        :rtype: list[str]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: List[str]) -> None:
        """
        Sets the attributes of this WorkitemQueryJobCreate.
        List of entity attributes to be retrieved in the result.

        :param attributes: The attributes of this WorkitemQueryJobCreate.
        :type: list[str]
        """
        

        self._attributes = attributes

    @property
    def sort(self) -> 'WorkitemQueryJobSort':
        """
        Gets the sort of this WorkitemQueryJobCreate.
        Sort

        :return: The sort of this WorkitemQueryJobCreate.
        :rtype: WorkitemQueryJobSort
        """
        return self._sort

    @sort.setter
    def sort(self, sort: 'WorkitemQueryJobSort') -> None:
        """
        Sets the sort of this WorkitemQueryJobCreate.
        Sort

        :param sort: The sort of this WorkitemQueryJobCreate.
        :type: WorkitemQueryJobSort
        """
        

        self._sort = sort

    @property
    def date_interval_start(self) -> datetime:
        """
        Gets the date_interval_start of this WorkitemQueryJobCreate.
        Interval start date to use to filter results based on create date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_interval_start of this WorkitemQueryJobCreate.
        :rtype: datetime
        """
        return self._date_interval_start

    @date_interval_start.setter
    def date_interval_start(self, date_interval_start: datetime) -> None:
        """
        Sets the date_interval_start of this WorkitemQueryJobCreate.
        Interval start date to use to filter results based on create date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_interval_start: The date_interval_start of this WorkitemQueryJobCreate.
        :type: datetime
        """
        

        self._date_interval_start = date_interval_start

    @property
    def date_interval_end(self) -> datetime:
        """
        Gets the date_interval_end of this WorkitemQueryJobCreate.
        Interval end date to use to filter results based on create date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_interval_end of this WorkitemQueryJobCreate.
        :rtype: datetime
        """
        return self._date_interval_end

    @date_interval_end.setter
    def date_interval_end(self, date_interval_end: datetime) -> None:
        """
        Sets the date_interval_end of this WorkitemQueryJobCreate.
        Interval end date to use to filter results based on create date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_interval_end: The date_interval_end of this WorkitemQueryJobCreate.
        :type: datetime
        """
        

        self._date_interval_end = date_interval_end

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

