# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemQueryJobQueryFiltersCriteria

class WorkitemQueryJobQueryFilters(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemQueryJobQueryFilters - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'operator': 'str',
            'criteria': 'list[WorkitemQueryJobQueryFiltersCriteria]'
        }

        self.attribute_map = {
            'name': 'name',
            'operator': 'operator',
            'criteria': 'criteria'
        }

        self._name = None
        self._operator = None
        self._criteria = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkitemQueryJobQueryFilters.
        Name of the attribute to filter.

        :return: The name of this WorkitemQueryJobQueryFilters.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkitemQueryJobQueryFilters.
        Name of the attribute to filter.

        :param name: The name of this WorkitemQueryJobQueryFilters.
        :type: str
        """
        if isinstance(name, int):
            name = str(name)
        allowed_values = ["customFields"]
        if name.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for name -> " + name)
            self._name = "outdated_sdk_version"
        else:
            self._name = name

    @property
    def operator(self) -> str:
        """
        Gets the operator of this WorkitemQueryJobQueryFilters.
        Query filter logical operator to join criteria.

        :return: The operator of this WorkitemQueryJobQueryFilters.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this WorkitemQueryJobQueryFilters.
        Query filter logical operator to join criteria.

        :param operator: The operator of this WorkitemQueryJobQueryFilters.
        :type: str
        """
        if isinstance(operator, int):
            operator = str(operator)
        allowed_values = ["AND", "OR"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def criteria(self) -> List['WorkitemQueryJobQueryFiltersCriteria']:
        """
        Gets the criteria of this WorkitemQueryJobQueryFilters.
        Query filter criteria.

        :return: The criteria of this WorkitemQueryJobQueryFilters.
        :rtype: list[WorkitemQueryJobQueryFiltersCriteria]
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: List['WorkitemQueryJobQueryFiltersCriteria']) -> None:
        """
        Sets the criteria of this WorkitemQueryJobQueryFilters.
        Query filter criteria.

        :param criteria: The criteria of this WorkitemQueryJobQueryFilters.
        :type: list[WorkitemQueryJobQueryFiltersCriteria]
        """
        

        self._criteria = criteria

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

