# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WorkitemStatusFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemStatusFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'worktype_id': 'str',
            'workitem_status_id': 'str'
        }

        self.attribute_map = {
            'worktype_id': 'worktypeId',
            'workitem_status_id': 'workitemStatusId'
        }

        self._worktype_id = None
        self._workitem_status_id = None

    @property
    def worktype_id(self) -> str:
        """
        Gets the worktype_id of this WorkitemStatusFilter.
        Worktype ID belonging to the selected workitem status

        :return: The worktype_id of this WorkitemStatusFilter.
        :rtype: str
        """
        return self._worktype_id

    @worktype_id.setter
    def worktype_id(self, worktype_id: str) -> None:
        """
        Sets the worktype_id of this WorkitemStatusFilter.
        Worktype ID belonging to the selected workitem status

        :param worktype_id: The worktype_id of this WorkitemStatusFilter.
        :type: str
        """
        

        self._worktype_id = worktype_id

    @property
    def workitem_status_id(self) -> str:
        """
        Gets the workitem_status_id of this WorkitemStatusFilter.
        Workitem status ID

        :return: The workitem_status_id of this WorkitemStatusFilter.
        :rtype: str
        """
        return self._workitem_status_id

    @workitem_status_id.setter
    def workitem_status_id(self, workitem_status_id: str) -> None:
        """
        Sets the workitem_status_id of this WorkitemStatusFilter.
        Workitem status ID

        :param workitem_status_id: The workitem_status_id of this WorkitemStatusFilter.
        :type: str
        """
        

        self._workitem_status_id = workitem_status_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

