# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WorkitemStatusUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemStatusUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'destination_status_ids': 'list[str]',
            'description': 'str',
            'default_destination_status_id': 'str',
            'status_transition_delay_seconds': 'int',
            'status_transition_time': 'str',
            'auto_terminate_workitem': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'destination_status_ids': 'destinationStatusIds',
            'description': 'description',
            'default_destination_status_id': 'defaultDestinationStatusId',
            'status_transition_delay_seconds': 'statusTransitionDelaySeconds',
            'status_transition_time': 'statusTransitionTime',
            'auto_terminate_workitem': 'autoTerminateWorkitem'
        }

        self._name = None
        self._destination_status_ids = None
        self._description = None
        self._default_destination_status_id = None
        self._status_transition_delay_seconds = None
        self._status_transition_time = None
        self._auto_terminate_workitem = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkitemStatusUpdate.
        The name of the Status. Valid length between 3 and 256 characters.

        :return: The name of this WorkitemStatusUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkitemStatusUpdate.
        The name of the Status. Valid length between 3 and 256 characters.

        :param name: The name of this WorkitemStatusUpdate.
        :type: str
        """
        

        self._name = name

    @property
    def destination_status_ids(self) -> List[str]:
        """
        Gets the destination_status_ids of this WorkitemStatusUpdate.
        A list of destination Statuses where a Workitem with this Status can transition to. If the list is empty Workitems with this Status can transition to all other Statuses defined on the Worktype. A Status can have a maximum of 24 destinations.

        :return: The destination_status_ids of this WorkitemStatusUpdate.
        :rtype: list[str]
        """
        return self._destination_status_ids

    @destination_status_ids.setter
    def destination_status_ids(self, destination_status_ids: List[str]) -> None:
        """
        Sets the destination_status_ids of this WorkitemStatusUpdate.
        A list of destination Statuses where a Workitem with this Status can transition to. If the list is empty Workitems with this Status can transition to all other Statuses defined on the Worktype. A Status can have a maximum of 24 destinations.

        :param destination_status_ids: The destination_status_ids of this WorkitemStatusUpdate.
        :type: list[str]
        """
        

        self._destination_status_ids = destination_status_ids

    @property
    def description(self) -> str:
        """
        Gets the description of this WorkitemStatusUpdate.
        The description of the Status. Maximum length of 512 characters.

        :return: The description of this WorkitemStatusUpdate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this WorkitemStatusUpdate.
        The description of the Status. Maximum length of 512 characters.

        :param description: The description of this WorkitemStatusUpdate.
        :type: str
        """
        

        self._description = description

    @property
    def default_destination_status_id(self) -> str:
        """
        Gets the default_destination_status_id of this WorkitemStatusUpdate.
        Default destination status to which this Status will transition to if auto status transition enabled.

        :return: The default_destination_status_id of this WorkitemStatusUpdate.
        :rtype: str
        """
        return self._default_destination_status_id

    @default_destination_status_id.setter
    def default_destination_status_id(self, default_destination_status_id: str) -> None:
        """
        Sets the default_destination_status_id of this WorkitemStatusUpdate.
        Default destination status to which this Status will transition to if auto status transition enabled.

        :param default_destination_status_id: The default_destination_status_id of this WorkitemStatusUpdate.
        :type: str
        """
        

        self._default_destination_status_id = default_destination_status_id

    @property
    def status_transition_delay_seconds(self) -> int:
        """
        Gets the status_transition_delay_seconds of this WorkitemStatusUpdate.
        Delay in seconds for auto status transition. Required if defaultDestinationStatusId is provided.

        :return: The status_transition_delay_seconds of this WorkitemStatusUpdate.
        :rtype: int
        """
        return self._status_transition_delay_seconds

    @status_transition_delay_seconds.setter
    def status_transition_delay_seconds(self, status_transition_delay_seconds: int) -> None:
        """
        Sets the status_transition_delay_seconds of this WorkitemStatusUpdate.
        Delay in seconds for auto status transition. Required if defaultDestinationStatusId is provided.

        :param status_transition_delay_seconds: The status_transition_delay_seconds of this WorkitemStatusUpdate.
        :type: int
        """
        

        self._status_transition_delay_seconds = status_transition_delay_seconds

    @property
    def status_transition_time(self) -> str:
        """
        Gets the status_transition_time of this WorkitemStatusUpdate.
        Time is represented as an ISO-8601 string without a timezone. For example: HH:mm:ss.SSS

        :return: The status_transition_time of this WorkitemStatusUpdate.
        :rtype: str
        """
        return self._status_transition_time

    @status_transition_time.setter
    def status_transition_time(self, status_transition_time: str) -> None:
        """
        Sets the status_transition_time of this WorkitemStatusUpdate.
        Time is represented as an ISO-8601 string without a timezone. For example: HH:mm:ss.SSS

        :param status_transition_time: The status_transition_time of this WorkitemStatusUpdate.
        :type: str
        """
        

        self._status_transition_time = status_transition_time

    @property
    def auto_terminate_workitem(self) -> bool:
        """
        Gets the auto_terminate_workitem of this WorkitemStatusUpdate.
        Terminate workitem on selection of status. Applicable only for statuses in the Closed category.

        :return: The auto_terminate_workitem of this WorkitemStatusUpdate.
        :rtype: bool
        """
        return self._auto_terminate_workitem

    @auto_terminate_workitem.setter
    def auto_terminate_workitem(self, auto_terminate_workitem: bool) -> None:
        """
        Sets the auto_terminate_workitem of this WorkitemStatusUpdate.
        Terminate workitem on selection of status. Applicable only for statuses in the Closed category.

        :param auto_terminate_workitem: The auto_terminate_workitem of this WorkitemStatusUpdate.
        :type: bool
        """
        

        self._auto_terminate_workitem = auto_terminate_workitem

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

