# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WorkitemsEventsNotificationWrapup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemsEventsNotificationWrapup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'code': 'str',
            'user_id': 'str',
            'op': 'str',
            'action': 'str'
        }

        self.attribute_map = {
            'code': 'code',
            'user_id': 'userId',
            'op': 'op',
            'action': 'action'
        }

        self._code = None
        self._user_id = None
        self._op = None
        self._action = None

    @property
    def code(self) -> str:
        """
        Gets the code of this WorkitemsEventsNotificationWrapup.


        :return: The code of this WorkitemsEventsNotificationWrapup.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code: str) -> None:
        """
        Sets the code of this WorkitemsEventsNotificationWrapup.


        :param code: The code of this WorkitemsEventsNotificationWrapup.
        :type: str
        """
        

        self._code = code

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this WorkitemsEventsNotificationWrapup.


        :return: The user_id of this WorkitemsEventsNotificationWrapup.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this WorkitemsEventsNotificationWrapup.


        :param user_id: The user_id of this WorkitemsEventsNotificationWrapup.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def op(self) -> str:
        """
        Gets the op of this WorkitemsEventsNotificationWrapup.


        :return: The op of this WorkitemsEventsNotificationWrapup.
        :rtype: str
        """
        return self._op

    @op.setter
    def op(self, op: str) -> None:
        """
        Sets the op of this WorkitemsEventsNotificationWrapup.


        :param op: The op of this WorkitemsEventsNotificationWrapup.
        :type: str
        """
        if isinstance(op, int):
            op = str(op)
        allowed_values = ["Unknown", "Add", "Remove"]
        if op.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for op -> " + op)
            self._op = "outdated_sdk_version"
        else:
            self._op = op

    @property
    def action(self) -> str:
        """
        Gets the action of this WorkitemsEventsNotificationWrapup.


        :return: The action of this WorkitemsEventsNotificationWrapup.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this WorkitemsEventsNotificationWrapup.


        :param action: The action of this WorkitemsEventsNotificationWrapup.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["Unknown", "Add", "Remove"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

