# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemsQueueEventsNotificationAssignmentSegment

class WorkitemsQueueEventsNotificationSession(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemsQueueEventsNotificationSession - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'status': 'str',
            'date_session_start': 'str',
            'date_session_end': 'str',
            'assignment_segments': 'list[WorkitemsQueueEventsNotificationAssignmentSegment]'
        }

        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'status': 'status',
            'date_session_start': 'dateSessionStart',
            'date_session_end': 'dateSessionEnd',
            'assignment_segments': 'assignmentSegments'
        }

        self._type = None
        self._id = None
        self._status = None
        self._date_session_start = None
        self._date_session_end = None
        self._assignment_segments = None

    @property
    def type(self) -> str:
        """
        Gets the type of this WorkitemsQueueEventsNotificationSession.


        :return: The type of this WorkitemsQueueEventsNotificationSession.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this WorkitemsQueueEventsNotificationSession.


        :param type: The type of this WorkitemsQueueEventsNotificationSession.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Unknown", "Agent", "QueueAssignment", "DirectAssignment", "AgentComplete"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def id(self) -> str:
        """
        Gets the id of this WorkitemsQueueEventsNotificationSession.


        :return: The id of this WorkitemsQueueEventsNotificationSession.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WorkitemsQueueEventsNotificationSession.


        :param id: The id of this WorkitemsQueueEventsNotificationSession.
        :type: str
        """
        

        self._id = id

    @property
    def status(self) -> str:
        """
        Gets the status of this WorkitemsQueueEventsNotificationSession.


        :return: The status of this WorkitemsQueueEventsNotificationSession.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this WorkitemsQueueEventsNotificationSession.


        :param status: The status of this WorkitemsQueueEventsNotificationSession.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Unknown", "Active", "Completed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def date_session_start(self) -> str:
        """
        Gets the date_session_start of this WorkitemsQueueEventsNotificationSession.


        :return: The date_session_start of this WorkitemsQueueEventsNotificationSession.
        :rtype: str
        """
        return self._date_session_start

    @date_session_start.setter
    def date_session_start(self, date_session_start: str) -> None:
        """
        Sets the date_session_start of this WorkitemsQueueEventsNotificationSession.


        :param date_session_start: The date_session_start of this WorkitemsQueueEventsNotificationSession.
        :type: str
        """
        

        self._date_session_start = date_session_start

    @property
    def date_session_end(self) -> str:
        """
        Gets the date_session_end of this WorkitemsQueueEventsNotificationSession.


        :return: The date_session_end of this WorkitemsQueueEventsNotificationSession.
        :rtype: str
        """
        return self._date_session_end

    @date_session_end.setter
    def date_session_end(self, date_session_end: str) -> None:
        """
        Sets the date_session_end of this WorkitemsQueueEventsNotificationSession.


        :param date_session_end: The date_session_end of this WorkitemsQueueEventsNotificationSession.
        :type: str
        """
        

        self._date_session_end = date_session_end

    @property
    def assignment_segments(self) -> List['WorkitemsQueueEventsNotificationAssignmentSegment']:
        """
        Gets the assignment_segments of this WorkitemsQueueEventsNotificationSession.


        :return: The assignment_segments of this WorkitemsQueueEventsNotificationSession.
        :rtype: list[WorkitemsQueueEventsNotificationAssignmentSegment]
        """
        return self._assignment_segments

    @assignment_segments.setter
    def assignment_segments(self, assignment_segments: List['WorkitemsQueueEventsNotificationAssignmentSegment']) -> None:
        """
        Sets the assignment_segments of this WorkitemsQueueEventsNotificationSession.


        :param assignment_segments: The assignment_segments of this WorkitemsQueueEventsNotificationSession.
        :type: list[WorkitemsQueueEventsNotificationAssignmentSegment]
        """
        

        self._assignment_segments = assignment_segments

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

