# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WorkitemsUserEventsNotificationAssignmentSegment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemsUserEventsNotificationAssignmentSegment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_state': 'str',
            'end_state': 'str',
            'duration_ms': 'int'
        }

        self.attribute_map = {
            'start_state': 'startState',
            'end_state': 'endState',
            'duration_ms': 'durationMs'
        }

        self._start_state = None
        self._end_state = None
        self._duration_ms = None

    @property
    def start_state(self) -> str:
        """
        Gets the start_state of this WorkitemsUserEventsNotificationAssignmentSegment.


        :return: The start_state of this WorkitemsUserEventsNotificationAssignmentSegment.
        :rtype: str
        """
        return self._start_state

    @start_state.setter
    def start_state(self, start_state: str) -> None:
        """
        Sets the start_state of this WorkitemsUserEventsNotificationAssignmentSegment.


        :param start_state: The start_state of this WorkitemsUserEventsNotificationAssignmentSegment.
        :type: str
        """
        if isinstance(start_state, int):
            start_state = str(start_state)
        allowed_values = ["Unknown", "Idle", "AcdStarted", "Alerting", "AlertTimeout", "Declined", "Connected", "Disconnected", "Parked", "Held", "AcdCancelled", "Terminated", "AcdExpired"]
        if start_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for start_state -> " + start_state)
            self._start_state = "outdated_sdk_version"
        else:
            self._start_state = start_state

    @property
    def end_state(self) -> str:
        """
        Gets the end_state of this WorkitemsUserEventsNotificationAssignmentSegment.


        :return: The end_state of this WorkitemsUserEventsNotificationAssignmentSegment.
        :rtype: str
        """
        return self._end_state

    @end_state.setter
    def end_state(self, end_state: str) -> None:
        """
        Sets the end_state of this WorkitemsUserEventsNotificationAssignmentSegment.


        :param end_state: The end_state of this WorkitemsUserEventsNotificationAssignmentSegment.
        :type: str
        """
        if isinstance(end_state, int):
            end_state = str(end_state)
        allowed_values = ["Unknown", "Idle", "AcdStarted", "Alerting", "AlertTimeout", "Declined", "Connected", "Disconnected", "Parked", "Held", "AcdCancelled", "Terminated", "AcdExpired"]
        if end_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for end_state -> " + end_state)
            self._end_state = "outdated_sdk_version"
        else:
            self._end_state = end_state

    @property
    def duration_ms(self) -> int:
        """
        Gets the duration_ms of this WorkitemsUserEventsNotificationAssignmentSegment.


        :return: The duration_ms of this WorkitemsUserEventsNotificationAssignmentSegment.
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms: int) -> None:
        """
        Sets the duration_ms of this WorkitemsUserEventsNotificationAssignmentSegment.


        :param duration_ms: The duration_ms of this WorkitemsUserEventsNotificationAssignmentSegment.
        :type: int
        """
        

        self._duration_ms = duration_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

