# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemsAttributeChangeBoolean
    from . import WorkitemsAttributeChangeInstant
    from . import WorkitemsAttributeChangeInteger
    from . import WorkitemsAttributeChangeList
    from . import WorkitemsAttributeChangeString
    from . import WorkitemsAttributeChangeWorkitemRuleSettings

class WorktypeDelta(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorktypeDelta - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'WorkitemsAttributeChangeString',
            'description': 'WorkitemsAttributeChangeString',
            'statuses': 'WorkitemsAttributeChangeList',
            'default_workbin_id': 'WorkitemsAttributeChangeString',
            'default_duration_seconds': 'WorkitemsAttributeChangeInteger',
            'default_expiration_seconds': 'WorkitemsAttributeChangeInteger',
            'default_due_duration_seconds': 'WorkitemsAttributeChangeInteger',
            'default_priority': 'WorkitemsAttributeChangeInteger',
            'default_skill_ids': 'WorkitemsAttributeChangeList',
            'default_status_id': 'WorkitemsAttributeChangeString',
            'default_language_id': 'WorkitemsAttributeChangeString',
            'default_ttl_seconds': 'WorkitemsAttributeChangeInteger',
            'assignment_enabled': 'WorkitemsAttributeChangeBoolean',
            'default_queue_id': 'WorkitemsAttributeChangeString',
            'schema_id': 'WorkitemsAttributeChangeString',
            'schema_version': 'WorkitemsAttributeChangeString',
            'service_level_target': 'WorkitemsAttributeChangeInteger',
            'date_modified': 'WorkitemsAttributeChangeInstant',
            'modified_by': 'WorkitemsAttributeChangeString',
            'default_script_id': 'WorkitemsAttributeChangeString',
            'flow_id': 'WorkitemsAttributeChangeString',
            'rule_settings': 'WorkitemsAttributeChangeWorkitemRuleSettings',
            'unassigned_division_contacts_enabled': 'WorkitemsAttributeChangeBoolean'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'statuses': 'statuses',
            'default_workbin_id': 'defaultWorkbinId',
            'default_duration_seconds': 'defaultDurationSeconds',
            'default_expiration_seconds': 'defaultExpirationSeconds',
            'default_due_duration_seconds': 'defaultDueDurationSeconds',
            'default_priority': 'defaultPriority',
            'default_skill_ids': 'defaultSkillIds',
            'default_status_id': 'defaultStatusId',
            'default_language_id': 'defaultLanguageId',
            'default_ttl_seconds': 'defaultTtlSeconds',
            'assignment_enabled': 'assignmentEnabled',
            'default_queue_id': 'defaultQueueId',
            'schema_id': 'schemaId',
            'schema_version': 'schemaVersion',
            'service_level_target': 'serviceLevelTarget',
            'date_modified': 'dateModified',
            'modified_by': 'modifiedBy',
            'default_script_id': 'defaultScriptId',
            'flow_id': 'flowId',
            'rule_settings': 'ruleSettings',
            'unassigned_division_contacts_enabled': 'unassignedDivisionContactsEnabled'
        }

        self._name = None
        self._description = None
        self._statuses = None
        self._default_workbin_id = None
        self._default_duration_seconds = None
        self._default_expiration_seconds = None
        self._default_due_duration_seconds = None
        self._default_priority = None
        self._default_skill_ids = None
        self._default_status_id = None
        self._default_language_id = None
        self._default_ttl_seconds = None
        self._assignment_enabled = None
        self._default_queue_id = None
        self._schema_id = None
        self._schema_version = None
        self._service_level_target = None
        self._date_modified = None
        self._modified_by = None
        self._default_script_id = None
        self._flow_id = None
        self._rule_settings = None
        self._unassigned_division_contacts_enabled = None

    @property
    def name(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the name of this WorktypeDelta.


        :return: The name of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._name

    @name.setter
    def name(self, name: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the name of this WorktypeDelta.


        :param name: The name of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._name = name

    @property
    def description(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the description of this WorktypeDelta.


        :return: The description of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._description

    @description.setter
    def description(self, description: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the description of this WorktypeDelta.


        :param description: The description of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._description = description

    @property
    def statuses(self) -> 'WorkitemsAttributeChangeList':
        """
        Gets the statuses of this WorktypeDelta.


        :return: The statuses of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeList
        """
        return self._statuses

    @statuses.setter
    def statuses(self, statuses: 'WorkitemsAttributeChangeList') -> None:
        """
        Sets the statuses of this WorktypeDelta.


        :param statuses: The statuses of this WorktypeDelta.
        :type: WorkitemsAttributeChangeList
        """
        

        self._statuses = statuses

    @property
    def default_workbin_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the default_workbin_id of this WorktypeDelta.


        :return: The default_workbin_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._default_workbin_id

    @default_workbin_id.setter
    def default_workbin_id(self, default_workbin_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the default_workbin_id of this WorktypeDelta.


        :param default_workbin_id: The default_workbin_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._default_workbin_id = default_workbin_id

    @property
    def default_duration_seconds(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the default_duration_seconds of this WorktypeDelta.


        :return: The default_duration_seconds of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._default_duration_seconds

    @default_duration_seconds.setter
    def default_duration_seconds(self, default_duration_seconds: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the default_duration_seconds of this WorktypeDelta.


        :param default_duration_seconds: The default_duration_seconds of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._default_duration_seconds = default_duration_seconds

    @property
    def default_expiration_seconds(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the default_expiration_seconds of this WorktypeDelta.


        :return: The default_expiration_seconds of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._default_expiration_seconds

    @default_expiration_seconds.setter
    def default_expiration_seconds(self, default_expiration_seconds: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the default_expiration_seconds of this WorktypeDelta.


        :param default_expiration_seconds: The default_expiration_seconds of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._default_expiration_seconds = default_expiration_seconds

    @property
    def default_due_duration_seconds(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the default_due_duration_seconds of this WorktypeDelta.


        :return: The default_due_duration_seconds of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._default_due_duration_seconds

    @default_due_duration_seconds.setter
    def default_due_duration_seconds(self, default_due_duration_seconds: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the default_due_duration_seconds of this WorktypeDelta.


        :param default_due_duration_seconds: The default_due_duration_seconds of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._default_due_duration_seconds = default_due_duration_seconds

    @property
    def default_priority(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the default_priority of this WorktypeDelta.


        :return: The default_priority of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._default_priority

    @default_priority.setter
    def default_priority(self, default_priority: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the default_priority of this WorktypeDelta.


        :param default_priority: The default_priority of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._default_priority = default_priority

    @property
    def default_skill_ids(self) -> 'WorkitemsAttributeChangeList':
        """
        Gets the default_skill_ids of this WorktypeDelta.


        :return: The default_skill_ids of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeList
        """
        return self._default_skill_ids

    @default_skill_ids.setter
    def default_skill_ids(self, default_skill_ids: 'WorkitemsAttributeChangeList') -> None:
        """
        Sets the default_skill_ids of this WorktypeDelta.


        :param default_skill_ids: The default_skill_ids of this WorktypeDelta.
        :type: WorkitemsAttributeChangeList
        """
        

        self._default_skill_ids = default_skill_ids

    @property
    def default_status_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the default_status_id of this WorktypeDelta.


        :return: The default_status_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._default_status_id

    @default_status_id.setter
    def default_status_id(self, default_status_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the default_status_id of this WorktypeDelta.


        :param default_status_id: The default_status_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._default_status_id = default_status_id

    @property
    def default_language_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the default_language_id of this WorktypeDelta.


        :return: The default_language_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._default_language_id

    @default_language_id.setter
    def default_language_id(self, default_language_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the default_language_id of this WorktypeDelta.


        :param default_language_id: The default_language_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._default_language_id = default_language_id

    @property
    def default_ttl_seconds(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the default_ttl_seconds of this WorktypeDelta.


        :return: The default_ttl_seconds of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._default_ttl_seconds

    @default_ttl_seconds.setter
    def default_ttl_seconds(self, default_ttl_seconds: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the default_ttl_seconds of this WorktypeDelta.


        :param default_ttl_seconds: The default_ttl_seconds of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._default_ttl_seconds = default_ttl_seconds

    @property
    def assignment_enabled(self) -> 'WorkitemsAttributeChangeBoolean':
        """
        Gets the assignment_enabled of this WorktypeDelta.


        :return: The assignment_enabled of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeBoolean
        """
        return self._assignment_enabled

    @assignment_enabled.setter
    def assignment_enabled(self, assignment_enabled: 'WorkitemsAttributeChangeBoolean') -> None:
        """
        Sets the assignment_enabled of this WorktypeDelta.


        :param assignment_enabled: The assignment_enabled of this WorktypeDelta.
        :type: WorkitemsAttributeChangeBoolean
        """
        

        self._assignment_enabled = assignment_enabled

    @property
    def default_queue_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the default_queue_id of this WorktypeDelta.


        :return: The default_queue_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._default_queue_id

    @default_queue_id.setter
    def default_queue_id(self, default_queue_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the default_queue_id of this WorktypeDelta.


        :param default_queue_id: The default_queue_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._default_queue_id = default_queue_id

    @property
    def schema_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the schema_id of this WorktypeDelta.


        :return: The schema_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._schema_id

    @schema_id.setter
    def schema_id(self, schema_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the schema_id of this WorktypeDelta.


        :param schema_id: The schema_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._schema_id = schema_id

    @property
    def schema_version(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the schema_version of this WorktypeDelta.


        :return: The schema_version of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the schema_version of this WorktypeDelta.


        :param schema_version: The schema_version of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._schema_version = schema_version

    @property
    def service_level_target(self) -> 'WorkitemsAttributeChangeInteger':
        """
        Gets the service_level_target of this WorktypeDelta.


        :return: The service_level_target of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInteger
        """
        return self._service_level_target

    @service_level_target.setter
    def service_level_target(self, service_level_target: 'WorkitemsAttributeChangeInteger') -> None:
        """
        Sets the service_level_target of this WorktypeDelta.


        :param service_level_target: The service_level_target of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInteger
        """
        

        self._service_level_target = service_level_target

    @property
    def date_modified(self) -> 'WorkitemsAttributeChangeInstant':
        """
        Gets the date_modified of this WorktypeDelta.


        :return: The date_modified of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeInstant
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: 'WorkitemsAttributeChangeInstant') -> None:
        """
        Sets the date_modified of this WorktypeDelta.


        :param date_modified: The date_modified of this WorktypeDelta.
        :type: WorkitemsAttributeChangeInstant
        """
        

        self._date_modified = date_modified

    @property
    def modified_by(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the modified_by of this WorktypeDelta.


        :return: The modified_by of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the modified_by of this WorktypeDelta.


        :param modified_by: The modified_by of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._modified_by = modified_by

    @property
    def default_script_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the default_script_id of this WorktypeDelta.


        :return: The default_script_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._default_script_id

    @default_script_id.setter
    def default_script_id(self, default_script_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the default_script_id of this WorktypeDelta.


        :param default_script_id: The default_script_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._default_script_id = default_script_id

    @property
    def flow_id(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the flow_id of this WorktypeDelta.


        :return: The flow_id of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._flow_id

    @flow_id.setter
    def flow_id(self, flow_id: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the flow_id of this WorktypeDelta.


        :param flow_id: The flow_id of this WorktypeDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._flow_id = flow_id

    @property
    def rule_settings(self) -> 'WorkitemsAttributeChangeWorkitemRuleSettings':
        """
        Gets the rule_settings of this WorktypeDelta.


        :return: The rule_settings of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeWorkitemRuleSettings
        """
        return self._rule_settings

    @rule_settings.setter
    def rule_settings(self, rule_settings: 'WorkitemsAttributeChangeWorkitemRuleSettings') -> None:
        """
        Sets the rule_settings of this WorktypeDelta.


        :param rule_settings: The rule_settings of this WorktypeDelta.
        :type: WorkitemsAttributeChangeWorkitemRuleSettings
        """
        

        self._rule_settings = rule_settings

    @property
    def unassigned_division_contacts_enabled(self) -> 'WorkitemsAttributeChangeBoolean':
        """
        Gets the unassigned_division_contacts_enabled of this WorktypeDelta.


        :return: The unassigned_division_contacts_enabled of this WorktypeDelta.
        :rtype: WorkitemsAttributeChangeBoolean
        """
        return self._unassigned_division_contacts_enabled

    @unassigned_division_contacts_enabled.setter
    def unassigned_division_contacts_enabled(self, unassigned_division_contacts_enabled: 'WorkitemsAttributeChangeBoolean') -> None:
        """
        Sets the unassigned_division_contacts_enabled of this WorktypeDelta.


        :param unassigned_division_contacts_enabled: The unassigned_division_contacts_enabled of this WorktypeDelta.
        :type: WorkitemsAttributeChangeBoolean
        """
        

        self._unassigned_division_contacts_enabled = unassigned_division_contacts_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

