# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemRuleSettings

class WorktypeUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorktypeUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'default_workbin_id': 'str',
            'default_duration_seconds': 'int',
            'default_expiration_seconds': 'int',
            'default_due_duration_seconds': 'int',
            'default_priority': 'int',
            'default_ttl_seconds': 'int',
            'assignment_enabled': 'bool',
            'schema_id': 'str',
            'service_level_target': 'int',
            'rule_settings': 'WorkitemRuleSettings',
            'description': 'str',
            'default_status_id': 'str',
            'schema_version': 'int',
            'default_language_id': 'str',
            'default_skill_ids': 'list[str]',
            'default_queue_id': 'str',
            'default_script_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'default_workbin_id': 'defaultWorkbinId',
            'default_duration_seconds': 'defaultDurationSeconds',
            'default_expiration_seconds': 'defaultExpirationSeconds',
            'default_due_duration_seconds': 'defaultDueDurationSeconds',
            'default_priority': 'defaultPriority',
            'default_ttl_seconds': 'defaultTtlSeconds',
            'assignment_enabled': 'assignmentEnabled',
            'schema_id': 'schemaId',
            'service_level_target': 'serviceLevelTarget',
            'rule_settings': 'ruleSettings',
            'description': 'description',
            'default_status_id': 'defaultStatusId',
            'schema_version': 'schemaVersion',
            'default_language_id': 'defaultLanguageId',
            'default_skill_ids': 'defaultSkillIds',
            'default_queue_id': 'defaultQueueId',
            'default_script_id': 'defaultScriptId'
        }

        self._name = None
        self._default_workbin_id = None
        self._default_duration_seconds = None
        self._default_expiration_seconds = None
        self._default_due_duration_seconds = None
        self._default_priority = None
        self._default_ttl_seconds = None
        self._assignment_enabled = None
        self._schema_id = None
        self._service_level_target = None
        self._rule_settings = None
        self._description = None
        self._default_status_id = None
        self._schema_version = None
        self._default_language_id = None
        self._default_skill_ids = None
        self._default_queue_id = None
        self._default_script_id = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorktypeUpdate.
        The name of the Worktype. Valid length between 3 and 256 characters.

        :return: The name of this WorktypeUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorktypeUpdate.
        The name of the Worktype. Valid length between 3 and 256 characters.

        :param name: The name of this WorktypeUpdate.
        :type: str
        """
        
        if len(name) > 256:
            raise ValueError("Invalid value for `name`, length must be less than `256`")

        if len(name) < 3:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `3`")


        self._name = name

    @property
    def default_workbin_id(self) -> str:
        """
        Gets the default_workbin_id of this WorktypeUpdate.
        The ID of the default Workbin for Workitems created from the Worktype.

        :return: The default_workbin_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._default_workbin_id

    @default_workbin_id.setter
    def default_workbin_id(self, default_workbin_id: str) -> None:
        """
        Sets the default_workbin_id of this WorktypeUpdate.
        The ID of the default Workbin for Workitems created from the Worktype.

        :param default_workbin_id: The default_workbin_id of this WorktypeUpdate.
        :type: str
        """
        
        if not re.search('[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', default_workbin_id):
            raise ValueError("Invalid value for `default_workbin_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")


        self._default_workbin_id = default_workbin_id

    @property
    def default_duration_seconds(self) -> int:
        """
        Gets the default_duration_seconds of this WorktypeUpdate.
        The default duration in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :return: The default_duration_seconds of this WorktypeUpdate.
        :rtype: int
        """
        return self._default_duration_seconds

    @default_duration_seconds.setter
    def default_duration_seconds(self, default_duration_seconds: int) -> None:
        """
        Sets the default_duration_seconds of this WorktypeUpdate.
        The default duration in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :param default_duration_seconds: The default_duration_seconds of this WorktypeUpdate.
        :type: int
        """
        
        if default_duration_seconds > 31536000:
            raise ValueError("Invalid value for `default_duration_seconds`, must be a value less than or equal to `31536000`")

        if default_duration_seconds < 0:
            raise ValueError("Invalid value for `default_duration_seconds`, must be a value greater than or equal to `0`")


        self._default_duration_seconds = default_duration_seconds

    @property
    def default_expiration_seconds(self) -> int:
        """
        Gets the default_expiration_seconds of this WorktypeUpdate.
        The default expiration time in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :return: The default_expiration_seconds of this WorktypeUpdate.
        :rtype: int
        """
        return self._default_expiration_seconds

    @default_expiration_seconds.setter
    def default_expiration_seconds(self, default_expiration_seconds: int) -> None:
        """
        Sets the default_expiration_seconds of this WorktypeUpdate.
        The default expiration time in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :param default_expiration_seconds: The default_expiration_seconds of this WorktypeUpdate.
        :type: int
        """
        
        if default_expiration_seconds > 31536000:
            raise ValueError("Invalid value for `default_expiration_seconds`, must be a value less than or equal to `31536000`")

        if default_expiration_seconds < 0:
            raise ValueError("Invalid value for `default_expiration_seconds`, must be a value greater than or equal to `0`")


        self._default_expiration_seconds = default_expiration_seconds

    @property
    def default_due_duration_seconds(self) -> int:
        """
        Gets the default_due_duration_seconds of this WorktypeUpdate.
        The default due duration in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :return: The default_due_duration_seconds of this WorktypeUpdate.
        :rtype: int
        """
        return self._default_due_duration_seconds

    @default_due_duration_seconds.setter
    def default_due_duration_seconds(self, default_due_duration_seconds: int) -> None:
        """
        Sets the default_due_duration_seconds of this WorktypeUpdate.
        The default due duration in seconds for Workitems created from the Worktype. Maximum of 365 days.

        :param default_due_duration_seconds: The default_due_duration_seconds of this WorktypeUpdate.
        :type: int
        """
        
        if default_due_duration_seconds > 31536000:
            raise ValueError("Invalid value for `default_due_duration_seconds`, must be a value less than or equal to `31536000`")

        if default_due_duration_seconds < 0:
            raise ValueError("Invalid value for `default_due_duration_seconds`, must be a value greater than or equal to `0`")


        self._default_due_duration_seconds = default_due_duration_seconds

    @property
    def default_priority(self) -> int:
        """
        Gets the default_priority of this WorktypeUpdate.
        The default priority for Workitems created from the Worktype. The valid range is between -25,000,000 and 25,000,000.

        :return: The default_priority of this WorktypeUpdate.
        :rtype: int
        """
        return self._default_priority

    @default_priority.setter
    def default_priority(self, default_priority: int) -> None:
        """
        Sets the default_priority of this WorktypeUpdate.
        The default priority for Workitems created from the Worktype. The valid range is between -25,000,000 and 25,000,000.

        :param default_priority: The default_priority of this WorktypeUpdate.
        :type: int
        """
        
        if default_priority > 25000000:
            raise ValueError("Invalid value for `default_priority`, must be a value less than or equal to `25000000`")

        if default_priority < -25000000:
            raise ValueError("Invalid value for `default_priority`, must be a value greater than or equal to `-25000000`")


        self._default_priority = default_priority

    @property
    def default_ttl_seconds(self) -> int:
        """
        Gets the default_ttl_seconds of this WorktypeUpdate.
        The default time to time to live in seconds for Workitems created from the Worktype. The valid range is between 1 and 365 days.

        :return: The default_ttl_seconds of this WorktypeUpdate.
        :rtype: int
        """
        return self._default_ttl_seconds

    @default_ttl_seconds.setter
    def default_ttl_seconds(self, default_ttl_seconds: int) -> None:
        """
        Sets the default_ttl_seconds of this WorktypeUpdate.
        The default time to time to live in seconds for Workitems created from the Worktype. The valid range is between 1 and 365 days.

        :param default_ttl_seconds: The default_ttl_seconds of this WorktypeUpdate.
        :type: int
        """
        
        if default_ttl_seconds > 31536000:
            raise ValueError("Invalid value for `default_ttl_seconds`, must be a value less than or equal to `31536000`")

        if default_ttl_seconds < 86400:
            raise ValueError("Invalid value for `default_ttl_seconds`, must be a value greater than or equal to `86400`")


        self._default_ttl_seconds = default_ttl_seconds

    @property
    def assignment_enabled(self) -> bool:
        """
        Gets the assignment_enabled of this WorktypeUpdate.
        When set to true, Workitems will be sent to the queue of the Worktype as they are created. Default value is false.

        :return: The assignment_enabled of this WorktypeUpdate.
        :rtype: bool
        """
        return self._assignment_enabled

    @assignment_enabled.setter
    def assignment_enabled(self, assignment_enabled: bool) -> None:
        """
        Sets the assignment_enabled of this WorktypeUpdate.
        When set to true, Workitems will be sent to the queue of the Worktype as they are created. Default value is false.

        :param assignment_enabled: The assignment_enabled of this WorktypeUpdate.
        :type: bool
        """
        

        self._assignment_enabled = assignment_enabled

    @property
    def schema_id(self) -> str:
        """
        Gets the schema_id of this WorktypeUpdate.
        The ID of the custom attribute schema for Workitems created from the Worktype. Must be a valid UUID.

        :return: The schema_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._schema_id

    @schema_id.setter
    def schema_id(self, schema_id: str) -> None:
        """
        Sets the schema_id of this WorktypeUpdate.
        The ID of the custom attribute schema for Workitems created from the Worktype. Must be a valid UUID.

        :param schema_id: The schema_id of this WorktypeUpdate.
        :type: str
        """
        
        if not re.search('[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', schema_id):
            raise ValueError("Invalid value for `schema_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")


        self._schema_id = schema_id

    @property
    def service_level_target(self) -> int:
        """
        Gets the service_level_target of this WorktypeUpdate.
        The target service level for Workitems created from the Worktype. The default value is 100.

        :return: The service_level_target of this WorktypeUpdate.
        :rtype: int
        """
        return self._service_level_target

    @service_level_target.setter
    def service_level_target(self, service_level_target: int) -> None:
        """
        Sets the service_level_target of this WorktypeUpdate.
        The target service level for Workitems created from the Worktype. The default value is 100.

        :param service_level_target: The service_level_target of this WorktypeUpdate.
        :type: int
        """
        
        if service_level_target > 100:
            raise ValueError("Invalid value for `service_level_target`, must be a value less than or equal to `100`")

        if service_level_target < 1:
            raise ValueError("Invalid value for `service_level_target`, must be a value greater than or equal to `1`")


        self._service_level_target = service_level_target

    @property
    def rule_settings(self) -> 'WorkitemRuleSettings':
        """
        Gets the rule_settings of this WorktypeUpdate.
        Settings for the worktypes rules.

        :return: The rule_settings of this WorktypeUpdate.
        :rtype: WorkitemRuleSettings
        """
        return self._rule_settings

    @rule_settings.setter
    def rule_settings(self, rule_settings: 'WorkitemRuleSettings') -> None:
        """
        Sets the rule_settings of this WorktypeUpdate.
        Settings for the worktypes rules.

        :param rule_settings: The rule_settings of this WorktypeUpdate.
        :type: WorkitemRuleSettings
        """
        

        self._rule_settings = rule_settings

    @property
    def description(self) -> str:
        """
        Gets the description of this WorktypeUpdate.
        The description of the Worktype. Maximum length of 512 characters.

        :return: The description of this WorktypeUpdate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this WorktypeUpdate.
        The description of the Worktype. Maximum length of 512 characters.

        :param description: The description of this WorktypeUpdate.
        :type: str
        """
        

        self._description = description

    @property
    def default_status_id(self) -> str:
        """
        Gets the default_status_id of this WorktypeUpdate.
        The ID of the default status for Workitems created from the Worktype. Must be a valid UUID.

        :return: The default_status_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._default_status_id

    @default_status_id.setter
    def default_status_id(self, default_status_id: str) -> None:
        """
        Sets the default_status_id of this WorktypeUpdate.
        The ID of the default status for Workitems created from the Worktype. Must be a valid UUID.

        :param default_status_id: The default_status_id of this WorktypeUpdate.
        :type: str
        """
        
        if not re.search('[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', default_status_id):
            raise ValueError("Invalid value for `default_status_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")


        self._default_status_id = default_status_id

    @property
    def schema_version(self) -> int:
        """
        Gets the schema_version of this WorktypeUpdate.
        The version of the Worktypes custom attribute schema. The latest schema version will be used if this property is not set.

        :return: The schema_version of this WorktypeUpdate.
        :rtype: int
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version: int) -> None:
        """
        Sets the schema_version of this WorktypeUpdate.
        The version of the Worktypes custom attribute schema. The latest schema version will be used if this property is not set.

        :param schema_version: The schema_version of this WorktypeUpdate.
        :type: int
        """
        

        self._schema_version = schema_version

    @property
    def default_language_id(self) -> str:
        """
        Gets the default_language_id of this WorktypeUpdate.
        The ID of the default language for Workitems created from the Worktype. Must be a valid UUID.

        :return: The default_language_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._default_language_id

    @default_language_id.setter
    def default_language_id(self, default_language_id: str) -> None:
        """
        Sets the default_language_id of this WorktypeUpdate.
        The ID of the default language for Workitems created from the Worktype. Must be a valid UUID.

        :param default_language_id: The default_language_id of this WorktypeUpdate.
        :type: str
        """
        

        self._default_language_id = default_language_id

    @property
    def default_skill_ids(self) -> List[str]:
        """
        Gets the default_skill_ids of this WorktypeUpdate.
        The IDs of the default skills for Workitems created from the Worktype. Must be valid UUIDs. Maximum of 20 IDs

        :return: The default_skill_ids of this WorktypeUpdate.
        :rtype: list[str]
        """
        return self._default_skill_ids

    @default_skill_ids.setter
    def default_skill_ids(self, default_skill_ids: List[str]) -> None:
        """
        Sets the default_skill_ids of this WorktypeUpdate.
        The IDs of the default skills for Workitems created from the Worktype. Must be valid UUIDs. Maximum of 20 IDs

        :param default_skill_ids: The default_skill_ids of this WorktypeUpdate.
        :type: list[str]
        """
        

        self._default_skill_ids = default_skill_ids

    @property
    def default_queue_id(self) -> str:
        """
        Gets the default_queue_id of this WorktypeUpdate.
        The ID of the default queue for Workitems created from the Worktype. Must be a valid UUID.

        :return: The default_queue_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._default_queue_id

    @default_queue_id.setter
    def default_queue_id(self, default_queue_id: str) -> None:
        """
        Sets the default_queue_id of this WorktypeUpdate.
        The ID of the default queue for Workitems created from the Worktype. Must be a valid UUID.

        :param default_queue_id: The default_queue_id of this WorktypeUpdate.
        :type: str
        """
        

        self._default_queue_id = default_queue_id

    @property
    def default_script_id(self) -> str:
        """
        Gets the default_script_id of this WorktypeUpdate.
        The default script for Workitems created from the Worktype. Must be a valid UUID.

        :return: The default_script_id of this WorktypeUpdate.
        :rtype: str
        """
        return self._default_script_id

    @default_script_id.setter
    def default_script_id(self, default_script_id: str) -> None:
        """
        Sets the default_script_id of this WorktypeUpdate.
        The default script for Workitems created from the Worktype. Must be a valid UUID.

        :param default_script_id: The default_script_id of this WorktypeUpdate.
        :type: str
        """
        

        self._default_script_id = default_script_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

