from typing import Union

import numpy as np
import pandas as pd

UNIVARIATE_FORECAST = 1
UNIVARIATE_ENDOGENOUS_FORECAST = UNIVARIATE_FORECAST
UNIVARIATE_EXOGENOUS_FORECAST = 2
UNIVARIATE_TASKS = [UNIVARIATE_FORECAST, UNIVARIATE_EXOGENOUS_FORECAST]

MULTIVARIATE_FORECAST = 3
MULTIVARIATE_ENDOGENOUS_FORECAST = MULTIVARIATE_FORECAST
MULTIVARIATE_EXOGENOUS_FORECAST = 4
MULTIVARIATE_TASKS = [MULTIVARIATE_FORECAST, MULTIVARIATE_EXOGENOUS_FORECAST]

PANEL_FORECAST = 5
PANEL_ENDOGENOUS_FORECAST = PANEL_FORECAST
PANEL_EXOGENOUS_FORECAST = 6
PANEL_INDIRECT_FORECAST = 7
PANEL_INDIRECT_EXOGENOUS_FORECAST = PANEL_INDIRECT_FORECAST
PANEL_TASKS = [PANEL_FORECAST, PANEL_EXOGENOUS_FORECAST, PANEL_INDIRECT_FORECAST]

FORECAST_TASK = UNIVARIATE_TASKS + MULTIVARIATE_TASKS + PANEL_TASKS

TASK_TYPES = FORECAST_TASK

TASK_TYPES_TO_STRING = {
    UNIVARIATE_FORECAST: 'forecast.univariate.endogenous',
    UNIVARIATE_EXOGENOUS_FORECAST: 'forecast.univariate.exogenous',
    MULTIVARIATE_FORECAST: 'forecast.multivariate.endogenous',
    MULTIVARIATE_EXOGENOUS_FORECAST: 'forecast.multivariate.exogenous',
    PANEL_FORECAST: 'forecast.panel.endogenous',
    PANEL_EXOGENOUS_FORECAST: 'forecast.panel.exogenous',
    PANEL_INDIRECT_FORECAST: 'forecast.panel.indirect',
}
STRING_TO_TASK_TYPES = {value: key for key, value in TASK_TYPES_TO_STRING.items()}

HANDLES_UNIVARIATE = 'cap:handles-univariate'
HANDLES_MULTIVARIATE = 'cap:handles-multivariate'
HANDLES_PANEL = 'cap:handles-panel'
HANDLES_CATEGORICAL = 'cap:handles-categorical'
IGNORES_EXOGENOUS_X = 'ignores-exogenous-X'
SUPPORTED_INDEX_TYPES = 'supported-index-types'

MAXINT = 2 ** 31 - 1

SUPPORTED_Y_TYPES = Union[pd.Series, pd.DataFrame, np.ndarray]
