# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClientFacingCriticalResult(UniversalBaseModel):
    order_id: str = pydantic.Field()
    """
    The Vital Order ID
    """

    sample_id: str = pydantic.Field()
    """
    Sample ID
    """

    status: str = pydantic.Field()
    """
    The current results status, can be either (final, partial).
    """

    interpretation: str = pydantic.Field()
    """
    The results interpretation, can be one of (normal, abnormal, critical).
    """

    team_id: str = pydantic.Field()
    """
    Your team id.
    """

    user_id: str
    created_at: dt.datetime = pydantic.Field()
    """
    When the result was first fetched from a laboratory.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    When the result was last fetched from a laboratory.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
