"""
Custom exceptions for PromptSim.
"""


class PromptSimError(Exception):
    """Base exception for PromptSim errors."""
    pass


class PromptNotFoundError(PromptSimError):
    """Raised when a prompt is not found."""
    pass


class ValidationError(PromptSimError):
    """Raised when validation fails."""
    pass


class StorageError(PromptSimError):
    """Raised when storage operations fail."""
    pass


class OpenAIError(PromptSimError):
    """Raised when OpenAI API calls fail."""
    pass


class ExperimentError(PromptSimError):
    """Raised when experiment operations fail."""
    pass