import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Evidently extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to send a batched evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_BatchEvaluateFeature.html
     */
    toBatchEvaluateFeature(): this;
    /**
     * Grants permission to create an experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html
     */
    toCreateExperiment(): this;
    /**
     * Grants permission to create a feature
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateFeature.html
     */
    toCreateFeature(): this;
    /**
     * Grants permission to create a launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html
     */
    toCreateLaunch(): this;
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html
     */
    toCreateProject(): this;
    /**
     * Grants permission to delete an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteExperiment.html
     */
    toDeleteExperiment(): this;
    /**
     * Grants permission to delete a feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html
     */
    toDeleteFeature(): this;
    /**
     * Grants permission to delete a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteLaunch.html
     */
    toDeleteLaunch(): this;
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject(): this;
    /**
     * Grants permission to send an evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html
     */
    toEvaluateFeature(): this;
    /**
     * Grants permission to get experiment details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperiment.html
     */
    toGetExperiment(): this;
    /**
     * Grants permission to get experiment result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperimentResults.html
     */
    toGetExperimentResults(): this;
    /**
     * Grants permission to get feature details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetFeature.html
     */
    toGetFeature(): this;
    /**
     * Grants permission to get launch details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetLaunch.html
     */
    toGetLaunch(): this;
    /**
     * Grants permission to get project details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetProject.html
     */
    toGetProject(): this;
    /**
     * Grants permission to list experiments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html
     */
    toListExperiments(): this;
    /**
     * Grants permission to list features
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html
     */
    toListFeatures(): this;
    /**
     * Grants permission to list launches
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html
     */
    toListLaunches(): this;
    /**
     * Grants permission to list projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html
     */
    toListProjects(): this;
    /**
     * Grants permission to list tags for resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to send performance events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_PutProjectEvents.html
     */
    toPutProjectEvents(): this;
    /**
     * Grants permission to start an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartExperiment.html
     */
    toStartExperiment(): this;
    /**
     * Grants permission to start a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartLaunch.html
     */
    toStartLaunch(): this;
    /**
     * Grants permission to stop an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html
     */
    toStopExperiment(): this;
    /**
     * Grants permission to stop a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html
     */
    toStopLaunch(): this;
    /**
     * Grants permission to tag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html
     */
    toUpdateExperiment(): this;
    /**
     * Grants permission to update feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html
     */
    toUpdateFeature(): this;
    /**
     * Grants permission to update a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html
     */
    toUpdateLaunch(): this;
    /**
     * Grants permission to update project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html
     */
    toUpdateProject(): this;
    /**
     * Grants permission to update project data delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html
     */
    toUpdateProjectDataDelivery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Project to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/projects.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProject(ownerAccountId: string, projectName: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Feature to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/features.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param featureName - Identifier for the featureName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFeature(ownerAccountId: string, projectName: string, featureName: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Experiment to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/experiments.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param experimentName - Identifier for the experimentName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperiment(ownerAccountId: string, projectName: string, experimentName: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Launch to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/launches.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param launchName - Identifier for the launchName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunch(ownerAccountId: string, projectName: string, launchName: string, region?: string, partition?: string): this;
}
