import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Inspector2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate an account with an Amazon Inspector administrator account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_AssociateMember.html
     */
    toAssociateMember(): this;
    /**
     * Grants permission to retrieve information about Amazon Inspector accounts for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetAccountStatus.html
     */
    toBatchGetAccountStatus(): this;
    /**
     * Grants permission to retrieve free trial period eligibility about Amazon Inspector accounts for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetFreeTrialInfo.html
     */
    toBatchGetFreeTrialInfo(): this;
    /**
     * Grants permission to cancel the generation of a findings report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CancelFindingsReport.html
     */
    toCancelFindingsReport(): this;
    /**
     * Grants permission to create and define the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFilter.html
     */
    toCreateFilter(): this;
    /**
     * Grants permission to request the generation of a findings report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFindingsReport.html
     */
    toCreateFindingsReport(): this;
    /**
     * Grants permission to delete a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DeleteFilter.html
     */
    toDeleteFilter(): this;
    /**
     * Grants permission to retrieve information about the Amazon Inspector configuration settings for an AWS organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DescribeOrganizationConfiguration.html
     */
    toDescribeOrganizationConfiguration(): this;
    /**
     * Grants permission to disable an Amazon Inspector account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Disable.html
     */
    toDisable(): this;
    /**
     * Grants permission to disable an account as the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisableDelegatedAdminAccount.html
     */
    toDisableDelegatedAdminAccount(): this;
    /**
     * Grants permission to an Amazon Inspector administrator account to disassociate from an Inspector member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisassociateMember.html
     */
    toDisassociateMember(): this;
    /**
     * Grants permission to enable and specify the configuration settings for a new Amazon Inspector account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Enable.html
     */
    toEnable(): this;
    /**
     * Grants permission to enable an account as the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_EnableDelegatedAdminAccount.html
     */
    toEnableDelegatedAdminAccount(): this;
    /**
     * Grants permission to retrieve information about the Amazon Inspector administrator account for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetDelegatedAdminAccount.html
     */
    toGetDelegatedAdminAccount(): this;
    /**
     * Grants permission to retrieve status for a requested findings report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetFindingsReportStatus.html
     */
    toGetFindingsReportStatus(): this;
    /**
     * Grants permission to retrieve information about an account that's associated with an Amazon Inspector administrator account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html
     */
    toGetMember(): this;
    /**
     * Grants permission to retrieve feature configuration permissions associated with an Amazon Inspector account within an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListAccountPermissions.html
     */
    toListAccountPermissions(): this;
    /**
     * Grants permission to retrieve the types of statistics Amazon Inspector can generate for resources Inspector monitors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverage.html
     */
    toListCoverage(): this;
    /**
     * Grants permission to retrieve statistical data and other information about the resources Amazon Inspector monitors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverageStatistics.html
     */
    toListCoverageStatistics(): this;
    /**
     * Grants permission to retrieve information about the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListDelegatedAdminAccounts.html
     */
    toListDelegatedAdminAccounts(): this;
    /**
     * Grants permission to retrieve information about all findings filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFilters.html
     */
    toListFilters(): this;
    /**
     * Grants permission to retrieve statistical data and other information about Amazon Inspector findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindingAggregations.html
     */
    toListFindingAggregations(): this;
    /**
     * Grants permission to retrieve a subset of information about one or more findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindings.html
     */
    toListFindings(): this;
    /**
     * Grants permission to retrieve information about the Amazon Inspector member accounts that are associated with an Inspector administrator account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html
     */
    toListMembers(): this;
    /**
     * Grants permission to retrieve the tags for an Amazon Inspector resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve aggregated usage data for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListUsageTotals.html
     */
    toListUsageTotals(): this;
    /**
     * Grants permission to add or update the tags for an Amazon Inspector resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from an Amazon Inspector resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateFilter.html
     */
    toUpdateFilter(): this;
    /**
     * Grants permission to update Amazon Inspector configuration settings for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateOrganizationConfiguration.html
     */
    toUpdateOrganizationConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Filter to the statement
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param ownerId - Identifier for the ownerId.
     * @param filterId - Identifier for the filterId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFilter(ownerId: string, filterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Finding to the statement
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param findingId - Identifier for the findingId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFinding(findingId: string, account?: string, region?: string, partition?: string): this;
}
