import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [m2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmainframemodernizationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class M2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [m2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmainframemodernizationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel the execution of a batch job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_CancelBatchJobExecution.html
     */
    toCancelBatchJobExecution(): this;
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create a data set import task
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html
     */
    toCreateDataSetImportTask(): this;
    /**
     * Grants permission to create a deployment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticloadbalancing:CreateListener
     * - elasticloadbalancing:CreateTargetGroup
     * - elasticloadbalancing:RegisterTargets
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDeployment.html
     */
    toCreateDeployment(): this;
    /**
     * Grants permission to Create an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcs
     * - ec2:ModifyNetworkInterfaceAttribute
     * - elasticfilesystem:DescribeMountTargets
     * - elasticloadbalancing:CreateLoadBalancer
     * - fsx:DescribeFileSystems
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateEnvironment.html
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticloadbalancing:DeleteListener
     * - elasticloadbalancing:DeleteTargetGroup
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete an application from a runtime environment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticloadbalancing:DeleteListener
     * - elasticloadbalancing:DeleteTargetGroup
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_DeleteApplicationFromEnvironment.html
     */
    toDeleteApplicationFromEnvironment(): this;
    /**
     * Grants permission to delete a runtime environment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticloadbalancing:DeleteLoadBalancer
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_DeleteEnvironment.html
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to retrieve an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetApplication.html
     */
    toGetApplication(): this;
    /**
     * Grants permission to retrieve an application version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetApplicationVersion.html
     */
    toGetApplicationVersion(): this;
    /**
     * Grants permission to retrieve a batch job execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetBatchJobExecution.html
     */
    toGetBatchJobExecution(): this;
    /**
     * Grants permission to retrieve data set details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetDataSetDetails.html
     */
    toGetDataSetDetails(): this;
    /**
     * Grants permission to retrieve a data set import task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetDataSetImportTask.html
     */
    toGetDataSetImportTask(): this;
    /**
     * Grants permission to retrieve a deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetDeployment.html
     */
    toGetDeployment(): this;
    /**
     * Grants permission to retrieve a runtime environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_GetEnvironment.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to list the versions of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListApplicationVersions.html
     */
    toListApplicationVersions(): this;
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list batch job definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListBatchJobDefinitions.html
     */
    toListBatchJobDefinitions(): this;
    /**
     * Grants permission to list executions for a batch job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListBatchJobExecutions.html
     */
    toListBatchJobExecutions(): this;
    /**
     * Grants permission to list data set import history
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListDataSetImportHistory.html
     */
    toListDataSetImportHistory(): this;
    /**
     * Grants permission to list data sets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListDataSets.html
     */
    toListDataSets(): this;
    /**
     * Grants permission to list deployments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListDeployments.html
     */
    toListDeployments(): this;
    /**
     * Grants permission to list engine versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListEngineVersions.html
     */
    toListEngineVersions(): this;
    /**
     * Grants permission to list runtime environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListEnvironments.html
     */
    toListEnvironments(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_StartApplication.html
     */
    toStartApplication(): this;
    /**
     * Grants permission to start a batch job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_StartBatchJob.html
     */
    toStartBatchJob(): this;
    /**
     * Grants permission to stop an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_StopApplication.html
     */
    toStopApplication(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update a runtime environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/m2/latest/APIReference/API_UpdateEnvironment.html
     */
    toUpdateEnvironment(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Application to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concept-m2.html#application-concept
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Environment to the statement
     *
     * https://docs.aws.amazon.com/m2/latest/userguide/concept-m2.html#environment-concept
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
}
