import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [sns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsns.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Sns extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [sns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsns.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add a statement to a topic's access control policy, granting access for the specified AWS accounts to the specified actions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_AddPermission.html
     */
    toAddPermission(): this;
    /**
     * Grants permission to accept a phone number and indicate whether the phone holder has opted out of receiving SMS messages from your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_CheckIfPhoneNumberIsOptedOut.html
     */
    toCheckIfPhoneNumberIsOptedOut(): this;
    /**
     * Grants permission to verify an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an earlier Subscribe action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ConfirmSubscription.html
     */
    toConfirmSubscription(): this;
    /**
     * Grants permission to create a platform application object for one of the supported push notification services, such as APNS and GCM, to which devices and mobile apps may register
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformApplication.html
     */
    toCreatePlatformApplication(): this;
    /**
     * Grants permission to create an endpoint for a device and mobile app on one of the supported push notification services, such as GCM and APNS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_CreatePlatformEndpoint.html
     */
    toCreatePlatformEndpoint(): this;
    /**
     * Grants permission to add a destination phone number and send a one-time password (OTP) to that phone number for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_CreateSMSSandboxPhoneNumber.html
     */
    toCreateSMSSandboxPhoneNumber(): this;
    /**
     * Grants permission to create a topic to which notifications can be published
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html
     */
    toCreateTopic(): this;
    /**
     * Grants permission to delete the endpoint for a device and mobile app from Amazon SNS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_DeleteEndpoint.html
     */
    toDeleteEndpoint(): this;
    /**
     * Grants permission to delete a platform application object for one of the supported push notification services, such as APNS and GCM
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_DeletePlatformApplication.html
     */
    toDeletePlatformApplication(): this;
    /**
     * Grants permission to delete an AWS account's verified or pending phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_DeleteSMSSandboxPhoneNumber.html
     */
    toDeleteSMSSandboxPhoneNumber(): this;
    /**
     * Grants permission to delete a topic and all its subscriptions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_DeleteTopic.html
     */
    toDeleteTopic(): this;
    /**
     * Grants permission to retrieve the endpoint attributes for a device on one of the supported push notification services, such as GCM and APNS
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetEndpointAttributes.html
     */
    toGetEndpointAttributes(): this;
    /**
     * Grants permission to retrieve the attributes of the platform application object for the supported push notification services, such as APNS and GCM
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetPlatformApplicationAttributes.html
     */
    toGetPlatformApplicationAttributes(): this;
    /**
     * Grants permission to return the settings for sending SMS messages from your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetSMSAttributes.html
     */
    toGetSMSAttributes(): this;
    /**
     * Grants permission to retrieve the sandbox status for the calling account in the target region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetSMSSandboxAccountStatus.html
     */
    toGetSMSSandboxAccountStatus(): this;
    /**
     * Grants permission to return all of the properties of a subscription
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html
     */
    toGetSubscriptionAttributes(): this;
    /**
     * Grants permission to return all of the properties of a topic
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_GetTopicAttributes.html
     */
    toGetTopicAttributes(): this;
    /**
     * Grants permission to list the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM and APNS
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListEndpointsByPlatformApplication.html
     */
    toListEndpointsByPlatformApplication(): this;
    /**
     * Grants permission to list all origination numbers, and their metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListOriginationNumbers.html
     */
    toListOriginationNumbers(): this;
    /**
     * Grants permission to return a list of phone numbers that are opted out, meaning you cannot send SMS messages to them
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListPhoneNumbersOptedOut.html
     */
    toListPhoneNumbersOptedOut(): this;
    /**
     * Grants permission to list the platform application objects for the supported push notification services, such as APNS and GCM
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListPlatformApplications.html
     */
    toListPlatformApplications(): this;
    /**
     * Grants permission to list the calling account's current pending and verified destination phone numbers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListSMSSandboxPhoneNumbers.html
     */
    toListSMSSandboxPhoneNumbers(): this;
    /**
     * Grants permission to return a list of the requester's subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListSubscriptions.html
     */
    toListSubscriptions(): this;
    /**
     * Grants permission to return a list of the subscriptions to a specific topic
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListSubscriptionsByTopic.html
     */
    toListSubscriptionsByTopic(): this;
    /**
     * Grants permission to list all tags added to the specified Amazon SNS topic
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to return a list of the requester's topics
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html
     */
    toListTopics(): this;
    /**
     * Grants permission to opt in a phone number that is currently opted out, which enables you to resume sending SMS messages to the number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_OptInPhoneNumber.html
     */
    toOptInPhoneNumber(): this;
    /**
     * Grants permission to send a message to all of a topic's subscribed endpoints
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_Publish.html
     */
    toPublish(): this;
    /**
     * Grants permission to remove a statement from a topic's access control policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_RemovePermission.html
     */
    toRemovePermission(): this;
    /**
     * Grants permission to set the attributes for an endpoint for a device on one of the supported push notification services, such as GCM and APNS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html
     */
    toSetEndpointAttributes(): this;
    /**
     * Grants permission to set the attributes of the platform application object for the supported push notification services, such as APNS and GCM
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html
     */
    toSetPlatformApplicationAttributes(): this;
    /**
     * Grants permission to set the default settings for sending SMS messages and receiving daily SMS usage reports
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html
     */
    toSetSMSAttributes(): this;
    /**
     * Grants permission to allow a subscription owner to set an attribute of the topic to a new value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_SetSubscriptionAttributes.html
     */
    toSetSubscriptionAttributes(): this;
    /**
     * Grants permission to allow a topic owner to set an attribute of the topic to a new value
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_SetTopicAttributes.html
     */
    toSetTopicAttributes(): this;
    /**
     * Grants permission to prepare to subscribe an endpoint by sending the endpoint a confirmation message
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEndpoint()
     * - .ifProtocol()
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html
     */
    toSubscribe(): this;
    /**
     * Grants permission to add tags to the specified Amazon SNS topic
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to delete a subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_Unsubscribe.html
     */
    toUnsubscribe(): this;
    /**
     * Grants permission to remove tags from the specified Amazon SNS topic
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to verify a destination phone number with a one-time password (OTP) for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sns/latest/api/API_VerifySMSSandboxPhoneNumber.html
     */
    toVerifySMSSandboxPhoneNumber(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html
     *
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTopic(topicName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the URL, email address, or ARN from a Subscribe request or a previously confirmed subscription
     *
     * https://docs.aws.amazon.com/sns/latest/dg/UsingIAMwithSNS.html#w2ab1c11c23c19
     *
     * Applies to actions:
     * - .toSubscribe()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEndpoint(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the protocol value from a Subscribe request or a previously confirmed subscription
     *
     * https://docs.aws.amazon.com/sns/latest/dg/UsingIAMwithSNS.html#w2ab1c11c23c19
     *
     * Applies to actions:
     * - .toSubscribe()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProtocol(value: string | string[], operator?: Operator | string): this;
}
