/**
 * Base class for the Policy Statement
 */
export declare class PolicyStatementBase {
    /**
     * The default partition for ARNs (such as one of [aws, aws-us-gov, aws-cn]). In
     * CDK applications, this is a reference to the current partition, otherwise, 'aws'.
     */
    protected static readonly defaultPartition = "aws";
    sid: string;
    /**
     * Holds the prefix of the service actions, e.g. `ec2`
     */
    servicePrefix: string;
    constructor(sid?: string);
    /**
     * JSON-ify the policy statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON(): any;
}
