import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="wolk-connect",
    version="3.0.5",
    install_requires=["paho_mqtt==1.3.1", "python-persistent-queue==1.3.0"],
    include_package_data=True,
    license="Apache License 2.0",
    author="Danilo Jesic",
    author_email="danilo.jesic@wolkabout.com",
    description="Python 3 library for connecting to WolkAbout IoT Platform",
    long_description=long_description,
    long_description_content_type="text/markdown",
    keywords=["IoT", "WolkAbout", "Internet of Things"],
    url="https://github.com/Wolkabout/WolkConnect-Python",
    packages=setuptools.find_packages(),
    classifiers=(
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3 :: Only",
        "Operating System :: OS Independent",
        "Topic :: Internet",
    ),
)
