package org.kson.jsonsuite

import jsonTestSuiteSHA
import schemaTestSuiteSHA
import kotlin.io.path.createTempDirectory
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertTrue

class JsonTestSuiteGeneratorTest {

    /**
     * Integration test for [JsonTestSuiteGenerator.generate] that runs against actual checkouts of [JSONTestSuite](https://github.com/nst/JSONTestSuite)
     * and [JSON-Schema-Test-Suite](https://github.com/json-schema-org/JSON-Schema-Test-Suite)
     *
     * TODO: this currently depends on performing actual git clones over the network that may be undesirable/unreliable
     *   in our tests.  We should be able to point these tests to locally cached versions on these repos if/when this
     *   is a problem
     */
    @Test
    fun testGenerate() {
        val tempDirectory = createTempDirectory("JsonTestSuiteGeneratorTest")

        val testPackageName = "org.json.parser.json.generated.TEST"

        val jsonTestSuiteGenerator = JsonTestSuiteGenerator(
            JsonSuiteGitCheckout(jsonTestSuiteSHA, tempDirectory),
            SchemaSuiteGitCheckout(schemaTestSuiteSHA, tempDirectory),
            tempDirectory,
            tempDirectory,
            testPackageName)

        jsonTestSuiteGenerator.generate()

        assertTrue(
            jsonTestSuiteGenerator.jsonTestSourceFilesDir.toFile().isDirectory,
            "test suite directory should exist and be a directory"
        )

        val generatedTestContents = jsonTestSuiteGenerator.generatedJsonSuiteTestPath.toFile().readText()

        assertTrue(
            generatedTestContents
                // sanity check this is the test class we expect to be generated by checking its classname
                .contains("class JsonSuiteTest"),
            "test class should be generated"
        )

        val packageNameStartIndex = "package ".length
        assertEquals(
            testPackageName,
            generatedTestContents.substring(packageNameStartIndex, packageNameStartIndex + testPackageName.length),
            "generated test file should start with configured package declaration"
        )
    }
}