# -*- coding: utf-8 -*-

# source: https://github.com/cucumber/gherkin/blob/master/lib/gherkin/i18n.json

TRANSLATIONS = {
    "en": {
        "name": u"English",
        "native": u"English",
        "feature": u"Feature|Business Need|Ability",
        "background": u"Background",
        "scenario": u"Scenario Outline|Scenario Template|Scenario",
        "examples": u"Examples|Scenarios",
        "given": u"Given",
        "when": u"When",
        "then": u"Then",
        "and": u"And",
        "but": u"But"
    },
    "af": {
        "name": u"Afrikaans",
        "native": u"Afrikaans",
        "feature": u"Funksie|Besigheid Behoefte|Vermoë",
        "background": u"Agtergrond",
        "scenario": u"Situasie Uiteensetting|Situasie",
        "examples": u"Voorbeelde",
        "given": u"Gegewe",
        "when": u"Wanneer",
        "then": u"Dan",
        "and": u"En",
        "but": u"Maar"
    },
    "ar": {
        "name": u"Arabic",
        "native": u"العربية",
        "feature": u"خاصية",
        "background": u"الخلفية",
        "scenario": u"سيناريو مخطط|سيناريو",
        "examples": u"امثلة",
        "given": u"بفرض",
        "when": u"متى|عندما",
        "then": u"اذاً|ثم",
        "and": u"و",
        "but": u"لكن"
    },
    "bm": {
        "name": u"Malay",
        "native": u"Bahasa Melayu",
        "feature": u"Fungsi",
        "background": u"Latar Belakang",
        "scenario": u"Template Senario|Template Situai|Template Keadaan|Menggariskan Senario|Senario|Situai|Keadaan",
        "examples": u"Contoh",
        "given": u"Diberi|Bagi",
        "when": u"Apabila",
        "then": u"Maka|Kemudian",
        "and": u"Dan",
        "but": u"Tetapi|Tapi"
    },
    "bg": {
        "name": u"Bulgarian",
        "native": u"български",
        "feature": u"Функционалност",
        "background": u"Предистория",
        "scenario": u"Рамка на сценарий|Сценарий",
        "examples": u"Примери",
        "given": u"Дадено",
        "when": u"Когато",
        "then": u"То",
        "and": u"И",
        "but": u"Но"
    },
    "ca": {
        "name": u"Catalan",
        "native": u"català",
        "background": u"Rerefons|Antecedents",
        "feature": u"Característica|Funcionalitat",
        "scenario": u"Esquema de l'escenari|Escenari",
        "examples": u"Exemples",
        "given": u"Donat|Donada|Atès|Atesa",
        "when": u"Quan",
        "then": u"Aleshores|Cal",
        "and": u"I",
        "but": u"Però"
    },
    "cy-GB": {
        "name": u"Welsh",
        "native": u"Cymraeg",
        "background": u"Cefndir",
        "feature": u"Arwedd",
        "scenario": u"Scenario Amlinellol|Scenario",
        "examples": u"Enghreifftiau",
        "given": u"Anrhegedig a",
        "when": u"Pryd",
        "then": u"Yna",
        "and": u"A",
        "but": u"Ond"
    },
    "cs": {
        "name": u"Czech",
        "native": u"Česky",
        "feature": u"Požadavek",
        "background": u"Pozadí|Kontext",
        "scenario": u"Náčrt Scénáře|Osnova scénáře|Scénář",
        "examples": u"Příklady",
        "given": u"Pokud|Za předpokladu",
        "when": u"Když",
        "then": u"Pak",
        "and": u"A také|A",
        "but": u"Ale"
    },
    "da": {
        "name": u"Danish",
        "native": u"dansk",
        "feature": u"Egenskab",
        "background": u"Baggrund",
        "scenario": u"Abstrakt Scenario|Scenarie",
        "examples": u"Eksempler",
        "given": u"Givet",
        "when": u"Når",
        "then": u"Så",
        "and": u"Og",
        "but": u"Men"
    },
    "de": {
        "name": u"German",
        "native": u"Deutsch",
        "feature": u"Funktionalität",
        "background": u"Grundlage",
        "scenario": u"Szenariogrundriss|Szenario",
        "examples": u"Beispiele",
        "given": u"Angenommen|Gegeben sei|Gegeben seien",
        "when": u"Wenn",
        "then": u"Dann",
        "and": u"Und",
        "but": u"Aber"
    },
    "el": {
        "name": u"Greek",
        "native": u"Ελληνικά",
        "feature": u"Δυνατότητα|Λειτουργία",
        "background": u"Υπόβαθρο",
        "scenario": u"Περιγραφή Σεναρίου|Σενάριο",
        "examples": u"Παραδείγματα|Σενάρια",
        "given": u"Δεδομένου",
        "when": u"Όταν",
        "then": u"Τότε",
        "and": u"Και",
        "but": u"Αλλά"
    },
    "en-au": {
        "name": u"Australian",
        "native": u"Australian",
        "feature": u"Pretty much",
        "background": u"First off",
        "scenario": u"Reckon it's like|Awww, look mate",
        "examples": u"You'll wanna",
        "given": u"Y'know",
        "when": u"It's just unbelievable",
        "then": u"But at the end of the day I reckon",
        "and": u"Too right",
        "but": u"Yeah nah"
    },
    "en-Scouse": {
        "name": u"Scouse",
        "native": u"Scouse",
        "feature": u"Feature",
        "background": u"Dis is what went down",
        "scenario": u"Wharrimean is|The thing of it is",
        "examples": u"Examples",
        "given": u"Givun|Youse know when youse got",
        "when": u"Wun|Youse know like when",
        "then": u"Dun|Den youse gotta",
        "and": u"An",
        "but": u"Buh"
    },
    "en-tx": {
        "name": u"Texan",
        "native": u"Texan",
        "feature": u"Feature",
        "background": u"Background",
        "scenario": u"All y'all|Scenario",
        "examples": u"Examples",
        "given": u"Given y'all",
        "when": u"When y'all",
        "then": u"Then y'all",
        "and": u"And y'all",
        "but": u"But y'all"
    },
    "eo": {
        "name": u"Esperanto",
        "native": u"Esperanto",
        "feature": u"Trajto",
        "background": u"Fono",
        "scenario": u"Konturo de la scenaro|Scenaro",
        "examples": u"Ekzemploj",
        "given": u"Donitaĵo",
        "when": u"Se",
        "then": u"Do",
        "and": u"Kaj",
        "but": u"Sed"
    },
    "es": {
        "name": u"Spanish",
        "native": u"español",
        "background": u"Antecedentes",
        "feature": u"Característica",
        "scenario": u"Esquema del escenario|Escenario",
        "examples": u"Ejemplos",
        "given": u"Dado|Dada|Dados|Dadas",
        "when": u"Cuando",
        "then": u"Entonces",
        "and": u"Y",
        "but": u"Pero"
    },
    "et": {
        "name": u"Estonian",
        "native": u"eesti keel",
        "feature": u"Omadus",
        "background": u"Taust",
        "scenario": u"Raamstsenaarium|Stsenaarium",
        "examples": u"Juhtumid",
        "given": u"Eeldades",
        "when": u"Kui",
        "then": u"Siis",
        "and": u"Ja",
        "but": u"Kuid"
    },
    "fa": {
        "name": u"Persian",
        "native": u"فارسی",
        "feature": u"وِیژگی",
        "background": u"زمینه",
        "scenario": u"الگوی سناریو|سناریو",
        "examples": u"نمونه ها",
        "given": u"با فرض",
        "when": u"هنگامی",
        "then": u"آنگاه",
        "and": u"و",
        "but": u"اما"
    },
    "fi": {
        "name": u"Finnish",
        "native": u"suomi",
        "feature": u"Ominaisuus",
        "background": u"Tausta",
        "scenario": u"Tapausaihio|Tapaus",
        "examples": u"Tapaukset",
        "given": u"Oletetaan",
        "when": u"Kun",
        "then": u"Niin",
        "and": u"Ja",
        "but": u"Mutta"
    },
    "fr": {
        "name": u"French",
        "native": u"français",
        "feature": u"Fonctionnalité",
        "background": u"Contexte",
        "scenario": u"Plan du scénario|Plan du Scénario|Scénario",
        "examples": u"Exemples",
        "given": u"Soit|Etant donné|Etant donnée|Etant donnés|Etant données|Étant donné|Étant donnée|Étant donnés|Étant données",
        "when": u"Quand|Lorsque|Lorsqu'<",
        "then": u"Alors",
        "and": u"Et",
        "but": u"Mais"
    },
    "gl": {
        "name": u"Galician",
        "native": u"galego",
        "background": u"Contexto",
        "feature": u"Característica",
        "scenario": u"Esbozo do escenario|Escenario",
        "examples": u"Exemplos",
        "given": u"Dado|Dada|Dados|Dadas",
        "when": u"Cando",
        "then": u"Entón|Logo",
        "and": u"E",
        "but": u"Mais|Pero"
    },
    "he": {
        "name": u"Hebrew",
        "native": u"עברית",
        "feature": u"תכונה",
        "background": u"רקע",
        "scenario": u"תבנית תרחיש|תרחיש",
        "examples": u"דוגמאות",
        "given": u"בהינתן",
        "when": u"כאשר",
        "then": u"אז|אזי",
        "and": u"וגם",
        "but": u"אבל"
    },
    "hi": {
        "name": u"Hindi",
        "native": u"हिंदी",
        "feature": u"रूप लेख",
        "background": u"पृष्ठभूमि",
        "scenario": u"परिदृश्य रूपरेखा|परिदृश्य",
        "examples": u"उदाहरण",
        "given": u"अगर|यदि|चूंकि",
        "when": u"जब|कदा",
        "then": u"तब|तदा",
        "and": u"और|तथा",
        "but": u"पर|परन्तु|किन्तु"
    },
    "hr": {
        "name": u"Croatian",
        "native": u"hrvatski",
        "feature": u"Osobina|Mogućnost|Mogucnost",
        "background": u"Pozadina",
        "scenario": u"Skica|Koncept|Scenarij",
        "examples": u"Primjeri|Scenariji",
        "given": u"Zadan|Zadani|Zadano",
        "when": u"Kada|Kad",
        "then": u"Onda",
        "and": u"I",
        "but": u"Ali"
    },
    "ht": {
        "name": u"Creole",
        "native": u"kreyòl",
        "feature": u"Karakteristik|Mak|Fonksyonalite",
        "background": u"Kontèks|Istorik",
        "scenario": u"Plan senaryo|Plan Senaryo|Senaryo deskripsyon|Senaryo Deskripsyon|Dyagram senaryo|Dyagram Senaryo|Senaryo",
        "examples": u"Egzanp",
        "given": u"Sipoze|Sipoze ke|Sipoze Ke",
        "when": u"Lè|Le",
        "then": u"Lè sa a|Le sa a",
        "and": u"Ak|Epi|E",
        "but": u"Men"
    },
    "hu": {
        "name": u"Hungarian",
        "native": u"magyar",
        "feature": u"Jellemző",
        "background": u"Háttér",
        "scenario": u"Forgatókönyv vázlat|Forgatókönyv",
        "examples": u"Példák",
        "given": u"Amennyiben|Adott",
        "when": u"Majd|Ha|Amikor",
        "then": u"Akkor",
        "and": u"És",
        "but": u"De"
    },
    "id": {
        "name": u"Indonesian",
        "native": u"Bahasa Indonesia",
        "feature": u"Fitur",
        "background": u"Dasar",
        "scenario": u"Skenario konsep|Skenario",
        "examples": u"Contoh",
        "given": u"Dengan",
        "when": u"Ketika",
        "then": u"Maka",
        "and": u"Dan",
        "but": u"Tapi"
    },
    "is": {
        "name": u"Icelandic",
        "native": u"Íslenska",
        "feature": u"Eiginleiki",
        "background": u"Bakgrunnur",
        "scenario": u"Lýsing Atburðarásar|Lýsing Dæma|Atburðarás",
        "examples": u"Dæmi|Atburðarásir",
        "given": u"Ef",
        "when": u"Þegar",
        "then": u"Þá",
        "and": u"Og",
        "but": u"En"
    },
    "it": {
        "name": u"Italian",
        "native": u"italiano",
        "feature": u"Funzionalità",
        "background": u"Contesto",
        "scenario": u"Schema dello scenario|Scenario",
        "examples": u"Esempi",
        "given": u"Dato|Data|Dati|Date",
        "when": u"Quando",
        "then": u"Allora",
        "and": u"E",
        "but": u"Ma"
    },
    "ja": {
        "name": u"Japanese",
        "native": u"日本語",
        "feature": u"フィーチャ|機能",
        "background": u"背景",
        "scenario": u"シナリオアウトライン|シナリオテンプレート|テンプレ|シナリオテンプレ|シナリオ",
        "examples": u"例|サンプル",
        "given": u"前提<",
        "when": u"もし<",
        "then": u"ならば<",
        "and": u"かつ<",
        "but": u"しかし<|但し<|ただし<"
    },
    "jv": {
        "name": u"Javanese",
        "native": u"Basa Jawa",
        "feature": u"Fitur",
        "background": u"Dasar",
        "scenario": u"Konsep skenario|Skenario",
        "examples": u"Conto|Contone",
        "given": u"Nalika|Nalikaning",
        "when": u"Manawa|Menawa",
        "then": u"Njuk|Banjur",
        "and": u"Lan",
        "but": u"Tapi|Nanging|Ananging"
    },
    "kn": {
        "name": u"Kannada",
        "native": u"ಕನ್ನಡ",
        "background": u"ಹಿನ್ನೆಲೆ",
        "feature": u"ಹೆಚ್ಚಳ",
        "scenario": u"ವಿವರಣೆ|ಕಥಾಸಾರಾಂಶ",
        "examples": u"ಉದಾಹರಣೆಗಳು",
        "given": u"ನೀಡಿದ",
        "when": u"ಸ್ಥಿತಿಯನ್ನು",
        "then": u"ನಂತರ",
        "and": u"ಮತ್ತು",
        "but": u"ಆದರೆ"
    },
    "ko": {
        "name": u"Korean",
        "native": u"한국어",
        "background": u"배경",
        "feature": u"기능",
        "scenario": u"시나리오 개요|시나리오",
        "examples": u"예",
        "given": u"조건<|먼저<",
        "when": u"만일<|만약<",
        "then": u"그러면<",
        "and": u"그리고<",
        "but": u"하지만<|단<"
    },
    "lt": {
        "name": u"Lithuanian",
        "native": u"lietuvių kalba",
        "feature": u"Savybė",
        "background": u"Kontekstas",
        "scenario": u"Scenarijaus šablonas|Scenarijus",
        "examples": u"Pavyzdžiai|Scenarijai|Variantai",
        "given": u"Duota",
        "when": u"Kai",
        "then": u"Tada",
        "and": u"Ir",
        "but": u"Bet"
    },
    "lu": {
        "name": u"Luxemburgish",
        "native": u"Lëtzebuergesch",
        "feature": u"Funktionalitéit",
        "background": u"Hannergrond",
        "scenario": u"Plang vum Szenario|Szenario",
        "examples": u"Beispiller",
        "given": u"ugeholl",
        "when": u"wann",
        "then": u"dann",
        "and": u"an|a",
        "but": u"awer|mä"
    },
    "lv": {
        "name": u"Latvian",
        "native": u"latviešu",
        "feature": u"Funkcionalitāte|Fīča",
        "background": u"Konteksts|Situācija",
        "scenario": u"Scenārijs pēc parauga|Scenārijs",
        "examples": u"Piemēri|Paraugs",
        "given": u"Kad",
        "when": u"Ja",
        "then": u"Tad",
        "and": u"Un",
        "but": u"Bet"
    },
    "nl": {
        "name": u"Dutch",
        "native": u"Nederlands",
        "feature": u"Functionaliteit",
        "background": u"Achtergrond",
        "scenario": u"Abstract Scenario|Scenario",
        "examples": u"Voorbeelden",
        "given": u"Gegeven|Stel",
        "when": u"Als",
        "then": u"Dan",
        "and": u"En",
        "but": u"Maar"
    },
    "no": {
        "name": u"Norwegian",
        "native": u"norsk",
        "feature": u"Egenskap",
        "background": u"Bakgrunn",
        "scenario": u"Scenariomal|Abstrakt Scenario|Scenario",
        "examples": u"Eksempler",
        "given": u"Gitt",
        "when": u"Når",
        "then": u"Så",
        "and": u"Og",
        "but": u"Men"
    },
    "pa": {
        "name": u"Panjabi",
        "native": u"ਪੰਜਾਬੀ",
        "feature": u"ਖਾਸੀਅਤ|ਮੁਹਾਂਦਰਾ|ਨਕਸ਼ ਨੁਹਾਰ",
        "background": u"ਪਿਛੋਕੜ",
        "scenario": u"ਪਟਕਥਾ ਢਾਂਚਾ|ਪਟਕਥਾ ਰੂਪ ਰੇਖਾ|ਪਟਕਥਾ",
        "examples": u"ਉਦਾਹਰਨਾਂ",
        "given": u"ਜੇਕਰ|ਜਿਵੇਂ ਕਿ",
        "when": u"ਜਦੋਂ",
        "then": u"ਤਦ",
        "and": u"ਅਤੇ",
        "but": u"ਪਰ"
    },
    "pl": {
        "name": u"Polish",
        "native": u"polski",
        "feature": u"Właściwość|Funkcja|Aspekt|Potrzeba biznesowa",
        "background": u"Założenia",
        "scenario": u"Szablon scenariusza|Scenariusz",
        "examples": u"Przykłady",
        "given": u"Zakładając(?:,? że)?|Mając",
        "when": u"Jeżeli|Jeśli|Gdy|Kiedy",
        "then": u"Wtedy",
        "and": u"Oraz|I",
        "but": u"Ale"
    },
    "pt": {
        "name": u"Portuguese",
        "native": u"português",
        "background": u"Contexto|Cenário de Fundo|Cenario de Fundo|Fundo",
        "feature": u"Funcionalidade|Característica|Caracteristica",
        "scenario": u"Esquema do Cenário|Esquema do Cenario|Delineação do Cenário|Delineacao do Cenario|Cenário|Cenario",
        "examples": u"Exemplos|Cenários|Cenarios",
        "given": u"Dado|Dada|Dados|Dadas",
        "when": u"Quando",
        "then": u"Então|Entao",
        "and": u"E",
        "but": u"Mas"
    },
    "ro": {
        "name": u"Romanian",
        "native": u"română",
        "background": u"Context",
        "feature": u"Functionalitate|Funcționalitate|Funcţionalitate",
        "scenario": u"Structura scenariu|Structură scenariu|Scenariu",
        "examples": u"Exemple",
        "given": u"Date fiind|Dat fiind|Dati fiind|Dați fiind|Daţi fiind",
        "when": u"Cand|Când",
        "then": u"Atunci",
        "and": u"Si|Și|Şi",
        "but": u"Dar"
    },
    "ru": {
        "name": u"Russian",
        "native": u"русский",
        "feature": u"Функция|Функционал|Свойство",
        "background": u"Предыстория|Контекст",
        "scenario": u"Структура сценария|Сценарий",
        "examples": u"Примеры",
        "given": u"Допустим|Дано|Пусть",
        "when": u"Если|Когда",
        "then": u"То|Тогда",
        "and": u"И|К тому же|Также",
        "but": u"Но|А"
    },
    "sv": {
        "name": u"Swedish",
        "native": u"Svenska",
        "feature": u"Egenskap",
        "background": u"Bakgrund",
        "scenario": u"Abstrakt Scenario|Scenariomall|Scenario",
        "examples": u"Exempel",
        "given": u"Givet",
        "when": u"När",
        "then": u"Så",
        "and": u"Och",
        "but": u"Men"
    },
    "sk": {
        "name": u"Slovak",
        "native": u"Slovensky",
        "feature": u"Požiadavka|Funkcia|Vlastnosť",
        "background": u"Pozadie",
        "scenario": u"Náčrt Scenáru|Náčrt Scenára|Osnova Scenára|Scenár",
        "examples": u"Príklady",
        "given": u"Pokiaľ|Za predpokladu",
        "when": u"Keď|Ak",
        "then": u"Tak|Potom",
        "and": u"A|A tiež|A taktiež|A zároveň",
        "but": u"Ale"
    },
    "sl": {
        "name": u"Slovenian",
        "native": u"Slovenski",
        "feature": u"Funkcionalnost|Funkcija|Možnosti|Moznosti|Lastnost|Značilnost",
        "background": u"Kontekst|Osnova|Ozadje",
        "scenario": u"Struktura scenarija|Skica|Koncept|Oris scenarija|Osnutek|Scenarij|Primer",
        "examples": u"Primeri|Scenariji",
        "given": u"Dano|Podano|Zaradi|Privzeto",
        "when": u"Ko|Ce|Če|Kadar",
        "then": u"Nato|Potem|Takrat",
        "and": u"In|Ter",
        "but": u"Toda|Ampak|Vendar"
    },
    "sr-Latn": {
        "name": u"Serbian (Latin)",
        "native": u"Srpski (Latinica)",
        "feature": u"Funkcionalnost|Mogućnost|Mogucnost|Osobina",
        "background": u"Kontekst|Osnova|Pozadina",
        "scenario": u"Struktura scenarija|Skica|Koncept|Scenario|Primer",
        "examples": u"Primeri|Scenariji",
        "given": u"Zadato|Zadate|Zatati",
        "when": u"Kada|Kad",
        "then": u"Onda",
        "and": u"I",
        "but": u"Ali"
    },
    "sr-Cyrl": {
        "name": u"Serbian",
        "native": u"Српски",
        "feature": u"Функционалност|Могућност|Особина",
        "background": u"Контекст|Основа|Позадина",
        "scenario": u"Структура сценарија|Скица|Концепт|Сценарио|Пример",
        "examples": u"Примери|Сценарији",
        "given": u"Задато|Задате|Задати",
        "when": u"Када|Кад",
        "then": u"Онда",
        "and": u"И",
        "but": u"Али"
    },
    "tl": {
        "name": u"Telugu",
        "native": u"తెలుగు",
        "feature": u"గుణము",
        "background": u"నేపథ్యం",
        "scenario": u"కథనం|సన్నివేశం",
        "examples": u"ఉదాహరణలు",
        "given": u"చెప్పబడినది",
        "when": u"ఈ పరిస్థితిలో",
        "then": u"అప్పుడు",
        "and": u"మరియు",
        "but": u"కాని"
    },
    "th": {
        "name": u"Thai",
        "native": u"ไทย",
        "feature": u"โครงหลัก|ความต้องการทางธุรกิจ|ความสามารถ",
        "background": u"แนวคิด",
        "scenario": u"สรุปเหตุการณ์|โครงสร้างของเหตุการณ์|เหตุการณ์",
        "examples": u"ชุดของตัวอย่าง|ชุดของเหตุการณ์",
        "given": u"กำหนดให้",
        "when": u"เมื่อ",
        "then": u"ดังนั้น",
        "and": u"และ",
        "but": u"แต่"
    },
    "tlh": {
        "name": u"Klingon",
        "native": u"tlhIngan",
        "feature": u"Qap|Qu'meH 'ut|perbogh|poQbogh malja'|laH",
        "background": u"mo'",
        "scenario": u"lut chovnatlh|lut",
        "examples": u"ghantoH|lutmey",
        "given": u"ghu' noblu'|DaH ghu' bejlu'",
        "when": u"qaSDI'",
        "then": u"vaj",
        "and": u"'ej|latlh",
        "but": u"'ach|'a"
    },
    "tr": {
        "name": u"Turkish",
        "native": u"Türkçe",
        "feature": u"Özellik",
        "background": u"Geçmiş",
        "scenario": u"Senaryo taslağı|Senaryo",
        "examples": u"Örnekler",
        "given": u"Diyelim ki",
        "when": u"Eğer ki",
        "then": u"O zaman",
        "and": u"Ve",
        "but": u"Fakat|Ama"
    },
    "tt": {
        "name": u"Tatar",
        "native": u"Татарча",
        "feature": u"Мөмкинлек|Үзенчәлеклелек",
        "background": u"Кереш",
        "scenario": u"Сценарийның төзелеше|Сценарий",
        "examples": u"Үрнәкләр|Мисаллар",
        "given": u"Әйтик",
        "when": u"Әгәр",
        "then": u"Нәтиҗәдә",
        "and": u"Һәм|Вә",
        "but": u"Ләкин|Әмма"
    },
    "uk": {
        "name": u"Ukrainian",
        "native": u"Українська",
        "feature": u"Функціонал",
        "background": u"Передумова",
        "scenario": u"Структура сценарію|Сценарій",
        "examples": u"Приклади",
        "given": u"Припустимо|Припустимо, що|Нехай|Дано",
        "when": u"Якщо|Коли",
        "then": u"То|Тоді",
        "and": u"І|А також|Та",
        "but": u"Але"
    },
    "uz": {
        "name": u"Uzbek",
        "native": u"Узбекча",
        "feature": u"Функционал",
        "background": u"Тарих",
        "scenario": u"Сценарий структураси|Сценарий",
        "examples": u"Мисоллар",
        "given": u"Агар",
        "when": u"Агар",
        "then": u"Унда",
        "and": u"Ва",
        "but": u"Лекин|Бирок|Аммо"
    },
    "vi": {
        "name": u"Vietnamese",
        "native": u"Tiếng Việt",
        "feature": u"Tính năng",
        "background": u"Bối cảnh",
        "scenario": u"Khung tình huống|Khung kịch bản|Tình huống|Kịch bản",
        "examples": u"Dữ liệu",
        "given": u"Biết|Cho",
        "when": u"Khi",
        "then": u"Thì",
        "and": u"Và",
        "but": u"Nhưng"
    },
    "zh-CN": {
        "name": u"Chinese simplified",
        "native": u"简体中文",
        "feature": u"功能",
        "background": u"背景",
        "scenario": u"场景大纲|剧本大纲|场景|剧本",
        "examples": u"例子",
        "given": u"假如<|假设<|假定<",
        "when": u"当<",
        "then": u"那么<",
        "and": u"而且<|并且<|同时<",
        "but": u"但是<"
    },
    "zh-TW": {
        "name": u"Chinese traditional",
        "native": u"繁體中文",
        "feature": u"功能",
        "background": u"背景",
        "scenario": u"場景大綱|劇本大綱|場景|劇本",
        "examples": u"例子",
        "given": u"假如<|假設<|假定<",
        "when": u"當<",
        "then": u"那麼<",
        "and": u"而且<|並且<|同時<",
        "but": u"但是<"
    },
    "ur": {
        "name": u"Urdu",
        "native": u"اردو",
        "feature": u"صلاحیت|کاروبار کی ضرورت|خصوصیت",
        "background": u"پس منظر",
        "scenario": u"منظر نامے کا خاکہ|منظرنامہ",
        "examples": u"مثالیں",
        "given": u"اگر|بالفرض|فرض کیا",
        "when": u"جب",
        "then": u"پھر|تب",
        "and": u"اور",
        "but": u"لیکن"
    }
}
