"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceService = exports.ManagedLoggingPolicy = exports.ec2ImageToOsString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cdk_aspects_library_security_group_1 = require("@renovosolutions/cdk-aspects-library-security-group");
const cdk_library_managed_instance_role_1 = require("@renovosolutions/cdk-library-managed-instance-role");
function ec2ImageToOsString(stack, image) {
    return ec2.OperatingSystemType[image.getImage(stack).osType].toLowerCase();
}
exports.ec2ImageToOsString = ec2ImageToOsString;
class ManagedLoggingPolicy extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!(props.os.toLowerCase() == 'windows') && !(props.os.toLowerCase() == 'linux')) {
            throw new Error(`The os property for ManagedLoggingPolicy must be windows or linux and you gave: ${props.os.toLowerCase()}`);
        }
        let logResources = [];
        const logGroups = [
            `/${props.os}/logs`,
            `/${props.os}/logs/*`,
        ];
        logGroups.forEach((g) => {
            logResources.push(`arn:aws:logs:${cdk.Stack.of(this).region}:${cdk.Stack.of(this).account}:log-group:${g}`);
        });
        this.policy = new iam.ManagedPolicy(this, 'loggingPolicy', {
            description: 'Allow instance to log system logs to Cloudwatch',
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'logs:PutLogEvents',
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                    ],
                    resources: logResources,
                }),
            ],
        });
    }
}
exports.ManagedLoggingPolicy = ManagedLoggingPolicy;
_a = JSII_RTTI_SYMBOL_1;
ManagedLoggingPolicy[_a] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.ManagedLoggingPolicy", version: "1.0.115" };
class InstanceService extends cdk.Construct {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        let enableNoRemoteManagementPortsAspect = (_c = props.enableNoRemoteManagementPortsAspect) !== null && _c !== void 0 ? _c : true;
        let enableNoDBPortsAspect = (_d = props.enableNoDBPortsAspect) !== null && _d !== void 0 ? _d : true;
        let enabledNoPublicIngressAspect = (_e = props.enabledNoPublicIngressAspect) !== null && _e !== void 0 ? _e : true;
        if (enableNoRemoteManagementPortsAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonManagementPortsAspect());
        if (enableNoDBPortsAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonRelationalDBPortsAspect());
        if (enabledNoPublicIngressAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoPublicIngressAspect());
        let managedPolicies = [];
        // Logging configuration
        let enableCloudwatchLogs = (props.enableCloudwatchLogs === undefined) ? true : props.enableCloudwatchLogs;
        if (enableCloudwatchLogs) {
            managedPolicies.push(new ManagedLoggingPolicy(this, 'loggingPolicy', {
                os: ec2ImageToOsString(this, props.ami),
            }).policy);
        }
        this.instanceProfile = new cdk_library_managed_instance_role_1.ManagedInstanceRole(this, 'instanceRole', {
            domainJoinEnabled: false,
            ssmManagementEnabled: true,
            managedPolicies,
        });
        let allowAllOutbound = (props.allowAllOutbound === undefined) ? true : props.allowAllOutbound;
        let disableInlineRules = (props.disableInlineRules === undefined) ? false : props.disableInlineRules;
        this.securityGroup = new ec2.SecurityGroup(this, 'securityGroup', {
            allowAllOutbound: allowAllOutbound,
            vpc: props.vpc,
            description: `The security group applied to the instance service for ${props.name}`,
            disableInlineRules: disableInlineRules,
        });
    }
}
exports.InstanceService = InstanceService;
_b = JSII_RTTI_SYMBOL_1;
InstanceService[_b] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.InstanceService", version: "1.0.115" };
//# sourceMappingURL=data:application/json;base64,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