from abc import ABC, abstractmethod
from typing import Any, Dict


class BaseFormatter(ABC):
    """
    PostgresWalSource'un ürettiği normalized event'i
    publish edilecek event'e çevirmek için base sınıf.
    """

    @abstractmethod
    def format(self, event: Dict[str, Any]) -> Dict[str, Any]:
        """
        :param event: normalized event:
            {
                "op": "insert" | "update" | "delete",
                "schema": "public",
                "table": "users",
                "after": { ... } | None,
                "before": { ... } | None,
                "meta": { "xid": ..., "timestamp": ... }
            }
        :return: publish edilecek event dict'i
        """
        raise NotImplementedError
