from typing import Any, Dict

from .base import BaseFormatter


class DebeziumLikeFormatter(BaseFormatter):
    """
    Converts normalized event to a Debezium-like format.
    Not exactly Debezium compatible, but contains similar fields.
    """

    OP_MAP = {
        "insert": "c",  # create
        "update": "u",
        "delete": "d",
    }

    def format(self, event: Dict[str, Any]) -> Dict[str, Any]:
        op_text = event.get("op")
        op = self.OP_MAP.get(op_text, None)
        after = event.get("after")
        before = event.get("before")
        meta = event.get("meta") or {}

        return {
            "op": op,
            "ts_ms": meta.get("timestamp"),
            "source": {
                "schema": event.get("schema"),
                "table": event.get("table"),
                "xid": meta.get("xid"),
            },
            "before": before,
            "after": after,
        }
