from typing import Any, Dict

from .base import BaseFormatter


class SimpleFormatter(BaseFormatter):
    """
    Normalized event'i çok yakın formatta publish eder.
    """

    def format(self, event: Dict[str, Any]) -> Dict[str, Any]:
        # Direkt paslayabiliriz, istersen burada minimal transform da yapabilirsin.
        return {
            "op": event.get("op"),
            "schema": event.get("schema"),
            "table": event.get("table"),
            "before": event.get("before"),
            "after": event.get("after"),
            "meta": event.get("meta"),
        }
