import pytest
from unittest.mock import MagicMock, patch
from dbqueue.transports import RabbitMQTransport

def test_transport_connect(mock_rabbit_channel):
    with patch("pika.BlockingConnection") as mock_conn:
        mock_conn.return_value.channel.return_value = mock_rabbit_channel
        
        transport = RabbitMQTransport(url="amqp://localhost")
        
        mock_conn.assert_called_once()
        mock_rabbit_channel.exchange_declare.assert_called_with(
            exchange="dbqueue.events",
            exchange_type="topic",
            durable=True
        )

def test_transport_publish(mock_rabbit_channel):
    with patch("pika.BlockingConnection") as mock_conn:
        mock_conn.return_value.channel.return_value = mock_rabbit_channel
        
        transport = RabbitMQTransport(url="amqp://localhost")
        
        event = {
            "schema": "public",
            "table": "users",
            "op": "INSERT",
            "data": {"id": 1}
        }
        
        transport.publish(event)
        
        mock_rabbit_channel.basic_publish.assert_called_once()
        call_args = mock_rabbit_channel.basic_publish.call_args
        assert call_args.kwargs["exchange"] == "dbqueue.events"
        assert call_args.kwargs["routing_key"] == "public.users.INSERT"
