#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: EPL-1.0
# SPDX-FileCopyrightText: 2025 The Linux Foundation
#
# Linux Foundation Release Engineering Tools documentation build configuration file, created by
# sphinx-quickstart on Sat Mar  4 12:20:05 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

sys.path.insert(0, os.path.abspath(".."))

# Basic Sphinx configuration for lftools-uv
project = 'lftools-uv'
copyright = '2025, Linux Foundation Release Engineering'
author = 'Linux Foundation Release Engineering'

# Version information
try:
    from importlib.metadata import version as get_version
    version = get_version("lftools-uv")
    release = version
except Exception:
    version = '0.1.0'
    release = '0.1.0'

# Sphinx extensions
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.viewcode',
    'sphinxcontrib.programoutput',
]

# Theme configuration
html_theme = 'furo'

# Master document
master_doc = 'index'

# Source file suffixes
source_suffix = '.rst'

# Language for content autogenerated by Sphinx
language = 'en'

# Exclude patterns
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# Pygments style
pygments_style = 'sphinx'

# HTML theme options
html_theme_options = {
    "source_repository": "https://github.com/lfit/lftools-uv/",
    "source_branch": "main",
    "source_directory": "docs/",
    "sidebar_hide_name": False,
    "navigation_with_keys": True,
}

# Static files path
html_static_path = ['_static']

# HTML title
html_title = f"{project} {version} documentation"

# Intersphinx mappings
intersphinx_mapping = {
    'python': ('https://docs.python.org/3', None),
}

# Linkcheck Options
linkcheck_ignore = [
    r"https://testing\.googleblog\.com/.*",
    r"https://nexus\.example\.com",
]
