# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 parent: pulumi.Input[_builtins.str],
                 adaptive: Optional[pulumi.Input[_builtins.str]] = None,
                 adaptive_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 base: Optional[pulumi.Input[_builtins.str]] = None,
                 chase_referrals: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parent: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 mandatory_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 receive: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_disable: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 time_until_up: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 transparent: Optional[pulumi.Input[_builtins.str]] = None,
                 up_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        :param pulumi.Input[_builtins.str] parent: Parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] adaptive: Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        :param pulumi.Input[_builtins.int] adaptive_limit: Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        :param pulumi.Input[_builtins.str] base: Specifies the location in the LDAP tree from which the monitor starts the health check
        :param pulumi.Input[_builtins.str] chase_referrals: Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        :param pulumi.Input[_builtins.str] compatibility: Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        :param pulumi.Input[_builtins.str] custom_parent: Custom parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] database: Specifies the database in which the user is created
        :param pulumi.Input[_builtins.str] destination: Specify an alias address for monitoring
        :param pulumi.Input[_builtins.str] domain: Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        :param pulumi.Input[_builtins.str] filename: Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        :param pulumi.Input[_builtins.str] filter: Specifies an LDAP key for which the monitor searches
        :param pulumi.Input[_builtins.int] interval: Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        :param pulumi.Input[_builtins.int] ip_dscp: Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        :param pulumi.Input[_builtins.str] mandatory_attributes: Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        :param pulumi.Input[_builtins.str] manual_resume: Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        :param pulumi.Input[_builtins.str] mode: Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        :param pulumi.Input[_builtins.str] password: Specifies the password if the monitored target requires authentication
        :param pulumi.Input[_builtins.str] receive: Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        :param pulumi.Input[_builtins.str] receive_disable: The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        :param pulumi.Input[_builtins.str] reverse: Instructs the system to mark the target resource down when the test is successful.
        :param pulumi.Input[_builtins.str] security: Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        :param pulumi.Input[_builtins.str] send: Specifies the text string that the monitor sends to the target object.
        :param pulumi.Input[_builtins.str] ssl_profile: Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        :param pulumi.Input[_builtins.int] time_until_up: Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        :param pulumi.Input[_builtins.int] timeout: Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        :param pulumi.Input[_builtins.str] transparent: Specifies whether the monitor operates in transparent mode.
        :param pulumi.Input[_builtins.int] up_interval: Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        :param pulumi.Input[_builtins.str] username: Specifies the user name if the monitored target requires authentication
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent", parent)
        if adaptive is not None:
            pulumi.set(__self__, "adaptive", adaptive)
        if adaptive_limit is not None:
            pulumi.set(__self__, "adaptive_limit", adaptive_limit)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chase_referrals is not None:
            pulumi.set(__self__, "chase_referrals", chase_referrals)
        if compatibility is not None:
            pulumi.set(__self__, "compatibility", compatibility)
        if custom_parent is not None:
            pulumi.set(__self__, "custom_parent", custom_parent)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if ip_dscp is not None:
            pulumi.set(__self__, "ip_dscp", ip_dscp)
        if mandatory_attributes is not None:
            pulumi.set(__self__, "mandatory_attributes", mandatory_attributes)
        if manual_resume is not None:
            pulumi.set(__self__, "manual_resume", manual_resume)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if receive is not None:
            pulumi.set(__self__, "receive", receive)
        if receive_disable is not None:
            pulumi.set(__self__, "receive_disable", receive_disable)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if send is not None:
            pulumi.set(__self__, "send", send)
        if ssl_profile is not None:
            pulumi.set(__self__, "ssl_profile", ssl_profile)
        if time_until_up is not None:
            pulumi.set(__self__, "time_until_up", time_until_up)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if transparent is not None:
            pulumi.set(__self__, "transparent", transparent)
        if up_interval is not None:
            pulumi.set(__self__, "up_interval", up_interval)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        Parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def adaptive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        """
        return pulumi.get(self, "adaptive")

    @adaptive.setter
    def adaptive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adaptive", value)

    @_builtins.property
    @pulumi.getter(name="adaptiveLimit")
    def adaptive_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        """
        return pulumi.get(self, "adaptive_limit")

    @adaptive_limit.setter
    def adaptive_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adaptive_limit", value)

    @_builtins.property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location in the LDAP tree from which the monitor starts the health check
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base", value)

    @_builtins.property
    @pulumi.getter(name="chaseReferrals")
    def chase_referrals(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        """
        return pulumi.get(self, "chase_referrals")

    @chase_referrals.setter
    def chase_referrals(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chase_referrals", value)

    @_builtins.property
    @pulumi.getter
    def compatibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        """
        return pulumi.get(self, "compatibility")

    @compatibility.setter
    def compatibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility", value)

    @_builtins.property
    @pulumi.getter(name="customParent")
    def custom_parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "custom_parent")

    @custom_parent.setter
    def custom_parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_parent", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database in which the user is created
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify an alias address for monitoring
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an LDAP key for which the monitor searches
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="ipDscp")
    def ip_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        """
        return pulumi.get(self, "ip_dscp")

    @ip_dscp.setter
    def ip_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_dscp", value)

    @_builtins.property
    @pulumi.getter(name="mandatoryAttributes")
    def mandatory_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        """
        return pulumi.get(self, "mandatory_attributes")

    @mandatory_attributes.setter
    def mandatory_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mandatory_attributes", value)

    @_builtins.property
    @pulumi.getter(name="manualResume")
    def manual_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        """
        return pulumi.get(self, "manual_resume")

    @manual_resume.setter
    def manual_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_resume", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password if the monitored target requires authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def receive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        """
        return pulumi.get(self, "receive")

    @receive.setter
    def receive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receive", value)

    @_builtins.property
    @pulumi.getter(name="receiveDisable")
    def receive_disable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        """
        return pulumi.get(self, "receive_disable")

    @receive_disable.setter
    def receive_disable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receive_disable", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructs the system to mark the target resource down when the test is successful.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reverse", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the text string that the monitor sends to the target object.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "send", value)

    @_builtins.property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        """
        return pulumi.get(self, "ssl_profile")

    @ssl_profile.setter
    def ssl_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_profile", value)

    @_builtins.property
    @pulumi.getter(name="timeUntilUp")
    def time_until_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        """
        return pulumi.get(self, "time_until_up")

    @time_until_up.setter
    def time_until_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_until_up", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def transparent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the monitor operates in transparent mode.
        """
        return pulumi.get(self, "transparent")

    @transparent.setter
    def transparent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent", value)

    @_builtins.property
    @pulumi.getter(name="upInterval")
    def up_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        """
        return pulumi.get(self, "up_interval")

    @up_interval.setter
    def up_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "up_interval", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user name if the monitored target requires authentication
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 adaptive: Optional[pulumi.Input[_builtins.str]] = None,
                 adaptive_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 base: Optional[pulumi.Input[_builtins.str]] = None,
                 chase_referrals: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parent: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 mandatory_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 receive: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_disable: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 time_until_up: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 transparent: Optional[pulumi.Input[_builtins.str]] = None,
                 up_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[_builtins.str] adaptive: Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        :param pulumi.Input[_builtins.int] adaptive_limit: Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        :param pulumi.Input[_builtins.str] base: Specifies the location in the LDAP tree from which the monitor starts the health check
        :param pulumi.Input[_builtins.str] chase_referrals: Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        :param pulumi.Input[_builtins.str] compatibility: Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        :param pulumi.Input[_builtins.str] custom_parent: Custom parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] database: Specifies the database in which the user is created
        :param pulumi.Input[_builtins.str] destination: Specify an alias address for monitoring
        :param pulumi.Input[_builtins.str] domain: Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        :param pulumi.Input[_builtins.str] filename: Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        :param pulumi.Input[_builtins.str] filter: Specifies an LDAP key for which the monitor searches
        :param pulumi.Input[_builtins.int] interval: Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        :param pulumi.Input[_builtins.int] ip_dscp: Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        :param pulumi.Input[_builtins.str] mandatory_attributes: Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        :param pulumi.Input[_builtins.str] manual_resume: Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        :param pulumi.Input[_builtins.str] mode: Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        :param pulumi.Input[_builtins.str] parent: Parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] password: Specifies the password if the monitored target requires authentication
        :param pulumi.Input[_builtins.str] receive: Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        :param pulumi.Input[_builtins.str] receive_disable: The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        :param pulumi.Input[_builtins.str] reverse: Instructs the system to mark the target resource down when the test is successful.
        :param pulumi.Input[_builtins.str] security: Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        :param pulumi.Input[_builtins.str] send: Specifies the text string that the monitor sends to the target object.
        :param pulumi.Input[_builtins.str] ssl_profile: Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        :param pulumi.Input[_builtins.int] time_until_up: Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        :param pulumi.Input[_builtins.int] timeout: Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        :param pulumi.Input[_builtins.str] transparent: Specifies whether the monitor operates in transparent mode.
        :param pulumi.Input[_builtins.int] up_interval: Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        :param pulumi.Input[_builtins.str] username: Specifies the user name if the monitored target requires authentication
        """
        if adaptive is not None:
            pulumi.set(__self__, "adaptive", adaptive)
        if adaptive_limit is not None:
            pulumi.set(__self__, "adaptive_limit", adaptive_limit)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chase_referrals is not None:
            pulumi.set(__self__, "chase_referrals", chase_referrals)
        if compatibility is not None:
            pulumi.set(__self__, "compatibility", compatibility)
        if custom_parent is not None:
            pulumi.set(__self__, "custom_parent", custom_parent)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if ip_dscp is not None:
            pulumi.set(__self__, "ip_dscp", ip_dscp)
        if mandatory_attributes is not None:
            pulumi.set(__self__, "mandatory_attributes", mandatory_attributes)
        if manual_resume is not None:
            pulumi.set(__self__, "manual_resume", manual_resume)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if receive is not None:
            pulumi.set(__self__, "receive", receive)
        if receive_disable is not None:
            pulumi.set(__self__, "receive_disable", receive_disable)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if send is not None:
            pulumi.set(__self__, "send", send)
        if ssl_profile is not None:
            pulumi.set(__self__, "ssl_profile", ssl_profile)
        if time_until_up is not None:
            pulumi.set(__self__, "time_until_up", time_until_up)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if transparent is not None:
            pulumi.set(__self__, "transparent", transparent)
        if up_interval is not None:
            pulumi.set(__self__, "up_interval", up_interval)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def adaptive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        """
        return pulumi.get(self, "adaptive")

    @adaptive.setter
    def adaptive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adaptive", value)

    @_builtins.property
    @pulumi.getter(name="adaptiveLimit")
    def adaptive_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        """
        return pulumi.get(self, "adaptive_limit")

    @adaptive_limit.setter
    def adaptive_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adaptive_limit", value)

    @_builtins.property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location in the LDAP tree from which the monitor starts the health check
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base", value)

    @_builtins.property
    @pulumi.getter(name="chaseReferrals")
    def chase_referrals(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        """
        return pulumi.get(self, "chase_referrals")

    @chase_referrals.setter
    def chase_referrals(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chase_referrals", value)

    @_builtins.property
    @pulumi.getter
    def compatibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        """
        return pulumi.get(self, "compatibility")

    @compatibility.setter
    def compatibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility", value)

    @_builtins.property
    @pulumi.getter(name="customParent")
    def custom_parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "custom_parent")

    @custom_parent.setter
    def custom_parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_parent", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database in which the user is created
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify an alias address for monitoring
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an LDAP key for which the monitor searches
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="ipDscp")
    def ip_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        """
        return pulumi.get(self, "ip_dscp")

    @ip_dscp.setter
    def ip_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_dscp", value)

    @_builtins.property
    @pulumi.getter(name="mandatoryAttributes")
    def mandatory_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        """
        return pulumi.get(self, "mandatory_attributes")

    @mandatory_attributes.setter
    def mandatory_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mandatory_attributes", value)

    @_builtins.property
    @pulumi.getter(name="manualResume")
    def manual_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        """
        return pulumi.get(self, "manual_resume")

    @manual_resume.setter
    def manual_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_resume", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password if the monitored target requires authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def receive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        """
        return pulumi.get(self, "receive")

    @receive.setter
    def receive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receive", value)

    @_builtins.property
    @pulumi.getter(name="receiveDisable")
    def receive_disable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        """
        return pulumi.get(self, "receive_disable")

    @receive_disable.setter
    def receive_disable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receive_disable", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructs the system to mark the target resource down when the test is successful.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reverse", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the text string that the monitor sends to the target object.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "send", value)

    @_builtins.property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        """
        return pulumi.get(self, "ssl_profile")

    @ssl_profile.setter
    def ssl_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_profile", value)

    @_builtins.property
    @pulumi.getter(name="timeUntilUp")
    def time_until_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        """
        return pulumi.get(self, "time_until_up")

    @time_until_up.setter
    def time_until_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_until_up", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def transparent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the monitor operates in transparent mode.
        """
        return pulumi.get(self, "transparent")

    @transparent.setter
    def transparent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent", value)

    @_builtins.property
    @pulumi.getter(name="upInterval")
    def up_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        """
        return pulumi.get(self, "up_interval")

    @up_interval.setter
    def up_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "up_interval", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user name if the monitored target requires authentication
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("f5bigip:ltm/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive: Optional[pulumi.Input[_builtins.str]] = None,
                 adaptive_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 base: Optional[pulumi.Input[_builtins.str]] = None,
                 chase_referrals: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parent: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 mandatory_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 receive: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_disable: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 time_until_up: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 transparent: Optional[pulumi.Input[_builtins.str]] = None,
                 up_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.Monitor` Configures a custom monitor for use by health checks.

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-monitor`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        monitor = f5bigip.ltm.Monitor("monitor",
            name="/Common/terraform_monitor",
            parent="/Common/http",
            send="GET /some/path\\x0d\\n",
            timeout=999,
            interval=998,
            destination="1.2.3.4:1234")
        test_https_monitor = f5bigip.ltm.Monitor("test-https-monitor",
            name="/Common/terraform_monitor",
            parent="/Common/http",
            ssl_profile="/Common/serverssl",
            send="GET /some/path\\x0d\\n",
            interval=999,
            timeout=1000)
        test_ftp_monitor = f5bigip.ltm.Monitor("test-ftp-monitor",
            name="/Common/ftp-test",
            parent="/Common/ftp",
            interval=5,
            time_until_up=0,
            timeout=16,
            destination="*:8008",
            filename="somefile")
        test_postgresql_monitor = f5bigip.ltm.Monitor("test-postgresql-monitor",
            name="/Common/test-postgresql-monitor",
            parent="/Common/postgresql",
            send="SELECT 'Test';",
            receive="Test",
            interval=5,
            timeout=16,
            username="abcd",
            password="abcd1234")
        ```

        ## Importing

        An existing monitor can be imported into this resource by supplying monitor Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_monitor.monitor /Common/terraform_monitor
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adaptive: Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        :param pulumi.Input[_builtins.int] adaptive_limit: Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        :param pulumi.Input[_builtins.str] base: Specifies the location in the LDAP tree from which the monitor starts the health check
        :param pulumi.Input[_builtins.str] chase_referrals: Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        :param pulumi.Input[_builtins.str] compatibility: Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        :param pulumi.Input[_builtins.str] custom_parent: Custom parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] database: Specifies the database in which the user is created
        :param pulumi.Input[_builtins.str] destination: Specify an alias address for monitoring
        :param pulumi.Input[_builtins.str] domain: Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        :param pulumi.Input[_builtins.str] filename: Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        :param pulumi.Input[_builtins.str] filter: Specifies an LDAP key for which the monitor searches
        :param pulumi.Input[_builtins.int] interval: Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        :param pulumi.Input[_builtins.int] ip_dscp: Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        :param pulumi.Input[_builtins.str] mandatory_attributes: Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        :param pulumi.Input[_builtins.str] manual_resume: Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        :param pulumi.Input[_builtins.str] mode: Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        :param pulumi.Input[_builtins.str] parent: Parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] password: Specifies the password if the monitored target requires authentication
        :param pulumi.Input[_builtins.str] receive: Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        :param pulumi.Input[_builtins.str] receive_disable: The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        :param pulumi.Input[_builtins.str] reverse: Instructs the system to mark the target resource down when the test is successful.
        :param pulumi.Input[_builtins.str] security: Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        :param pulumi.Input[_builtins.str] send: Specifies the text string that the monitor sends to the target object.
        :param pulumi.Input[_builtins.str] ssl_profile: Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        :param pulumi.Input[_builtins.int] time_until_up: Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        :param pulumi.Input[_builtins.int] timeout: Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        :param pulumi.Input[_builtins.str] transparent: Specifies whether the monitor operates in transparent mode.
        :param pulumi.Input[_builtins.int] up_interval: Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        :param pulumi.Input[_builtins.str] username: Specifies the user name if the monitored target requires authentication
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.Monitor` Configures a custom monitor for use by health checks.

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-monitor`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        monitor = f5bigip.ltm.Monitor("monitor",
            name="/Common/terraform_monitor",
            parent="/Common/http",
            send="GET /some/path\\x0d\\n",
            timeout=999,
            interval=998,
            destination="1.2.3.4:1234")
        test_https_monitor = f5bigip.ltm.Monitor("test-https-monitor",
            name="/Common/terraform_monitor",
            parent="/Common/http",
            ssl_profile="/Common/serverssl",
            send="GET /some/path\\x0d\\n",
            interval=999,
            timeout=1000)
        test_ftp_monitor = f5bigip.ltm.Monitor("test-ftp-monitor",
            name="/Common/ftp-test",
            parent="/Common/ftp",
            interval=5,
            time_until_up=0,
            timeout=16,
            destination="*:8008",
            filename="somefile")
        test_postgresql_monitor = f5bigip.ltm.Monitor("test-postgresql-monitor",
            name="/Common/test-postgresql-monitor",
            parent="/Common/postgresql",
            send="SELECT 'Test';",
            receive="Test",
            interval=5,
            timeout=16,
            username="abcd",
            password="abcd1234")
        ```

        ## Importing

        An existing monitor can be imported into this resource by supplying monitor Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_monitor.monitor /Common/terraform_monitor
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive: Optional[pulumi.Input[_builtins.str]] = None,
                 adaptive_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 base: Optional[pulumi.Input[_builtins.str]] = None,
                 chase_referrals: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parent: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 mandatory_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 receive: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_disable: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 time_until_up: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 transparent: Optional[pulumi.Input[_builtins.str]] = None,
                 up_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["adaptive"] = adaptive
            __props__.__dict__["adaptive_limit"] = adaptive_limit
            __props__.__dict__["base"] = base
            __props__.__dict__["chase_referrals"] = chase_referrals
            __props__.__dict__["compatibility"] = compatibility
            __props__.__dict__["custom_parent"] = custom_parent
            __props__.__dict__["database"] = database
            __props__.__dict__["destination"] = destination
            __props__.__dict__["domain"] = domain
            __props__.__dict__["filename"] = filename
            __props__.__dict__["filter"] = filter
            __props__.__dict__["interval"] = interval
            __props__.__dict__["ip_dscp"] = ip_dscp
            __props__.__dict__["mandatory_attributes"] = mandatory_attributes
            __props__.__dict__["manual_resume"] = manual_resume
            __props__.__dict__["mode"] = mode
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["receive"] = receive
            __props__.__dict__["receive_disable"] = receive_disable
            __props__.__dict__["reverse"] = reverse
            __props__.__dict__["security"] = security
            __props__.__dict__["send"] = send
            __props__.__dict__["ssl_profile"] = ssl_profile
            __props__.__dict__["time_until_up"] = time_until_up
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["transparent"] = transparent
            __props__.__dict__["up_interval"] = up_interval
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Monitor, __self__).__init__(
            'f5bigip:ltm/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive: Optional[pulumi.Input[_builtins.str]] = None,
            adaptive_limit: Optional[pulumi.Input[_builtins.int]] = None,
            base: Optional[pulumi.Input[_builtins.str]] = None,
            chase_referrals: Optional[pulumi.Input[_builtins.str]] = None,
            compatibility: Optional[pulumi.Input[_builtins.str]] = None,
            custom_parent: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            filename: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            ip_dscp: Optional[pulumi.Input[_builtins.int]] = None,
            mandatory_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            manual_resume: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            receive: Optional[pulumi.Input[_builtins.str]] = None,
            receive_disable: Optional[pulumi.Input[_builtins.str]] = None,
            reverse: Optional[pulumi.Input[_builtins.str]] = None,
            security: Optional[pulumi.Input[_builtins.str]] = None,
            send: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_profile: Optional[pulumi.Input[_builtins.str]] = None,
            time_until_up: Optional[pulumi.Input[_builtins.int]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            transparent: Optional[pulumi.Input[_builtins.str]] = None,
            up_interval: Optional[pulumi.Input[_builtins.int]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adaptive: Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        :param pulumi.Input[_builtins.int] adaptive_limit: Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        :param pulumi.Input[_builtins.str] base: Specifies the location in the LDAP tree from which the monitor starts the health check
        :param pulumi.Input[_builtins.str] chase_referrals: Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        :param pulumi.Input[_builtins.str] compatibility: Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        :param pulumi.Input[_builtins.str] custom_parent: Custom parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] database: Specifies the database in which the user is created
        :param pulumi.Input[_builtins.str] destination: Specify an alias address for monitoring
        :param pulumi.Input[_builtins.str] domain: Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        :param pulumi.Input[_builtins.str] filename: Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        :param pulumi.Input[_builtins.str] filter: Specifies an LDAP key for which the monitor searches
        :param pulumi.Input[_builtins.int] interval: Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        :param pulumi.Input[_builtins.int] ip_dscp: Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        :param pulumi.Input[_builtins.str] mandatory_attributes: Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        :param pulumi.Input[_builtins.str] manual_resume: Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        :param pulumi.Input[_builtins.str] mode: Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        :param pulumi.Input[_builtins.str] parent: Parent monitor for the system to use for setting initial values for the new monitor.
        :param pulumi.Input[_builtins.str] password: Specifies the password if the monitored target requires authentication
        :param pulumi.Input[_builtins.str] receive: Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        :param pulumi.Input[_builtins.str] receive_disable: The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        :param pulumi.Input[_builtins.str] reverse: Instructs the system to mark the target resource down when the test is successful.
        :param pulumi.Input[_builtins.str] security: Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        :param pulumi.Input[_builtins.str] send: Specifies the text string that the monitor sends to the target object.
        :param pulumi.Input[_builtins.str] ssl_profile: Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        :param pulumi.Input[_builtins.int] time_until_up: Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        :param pulumi.Input[_builtins.int] timeout: Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        :param pulumi.Input[_builtins.str] transparent: Specifies whether the monitor operates in transparent mode.
        :param pulumi.Input[_builtins.int] up_interval: Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        :param pulumi.Input[_builtins.str] username: Specifies the user name if the monitored target requires authentication
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["adaptive"] = adaptive
        __props__.__dict__["adaptive_limit"] = adaptive_limit
        __props__.__dict__["base"] = base
        __props__.__dict__["chase_referrals"] = chase_referrals
        __props__.__dict__["compatibility"] = compatibility
        __props__.__dict__["custom_parent"] = custom_parent
        __props__.__dict__["database"] = database
        __props__.__dict__["destination"] = destination
        __props__.__dict__["domain"] = domain
        __props__.__dict__["filename"] = filename
        __props__.__dict__["filter"] = filter
        __props__.__dict__["interval"] = interval
        __props__.__dict__["ip_dscp"] = ip_dscp
        __props__.__dict__["mandatory_attributes"] = mandatory_attributes
        __props__.__dict__["manual_resume"] = manual_resume
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["password"] = password
        __props__.__dict__["receive"] = receive
        __props__.__dict__["receive_disable"] = receive_disable
        __props__.__dict__["reverse"] = reverse
        __props__.__dict__["security"] = security
        __props__.__dict__["send"] = send
        __props__.__dict__["ssl_profile"] = ssl_profile
        __props__.__dict__["time_until_up"] = time_until_up
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["transparent"] = transparent
        __props__.__dict__["up_interval"] = up_interval
        __props__.__dict__["username"] = username
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def adaptive(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether adaptive response time monitoring is enabled for this monitor. The default is `disabled`.
        """
        return pulumi.get(self, "adaptive")

    @_builtins.property
    @pulumi.getter(name="adaptiveLimit")
    def adaptive_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the absolute number of milliseconds that may not be exceeded by a monitor probe, regardless of Allowed Divergence.
        """
        return pulumi.get(self, "adaptive_limit")

    @_builtins.property
    @pulumi.getter
    def base(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the location in the LDAP tree from which the monitor starts the health check
        """
        return pulumi.get(self, "base")

    @_builtins.property
    @pulumi.getter(name="chaseReferrals")
    def chase_referrals(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the system will query the LDAP servers pointed to by any referrals in the query results.
        """
        return pulumi.get(self, "chase_referrals")

    @_builtins.property
    @pulumi.getter
    def compatibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies, when enabled, that the SSL options setting (in OpenSSL) is set to ALL. Accepts 'enabled' or 'disabled' values, the default value is 'enabled'.
        """
        return pulumi.get(self, "compatibility")

    @_builtins.property
    @pulumi.getter(name="customParent")
    def custom_parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "custom_parent")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the database in which the user is created
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        Specify an alias address for monitoring
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the domain name to check, for example, Domain is allowed only in case of Parent as /Common/smtp.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the full path and file name of the file that the system attempts to download. The health check is successful if the system can download the file.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies an LDAP key for which the monitor searches
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies, in seconds, the frequency at which the system issues the monitor check when either the resource is down or the status of the resource is unknown,value of `interval` should be always less than `timeout`. Default is `5`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="ipDscp")
    def ip_dscp(self) -> pulumi.Output[_builtins.int]:
        """
        Displays the differentiated services code point (DSCP).The default is `0 (zero)`.
        """
        return pulumi.get(self, "ip_dscp")

    @_builtins.property
    @pulumi.getter(name="mandatoryAttributes")
    def mandatory_attributes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether the target must include attributes in its response to be considered up. The options are no (Specifies that the system performs only a one-level search (based on the Filter setting), and does not require that the target returns any attributes.) and yes (Specifies that the system performs a sub-tree search, and if the target returns no attributes, the target is considered down.)
        """
        return pulumi.get(self, "mandatory_attributes")

    @_builtins.property
    @pulumi.getter(name="manualResume")
    def manual_resume(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the system automatically changes the status of a resource to Enabled at the next successful monitor check.
        """
        return pulumi.get(self, "manual_resume")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the data transfer process (DTP) mode. The default value is passive. The options are passive (Specifies that the monitor sends a data transfer request to the FTP server. When the FTP server receives the request, the FTP server then initiates and establishes the data connection.) and active (Specifies that the monitor initiates and establishes the data connection with the FTP server.).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Name of the LTM Monitor.Name of Monitor should be full path,full path is the combination of the `partition + monitor name`,For ex:`/Common/test-ltm-monitor`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        Parent monitor for the system to use for setting initial values for the new monitor.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password if the monitored target requires authentication
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def receive(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the regular expression representing the text string that the monitor looks for in the returned resource.
        """
        return pulumi.get(self, "receive")

    @_builtins.property
    @pulumi.getter(name="receiveDisable")
    def receive_disable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The system marks the node or pool member disabled when its response matches Receive Disable String but not Receive String.
        """
        return pulumi.get(self, "receive_disable")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> pulumi.Output[_builtins.str]:
        """
        Instructs the system to mark the target resource down when the test is successful.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the secure communications protocol that the monitor uses to communicate with the target. The options are none (Specifies that the system does not use a security protocol for communications with the target.), ssl (Specifies that the system uses the SSL protocol for communications with the target.), and tls (Specifies that the system uses the TLS protocol for communications with the target.)
        """
        return pulumi.get(self, "security")

    @_builtins.property
    @pulumi.getter
    def send(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the text string that the monitor sends to the target object.
        """
        return pulumi.get(self, "send")

    @_builtins.property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ssl profile for the monitor. It only makes sense when the parent is `/Common/https`
        """
        return pulumi.get(self, "ssl_profile")

    @_builtins.property
    @pulumi.getter(name="timeUntilUp")
    def time_until_up(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of seconds to wait after a resource first responds correctly to the monitor before setting the resource to up.
        """
        return pulumi.get(self, "time_until_up")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of seconds the target has in which to respond to the monitor request. The default is `16` seconds
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def transparent(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the monitor operates in transparent mode.
        """
        return pulumi.get(self, "transparent")

    @_builtins.property
    @pulumi.getter(name="upInterval")
    def up_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the interval for the system to use to perform the health check when a resource is up. The default is `0(Disabled)`
        """
        return pulumi.get(self, "up_interval")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the user name if the monitored target requires authentication
        """
        return pulumi.get(self, "username")

