# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnatPoolArgs', 'SnatPool']

@pulumi.input_type
class SnatPoolArgs:
    def __init__(__self__, *,
                 members: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SnatPool resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        :param pulumi.Input[_builtins.str] name: Name of the snatpool
        """
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the snatpool
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SnatPoolState:
    def __init__(__self__, *,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SnatPool resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        :param pulumi.Input[_builtins.str] name: Name of the snatpool
        """
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the snatpool
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("f5bigip:ltm/snatPool:SnatPool")
class SnatPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.SnatPool` Collections of SNAT translation addresses

        Resource should be named with their "full path". The full path is the combination of the partition + name of the resource, for example /Common/my-snatpool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        snatpool_sanjose = f5bigip.ltm.SnatPool("snatpool_sanjose",
            name="/Common/snatpool_sanjose",
            members=[
                "191.1.1.1",
                "194.2.2.2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        :param pulumi.Input[_builtins.str] name: Name of the snatpool
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnatPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.SnatPool` Collections of SNAT translation addresses

        Resource should be named with their "full path". The full path is the combination of the partition + name of the resource, for example /Common/my-snatpool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        snatpool_sanjose = f5bigip.ltm.SnatPool("snatpool_sanjose",
            name="/Common/snatpool_sanjose",
            members=[
                "191.1.1.1",
                "194.2.2.2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param SnatPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnatPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnatPoolArgs.__new__(SnatPoolArgs)

            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(SnatPool, __self__).__init__(
            'f5bigip:ltm/snatPool:SnatPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SnatPool':
        """
        Get an existing SnatPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        :param pulumi.Input[_builtins.str] name: Name of the snatpool
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnatPoolState.__new__(_SnatPoolState)

        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        return SnatPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a translation address to add to or delete from a SNAT pool (at least one address is required)
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the snatpool
        """
        return pulumi.get(self, "name")

