# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetIkePeerArgs', 'NetIkePeer']

@pulumi.input_type
class NetIkePeerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 remote_address: pulumi.Input[_builtins.str],
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_file: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 generate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_traversal: Optional[pulumi.Input[_builtins.str]] = None,
                 passive: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_hash_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_perfect_forward_secrecy: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key_encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 prf: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_support: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_size: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 verify_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetIkePeer resource.
        :param pulumi.Input[_builtins.str] name: Name of the ike_peer
        :param pulumi.Input[_builtins.str] remote_address: Specifies the IP address of the IKE remote node
        :param pulumi.Input[_builtins.str] app_service: The application service that the object belongs to
        :param pulumi.Input[_builtins.str] ca_cert_file: the trusted root and intermediate certificate authorities
        :param pulumi.Input[_builtins.str] crl_file: Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.int] dpd_delay: Specifies the number of seconds between Dead Peer Detection messages
        :param pulumi.Input[_builtins.str] generate_policy: Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        :param pulumi.Input[_builtins.int] lifetime: Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        :param pulumi.Input[_builtins.str] mode: Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        :param pulumi.Input[_builtins.str] my_cert_file: Specifies the name of the certificate file object
        :param pulumi.Input[_builtins.str] my_cert_key_file: Specifies the name of the certificate key file object
        :param pulumi.Input[_builtins.str] my_cert_key_passphrase: Specifies the passphrase of the key used for my-cert-key-file
        :param pulumi.Input[_builtins.str] my_id_type: Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] my_id_value: Specifies the identifier value sent to the remote host in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] nat_traversal: Enables use of the NAT-Traversal IPsec extension
        :param pulumi.Input[_builtins.str] passive: Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        :param pulumi.Input[_builtins.str] peers_cert_file: Specifies the peer’s certificate for authentication
        :param pulumi.Input[_builtins.str] peers_cert_type: Specifies that the only peers-cert-type supported is certfile
        :param pulumi.Input[_builtins.str] peers_id_type: Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        :param pulumi.Input[_builtins.str] peers_id_value: Specifies the peer’s identifier to be received
        :param pulumi.Input[_builtins.str] phase1_auth_method: Specifies the authentication method used for phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_encrypt_algorithm: Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_hash_algorithm: Defines the hash algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_perfect_forward_secrecy: Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        :param pulumi.Input[_builtins.str] preshared_key: Specifies the preshared key for ISAKMP SAs
        :param pulumi.Input[_builtins.str] preshared_key_encrypted: Display the encrypted preshared-key for the IKE remote node
        :param pulumi.Input[_builtins.str] prf: Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        :param pulumi.Input[_builtins.str] proxy_support: If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        :param pulumi.Input[_builtins.int] replay_window_size: Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        :param pulumi.Input[_builtins.str] state: Enables or disables this IKE remote node
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_selectors: Specifies the names of the traffic-selector objects associated with this ike-peer
        :param pulumi.Input[_builtins.str] verify_cert: Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Specifies which version of IKE to be used
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remote_address", remote_address)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if ca_cert_file is not None:
            pulumi.set(__self__, "ca_cert_file", ca_cert_file)
        if crl_file is not None:
            pulumi.set(__self__, "crl_file", crl_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dpd_delay is not None:
            pulumi.set(__self__, "dpd_delay", dpd_delay)
        if generate_policy is not None:
            pulumi.set(__self__, "generate_policy", generate_policy)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if my_cert_file is not None:
            pulumi.set(__self__, "my_cert_file", my_cert_file)
        if my_cert_key_file is not None:
            pulumi.set(__self__, "my_cert_key_file", my_cert_key_file)
        if my_cert_key_passphrase is not None:
            pulumi.set(__self__, "my_cert_key_passphrase", my_cert_key_passphrase)
        if my_id_type is not None:
            pulumi.set(__self__, "my_id_type", my_id_type)
        if my_id_value is not None:
            pulumi.set(__self__, "my_id_value", my_id_value)
        if nat_traversal is not None:
            pulumi.set(__self__, "nat_traversal", nat_traversal)
        if passive is not None:
            pulumi.set(__self__, "passive", passive)
        if peers_cert_file is not None:
            pulumi.set(__self__, "peers_cert_file", peers_cert_file)
        if peers_cert_type is not None:
            pulumi.set(__self__, "peers_cert_type", peers_cert_type)
        if peers_id_type is not None:
            pulumi.set(__self__, "peers_id_type", peers_id_type)
        if peers_id_value is not None:
            pulumi.set(__self__, "peers_id_value", peers_id_value)
        if phase1_auth_method is not None:
            pulumi.set(__self__, "phase1_auth_method", phase1_auth_method)
        if phase1_encrypt_algorithm is not None:
            pulumi.set(__self__, "phase1_encrypt_algorithm", phase1_encrypt_algorithm)
        if phase1_hash_algorithm is not None:
            pulumi.set(__self__, "phase1_hash_algorithm", phase1_hash_algorithm)
        if phase1_perfect_forward_secrecy is not None:
            pulumi.set(__self__, "phase1_perfect_forward_secrecy", phase1_perfect_forward_secrecy)
        if preshared_key is not None:
            pulumi.set(__self__, "preshared_key", preshared_key)
        if preshared_key_encrypted is not None:
            pulumi.set(__self__, "preshared_key_encrypted", preshared_key_encrypted)
        if prf is not None:
            pulumi.set(__self__, "prf", prf)
        if proxy_support is not None:
            pulumi.set(__self__, "proxy_support", proxy_support)
        if replay_window_size is not None:
            pulumi.set(__self__, "replay_window_size", replay_window_size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if traffic_selectors is not None:
            pulumi.set(__self__, "traffic_selectors", traffic_selectors)
        if verify_cert is not None:
            pulumi.set(__self__, "verify_cert", verify_cert)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the ike_peer
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteAddress")
    def remote_address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IP address of the IKE remote node
        """
        return pulumi.get(self, "remote_address")

    @remote_address.setter
    def remote_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_address", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service that the object belongs to
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the trusted root and intermediate certificate authorities
        """
        return pulumi.get(self, "ca_cert_file")

    @ca_cert_file.setter
    def ca_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        """
        return pulumi.get(self, "crl_file")

    @crl_file.setter
    def crl_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crl_file", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dpdDelay")
    def dpd_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds between Dead Peer Detection messages
        """
        return pulumi.get(self, "dpd_delay")

    @dpd_delay.setter
    def dpd_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dpd_delay", value)

    @_builtins.property
    @pulumi.getter(name="generatePolicy")
    def generate_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        """
        return pulumi.get(self, "generate_policy")

    @generate_policy.setter
    def generate_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generate_policy", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="myCertFile")
    def my_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate file object
        """
        return pulumi.get(self, "my_cert_file")

    @my_cert_file.setter
    def my_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="myCertKeyFile")
    def my_cert_key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate key file object
        """
        return pulumi.get(self, "my_cert_key_file")

    @my_cert_key_file.setter
    def my_cert_key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_key_file", value)

    @_builtins.property
    @pulumi.getter(name="myCertKeyPassphrase")
    def my_cert_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the passphrase of the key used for my-cert-key-file
        """
        return pulumi.get(self, "my_cert_key_passphrase")

    @my_cert_key_passphrase.setter
    def my_cert_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_key_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="myIdType")
    def my_id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_type")

    @my_id_type.setter
    def my_id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_id_type", value)

    @_builtins.property
    @pulumi.getter(name="myIdValue")
    def my_id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier value sent to the remote host in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_value")

    @my_id_value.setter
    def my_id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_id_value", value)

    @_builtins.property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables use of the NAT-Traversal IPsec extension
        """
        return pulumi.get(self, "nat_traversal")

    @nat_traversal.setter
    def nat_traversal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_traversal", value)

    @_builtins.property
    @pulumi.getter
    def passive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        """
        return pulumi.get(self, "passive")

    @passive.setter
    def passive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passive", value)

    @_builtins.property
    @pulumi.getter(name="peersCertFile")
    def peers_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the peer’s certificate for authentication
        """
        return pulumi.get(self, "peers_cert_file")

    @peers_cert_file.setter
    def peers_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="peersCertType")
    def peers_cert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies that the only peers-cert-type supported is certfile
        """
        return pulumi.get(self, "peers_cert_type")

    @peers_cert_type.setter
    def peers_cert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_cert_type", value)

    @_builtins.property
    @pulumi.getter(name="peersIdType")
    def peers_id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        """
        return pulumi.get(self, "peers_id_type")

    @peers_id_type.setter
    def peers_id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_id_type", value)

    @_builtins.property
    @pulumi.getter(name="peersIdValue")
    def peers_id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the peer’s identifier to be received
        """
        return pulumi.get(self, "peers_id_value")

    @peers_id_value.setter
    def peers_id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_id_value", value)

    @_builtins.property
    @pulumi.getter(name="phase1AuthMethod")
    def phase1_auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the authentication method used for phase 1 negotiation
        """
        return pulumi.get(self, "phase1_auth_method")

    @phase1_auth_method.setter
    def phase1_auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_auth_method", value)

    @_builtins.property
    @pulumi.getter(name="phase1EncryptAlgorithm")
    def phase1_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_encrypt_algorithm")

    @phase1_encrypt_algorithm.setter
    def phase1_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="phase1HashAlgorithm")
    def phase1_hash_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the hash algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_hash_algorithm")

    @phase1_hash_algorithm.setter
    def phase1_hash_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_hash_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="phase1PerfectForwardSecrecy")
    def phase1_perfect_forward_secrecy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        """
        return pulumi.get(self, "phase1_perfect_forward_secrecy")

    @phase1_perfect_forward_secrecy.setter
    def phase1_perfect_forward_secrecy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_perfect_forward_secrecy", value)

    @_builtins.property
    @pulumi.getter(name="presharedKey")
    def preshared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the preshared key for ISAKMP SAs
        """
        return pulumi.get(self, "preshared_key")

    @preshared_key.setter
    def preshared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preshared_key", value)

    @_builtins.property
    @pulumi.getter(name="presharedKeyEncrypted")
    def preshared_key_encrypted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display the encrypted preshared-key for the IKE remote node
        """
        return pulumi.get(self, "preshared_key_encrypted")

    @preshared_key_encrypted.setter
    def preshared_key_encrypted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preshared_key_encrypted", value)

    @_builtins.property
    @pulumi.getter
    def prf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        """
        return pulumi.get(self, "prf")

    @prf.setter
    def prf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prf", value)

    @_builtins.property
    @pulumi.getter(name="proxySupport")
    def proxy_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        """
        return pulumi.get(self, "proxy_support")

    @proxy_support.setter
    def proxy_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_support", value)

    @_builtins.property
    @pulumi.getter(name="replayWindowSize")
    def replay_window_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        """
        return pulumi.get(self, "replay_window_size")

    @replay_window_size.setter
    def replay_window_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replay_window_size", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables this IKE remote node
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectors")
    def traffic_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the traffic-selector objects associated with this ike-peer
        """
        return pulumi.get(self, "traffic_selectors")

    @traffic_selectors.setter
    def traffic_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "traffic_selectors", value)

    @_builtins.property
    @pulumi.getter(name="verifyCert")
    def verify_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        """
        return pulumi.get(self, "verify_cert")

    @verify_cert.setter
    def verify_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verify_cert", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which version of IKE to be used
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.input_type
class _NetIkePeerState:
    def __init__(__self__, *,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_file: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 generate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_traversal: Optional[pulumi.Input[_builtins.str]] = None,
                 passive: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_hash_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_perfect_forward_secrecy: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key_encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 prf: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_support: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_address: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_size: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 verify_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetIkePeer resources.
        :param pulumi.Input[_builtins.str] app_service: The application service that the object belongs to
        :param pulumi.Input[_builtins.str] ca_cert_file: the trusted root and intermediate certificate authorities
        :param pulumi.Input[_builtins.str] crl_file: Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.int] dpd_delay: Specifies the number of seconds between Dead Peer Detection messages
        :param pulumi.Input[_builtins.str] generate_policy: Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        :param pulumi.Input[_builtins.int] lifetime: Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        :param pulumi.Input[_builtins.str] mode: Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        :param pulumi.Input[_builtins.str] my_cert_file: Specifies the name of the certificate file object
        :param pulumi.Input[_builtins.str] my_cert_key_file: Specifies the name of the certificate key file object
        :param pulumi.Input[_builtins.str] my_cert_key_passphrase: Specifies the passphrase of the key used for my-cert-key-file
        :param pulumi.Input[_builtins.str] my_id_type: Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] my_id_value: Specifies the identifier value sent to the remote host in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] name: Name of the ike_peer
        :param pulumi.Input[_builtins.str] nat_traversal: Enables use of the NAT-Traversal IPsec extension
        :param pulumi.Input[_builtins.str] passive: Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        :param pulumi.Input[_builtins.str] peers_cert_file: Specifies the peer’s certificate for authentication
        :param pulumi.Input[_builtins.str] peers_cert_type: Specifies that the only peers-cert-type supported is certfile
        :param pulumi.Input[_builtins.str] peers_id_type: Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        :param pulumi.Input[_builtins.str] peers_id_value: Specifies the peer’s identifier to be received
        :param pulumi.Input[_builtins.str] phase1_auth_method: Specifies the authentication method used for phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_encrypt_algorithm: Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_hash_algorithm: Defines the hash algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_perfect_forward_secrecy: Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        :param pulumi.Input[_builtins.str] preshared_key: Specifies the preshared key for ISAKMP SAs
        :param pulumi.Input[_builtins.str] preshared_key_encrypted: Display the encrypted preshared-key for the IKE remote node
        :param pulumi.Input[_builtins.str] prf: Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        :param pulumi.Input[_builtins.str] proxy_support: If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        :param pulumi.Input[_builtins.str] remote_address: Specifies the IP address of the IKE remote node
        :param pulumi.Input[_builtins.int] replay_window_size: Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        :param pulumi.Input[_builtins.str] state: Enables or disables this IKE remote node
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_selectors: Specifies the names of the traffic-selector objects associated with this ike-peer
        :param pulumi.Input[_builtins.str] verify_cert: Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Specifies which version of IKE to be used
        """
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if ca_cert_file is not None:
            pulumi.set(__self__, "ca_cert_file", ca_cert_file)
        if crl_file is not None:
            pulumi.set(__self__, "crl_file", crl_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dpd_delay is not None:
            pulumi.set(__self__, "dpd_delay", dpd_delay)
        if generate_policy is not None:
            pulumi.set(__self__, "generate_policy", generate_policy)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if my_cert_file is not None:
            pulumi.set(__self__, "my_cert_file", my_cert_file)
        if my_cert_key_file is not None:
            pulumi.set(__self__, "my_cert_key_file", my_cert_key_file)
        if my_cert_key_passphrase is not None:
            pulumi.set(__self__, "my_cert_key_passphrase", my_cert_key_passphrase)
        if my_id_type is not None:
            pulumi.set(__self__, "my_id_type", my_id_type)
        if my_id_value is not None:
            pulumi.set(__self__, "my_id_value", my_id_value)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_traversal is not None:
            pulumi.set(__self__, "nat_traversal", nat_traversal)
        if passive is not None:
            pulumi.set(__self__, "passive", passive)
        if peers_cert_file is not None:
            pulumi.set(__self__, "peers_cert_file", peers_cert_file)
        if peers_cert_type is not None:
            pulumi.set(__self__, "peers_cert_type", peers_cert_type)
        if peers_id_type is not None:
            pulumi.set(__self__, "peers_id_type", peers_id_type)
        if peers_id_value is not None:
            pulumi.set(__self__, "peers_id_value", peers_id_value)
        if phase1_auth_method is not None:
            pulumi.set(__self__, "phase1_auth_method", phase1_auth_method)
        if phase1_encrypt_algorithm is not None:
            pulumi.set(__self__, "phase1_encrypt_algorithm", phase1_encrypt_algorithm)
        if phase1_hash_algorithm is not None:
            pulumi.set(__self__, "phase1_hash_algorithm", phase1_hash_algorithm)
        if phase1_perfect_forward_secrecy is not None:
            pulumi.set(__self__, "phase1_perfect_forward_secrecy", phase1_perfect_forward_secrecy)
        if preshared_key is not None:
            pulumi.set(__self__, "preshared_key", preshared_key)
        if preshared_key_encrypted is not None:
            pulumi.set(__self__, "preshared_key_encrypted", preshared_key_encrypted)
        if prf is not None:
            pulumi.set(__self__, "prf", prf)
        if proxy_support is not None:
            pulumi.set(__self__, "proxy_support", proxy_support)
        if remote_address is not None:
            pulumi.set(__self__, "remote_address", remote_address)
        if replay_window_size is not None:
            pulumi.set(__self__, "replay_window_size", replay_window_size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if traffic_selectors is not None:
            pulumi.set(__self__, "traffic_selectors", traffic_selectors)
        if verify_cert is not None:
            pulumi.set(__self__, "verify_cert", verify_cert)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service that the object belongs to
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the trusted root and intermediate certificate authorities
        """
        return pulumi.get(self, "ca_cert_file")

    @ca_cert_file.setter
    def ca_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        """
        return pulumi.get(self, "crl_file")

    @crl_file.setter
    def crl_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crl_file", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dpdDelay")
    def dpd_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds between Dead Peer Detection messages
        """
        return pulumi.get(self, "dpd_delay")

    @dpd_delay.setter
    def dpd_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dpd_delay", value)

    @_builtins.property
    @pulumi.getter(name="generatePolicy")
    def generate_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        """
        return pulumi.get(self, "generate_policy")

    @generate_policy.setter
    def generate_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generate_policy", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="myCertFile")
    def my_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate file object
        """
        return pulumi.get(self, "my_cert_file")

    @my_cert_file.setter
    def my_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="myCertKeyFile")
    def my_cert_key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the certificate key file object
        """
        return pulumi.get(self, "my_cert_key_file")

    @my_cert_key_file.setter
    def my_cert_key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_key_file", value)

    @_builtins.property
    @pulumi.getter(name="myCertKeyPassphrase")
    def my_cert_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the passphrase of the key used for my-cert-key-file
        """
        return pulumi.get(self, "my_cert_key_passphrase")

    @my_cert_key_passphrase.setter
    def my_cert_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_cert_key_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="myIdType")
    def my_id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_type")

    @my_id_type.setter
    def my_id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_id_type", value)

    @_builtins.property
    @pulumi.getter(name="myIdValue")
    def my_id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier value sent to the remote host in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_value")

    @my_id_value.setter
    def my_id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "my_id_value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ike_peer
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables use of the NAT-Traversal IPsec extension
        """
        return pulumi.get(self, "nat_traversal")

    @nat_traversal.setter
    def nat_traversal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_traversal", value)

    @_builtins.property
    @pulumi.getter
    def passive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        """
        return pulumi.get(self, "passive")

    @passive.setter
    def passive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passive", value)

    @_builtins.property
    @pulumi.getter(name="peersCertFile")
    def peers_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the peer’s certificate for authentication
        """
        return pulumi.get(self, "peers_cert_file")

    @peers_cert_file.setter
    def peers_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="peersCertType")
    def peers_cert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies that the only peers-cert-type supported is certfile
        """
        return pulumi.get(self, "peers_cert_type")

    @peers_cert_type.setter
    def peers_cert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_cert_type", value)

    @_builtins.property
    @pulumi.getter(name="peersIdType")
    def peers_id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        """
        return pulumi.get(self, "peers_id_type")

    @peers_id_type.setter
    def peers_id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_id_type", value)

    @_builtins.property
    @pulumi.getter(name="peersIdValue")
    def peers_id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the peer’s identifier to be received
        """
        return pulumi.get(self, "peers_id_value")

    @peers_id_value.setter
    def peers_id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peers_id_value", value)

    @_builtins.property
    @pulumi.getter(name="phase1AuthMethod")
    def phase1_auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the authentication method used for phase 1 negotiation
        """
        return pulumi.get(self, "phase1_auth_method")

    @phase1_auth_method.setter
    def phase1_auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_auth_method", value)

    @_builtins.property
    @pulumi.getter(name="phase1EncryptAlgorithm")
    def phase1_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_encrypt_algorithm")

    @phase1_encrypt_algorithm.setter
    def phase1_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="phase1HashAlgorithm")
    def phase1_hash_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the hash algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_hash_algorithm")

    @phase1_hash_algorithm.setter
    def phase1_hash_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_hash_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="phase1PerfectForwardSecrecy")
    def phase1_perfect_forward_secrecy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        """
        return pulumi.get(self, "phase1_perfect_forward_secrecy")

    @phase1_perfect_forward_secrecy.setter
    def phase1_perfect_forward_secrecy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase1_perfect_forward_secrecy", value)

    @_builtins.property
    @pulumi.getter(name="presharedKey")
    def preshared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the preshared key for ISAKMP SAs
        """
        return pulumi.get(self, "preshared_key")

    @preshared_key.setter
    def preshared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preshared_key", value)

    @_builtins.property
    @pulumi.getter(name="presharedKeyEncrypted")
    def preshared_key_encrypted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display the encrypted preshared-key for the IKE remote node
        """
        return pulumi.get(self, "preshared_key_encrypted")

    @preshared_key_encrypted.setter
    def preshared_key_encrypted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preshared_key_encrypted", value)

    @_builtins.property
    @pulumi.getter
    def prf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        """
        return pulumi.get(self, "prf")

    @prf.setter
    def prf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prf", value)

    @_builtins.property
    @pulumi.getter(name="proxySupport")
    def proxy_support(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        """
        return pulumi.get(self, "proxy_support")

    @proxy_support.setter
    def proxy_support(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_support", value)

    @_builtins.property
    @pulumi.getter(name="remoteAddress")
    def remote_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address of the IKE remote node
        """
        return pulumi.get(self, "remote_address")

    @remote_address.setter
    def remote_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_address", value)

    @_builtins.property
    @pulumi.getter(name="replayWindowSize")
    def replay_window_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        """
        return pulumi.get(self, "replay_window_size")

    @replay_window_size.setter
    def replay_window_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replay_window_size", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables this IKE remote node
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectors")
    def traffic_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the traffic-selector objects associated with this ike-peer
        """
        return pulumi.get(self, "traffic_selectors")

    @traffic_selectors.setter
    def traffic_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "traffic_selectors", value)

    @_builtins.property
    @pulumi.getter(name="verifyCert")
    def verify_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        """
        return pulumi.get(self, "verify_cert")

    @verify_cert.setter
    def verify_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verify_cert", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which version of IKE to be used
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("f5bigip:index/netIkePeer:NetIkePeer")
class NetIkePeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_file: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 generate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_traversal: Optional[pulumi.Input[_builtins.str]] = None,
                 passive: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_hash_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_perfect_forward_secrecy: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key_encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 prf: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_support: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_address: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_size: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 verify_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        `NetIkePeer` Manages a ike_peer configuration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service: The application service that the object belongs to
        :param pulumi.Input[_builtins.str] ca_cert_file: the trusted root and intermediate certificate authorities
        :param pulumi.Input[_builtins.str] crl_file: Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.int] dpd_delay: Specifies the number of seconds between Dead Peer Detection messages
        :param pulumi.Input[_builtins.str] generate_policy: Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        :param pulumi.Input[_builtins.int] lifetime: Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        :param pulumi.Input[_builtins.str] mode: Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        :param pulumi.Input[_builtins.str] my_cert_file: Specifies the name of the certificate file object
        :param pulumi.Input[_builtins.str] my_cert_key_file: Specifies the name of the certificate key file object
        :param pulumi.Input[_builtins.str] my_cert_key_passphrase: Specifies the passphrase of the key used for my-cert-key-file
        :param pulumi.Input[_builtins.str] my_id_type: Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] my_id_value: Specifies the identifier value sent to the remote host in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] name: Name of the ike_peer
        :param pulumi.Input[_builtins.str] nat_traversal: Enables use of the NAT-Traversal IPsec extension
        :param pulumi.Input[_builtins.str] passive: Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        :param pulumi.Input[_builtins.str] peers_cert_file: Specifies the peer’s certificate for authentication
        :param pulumi.Input[_builtins.str] peers_cert_type: Specifies that the only peers-cert-type supported is certfile
        :param pulumi.Input[_builtins.str] peers_id_type: Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        :param pulumi.Input[_builtins.str] peers_id_value: Specifies the peer’s identifier to be received
        :param pulumi.Input[_builtins.str] phase1_auth_method: Specifies the authentication method used for phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_encrypt_algorithm: Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_hash_algorithm: Defines the hash algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_perfect_forward_secrecy: Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        :param pulumi.Input[_builtins.str] preshared_key: Specifies the preshared key for ISAKMP SAs
        :param pulumi.Input[_builtins.str] preshared_key_encrypted: Display the encrypted preshared-key for the IKE remote node
        :param pulumi.Input[_builtins.str] prf: Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        :param pulumi.Input[_builtins.str] proxy_support: If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        :param pulumi.Input[_builtins.str] remote_address: Specifies the IP address of the IKE remote node
        :param pulumi.Input[_builtins.int] replay_window_size: Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        :param pulumi.Input[_builtins.str] state: Enables or disables this IKE remote node
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_selectors: Specifies the names of the traffic-selector objects associated with this ike-peer
        :param pulumi.Input[_builtins.str] verify_cert: Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Specifies which version of IKE to be used
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetIkePeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `NetIkePeer` Manages a ike_peer configuration

        :param str resource_name: The name of the resource.
        :param NetIkePeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetIkePeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_file: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dpd_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 generate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 my_cert_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 my_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_traversal: Optional[pulumi.Input[_builtins.str]] = None,
                 passive: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peers_id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_hash_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 phase1_perfect_forward_secrecy: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 preshared_key_encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 prf: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_support: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_address: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_size: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 verify_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetIkePeerArgs.__new__(NetIkePeerArgs)

            __props__.__dict__["app_service"] = app_service
            __props__.__dict__["ca_cert_file"] = ca_cert_file
            __props__.__dict__["crl_file"] = crl_file
            __props__.__dict__["description"] = description
            __props__.__dict__["dpd_delay"] = dpd_delay
            __props__.__dict__["generate_policy"] = generate_policy
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["mode"] = mode
            __props__.__dict__["my_cert_file"] = my_cert_file
            __props__.__dict__["my_cert_key_file"] = my_cert_key_file
            __props__.__dict__["my_cert_key_passphrase"] = my_cert_key_passphrase
            __props__.__dict__["my_id_type"] = my_id_type
            __props__.__dict__["my_id_value"] = my_id_value
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_traversal"] = nat_traversal
            __props__.__dict__["passive"] = passive
            __props__.__dict__["peers_cert_file"] = peers_cert_file
            __props__.__dict__["peers_cert_type"] = peers_cert_type
            __props__.__dict__["peers_id_type"] = peers_id_type
            __props__.__dict__["peers_id_value"] = peers_id_value
            __props__.__dict__["phase1_auth_method"] = phase1_auth_method
            __props__.__dict__["phase1_encrypt_algorithm"] = phase1_encrypt_algorithm
            __props__.__dict__["phase1_hash_algorithm"] = phase1_hash_algorithm
            __props__.__dict__["phase1_perfect_forward_secrecy"] = phase1_perfect_forward_secrecy
            __props__.__dict__["preshared_key"] = preshared_key
            __props__.__dict__["preshared_key_encrypted"] = preshared_key_encrypted
            __props__.__dict__["prf"] = prf
            __props__.__dict__["proxy_support"] = proxy_support
            if remote_address is None and not opts.urn:
                raise TypeError("Missing required property 'remote_address'")
            __props__.__dict__["remote_address"] = remote_address
            __props__.__dict__["replay_window_size"] = replay_window_size
            __props__.__dict__["state"] = state
            __props__.__dict__["traffic_selectors"] = traffic_selectors
            __props__.__dict__["verify_cert"] = verify_cert
            __props__.__dict__["versions"] = versions
        super(NetIkePeer, __self__).__init__(
            'f5bigip:index/netIkePeer:NetIkePeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service: Optional[pulumi.Input[_builtins.str]] = None,
            ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
            crl_file: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dpd_delay: Optional[pulumi.Input[_builtins.int]] = None,
            generate_policy: Optional[pulumi.Input[_builtins.str]] = None,
            lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            my_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
            my_cert_key_file: Optional[pulumi.Input[_builtins.str]] = None,
            my_cert_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            my_id_type: Optional[pulumi.Input[_builtins.str]] = None,
            my_id_value: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_traversal: Optional[pulumi.Input[_builtins.str]] = None,
            passive: Optional[pulumi.Input[_builtins.str]] = None,
            peers_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
            peers_cert_type: Optional[pulumi.Input[_builtins.str]] = None,
            peers_id_type: Optional[pulumi.Input[_builtins.str]] = None,
            peers_id_value: Optional[pulumi.Input[_builtins.str]] = None,
            phase1_auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            phase1_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            phase1_hash_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            phase1_perfect_forward_secrecy: Optional[pulumi.Input[_builtins.str]] = None,
            preshared_key: Optional[pulumi.Input[_builtins.str]] = None,
            preshared_key_encrypted: Optional[pulumi.Input[_builtins.str]] = None,
            prf: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_support: Optional[pulumi.Input[_builtins.str]] = None,
            remote_address: Optional[pulumi.Input[_builtins.str]] = None,
            replay_window_size: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            verify_cert: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NetIkePeer':
        """
        Get an existing NetIkePeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service: The application service that the object belongs to
        :param pulumi.Input[_builtins.str] ca_cert_file: the trusted root and intermediate certificate authorities
        :param pulumi.Input[_builtins.str] crl_file: Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.int] dpd_delay: Specifies the number of seconds between Dead Peer Detection messages
        :param pulumi.Input[_builtins.str] generate_policy: Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        :param pulumi.Input[_builtins.int] lifetime: Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        :param pulumi.Input[_builtins.str] mode: Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        :param pulumi.Input[_builtins.str] my_cert_file: Specifies the name of the certificate file object
        :param pulumi.Input[_builtins.str] my_cert_key_file: Specifies the name of the certificate key file object
        :param pulumi.Input[_builtins.str] my_cert_key_passphrase: Specifies the passphrase of the key used for my-cert-key-file
        :param pulumi.Input[_builtins.str] my_id_type: Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] my_id_value: Specifies the identifier value sent to the remote host in the phase 1 negotiation
        :param pulumi.Input[_builtins.str] name: Name of the ike_peer
        :param pulumi.Input[_builtins.str] nat_traversal: Enables use of the NAT-Traversal IPsec extension
        :param pulumi.Input[_builtins.str] passive: Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        :param pulumi.Input[_builtins.str] peers_cert_file: Specifies the peer’s certificate for authentication
        :param pulumi.Input[_builtins.str] peers_cert_type: Specifies that the only peers-cert-type supported is certfile
        :param pulumi.Input[_builtins.str] peers_id_type: Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        :param pulumi.Input[_builtins.str] peers_id_value: Specifies the peer’s identifier to be received
        :param pulumi.Input[_builtins.str] phase1_auth_method: Specifies the authentication method used for phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_encrypt_algorithm: Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_hash_algorithm: Defines the hash algorithm used for the isakmp phase 1 negotiation
        :param pulumi.Input[_builtins.str] phase1_perfect_forward_secrecy: Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        :param pulumi.Input[_builtins.str] preshared_key: Specifies the preshared key for ISAKMP SAs
        :param pulumi.Input[_builtins.str] preshared_key_encrypted: Display the encrypted preshared-key for the IKE remote node
        :param pulumi.Input[_builtins.str] prf: Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        :param pulumi.Input[_builtins.str] proxy_support: If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        :param pulumi.Input[_builtins.str] remote_address: Specifies the IP address of the IKE remote node
        :param pulumi.Input[_builtins.int] replay_window_size: Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        :param pulumi.Input[_builtins.str] state: Enables or disables this IKE remote node
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_selectors: Specifies the names of the traffic-selector objects associated with this ike-peer
        :param pulumi.Input[_builtins.str] verify_cert: Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Specifies which version of IKE to be used
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetIkePeerState.__new__(_NetIkePeerState)

        __props__.__dict__["app_service"] = app_service
        __props__.__dict__["ca_cert_file"] = ca_cert_file
        __props__.__dict__["crl_file"] = crl_file
        __props__.__dict__["description"] = description
        __props__.__dict__["dpd_delay"] = dpd_delay
        __props__.__dict__["generate_policy"] = generate_policy
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["mode"] = mode
        __props__.__dict__["my_cert_file"] = my_cert_file
        __props__.__dict__["my_cert_key_file"] = my_cert_key_file
        __props__.__dict__["my_cert_key_passphrase"] = my_cert_key_passphrase
        __props__.__dict__["my_id_type"] = my_id_type
        __props__.__dict__["my_id_value"] = my_id_value
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_traversal"] = nat_traversal
        __props__.__dict__["passive"] = passive
        __props__.__dict__["peers_cert_file"] = peers_cert_file
        __props__.__dict__["peers_cert_type"] = peers_cert_type
        __props__.__dict__["peers_id_type"] = peers_id_type
        __props__.__dict__["peers_id_value"] = peers_id_value
        __props__.__dict__["phase1_auth_method"] = phase1_auth_method
        __props__.__dict__["phase1_encrypt_algorithm"] = phase1_encrypt_algorithm
        __props__.__dict__["phase1_hash_algorithm"] = phase1_hash_algorithm
        __props__.__dict__["phase1_perfect_forward_secrecy"] = phase1_perfect_forward_secrecy
        __props__.__dict__["preshared_key"] = preshared_key
        __props__.__dict__["preshared_key_encrypted"] = preshared_key_encrypted
        __props__.__dict__["prf"] = prf
        __props__.__dict__["proxy_support"] = proxy_support
        __props__.__dict__["remote_address"] = remote_address
        __props__.__dict__["replay_window_size"] = replay_window_size
        __props__.__dict__["state"] = state
        __props__.__dict__["traffic_selectors"] = traffic_selectors
        __props__.__dict__["verify_cert"] = verify_cert
        __props__.__dict__["versions"] = versions
        return NetIkePeer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application service that the object belongs to
        """
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> pulumi.Output[_builtins.str]:
        """
        the trusted root and intermediate certificate authorities
        """
        return pulumi.get(self, "ca_cert_file")

    @_builtins.property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the file name of the Certificate Revocation List. Only supported in IKEv1
        """
        return pulumi.get(self, "crl_file")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dpdDelay")
    def dpd_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of seconds between Dead Peer Detection messages
        """
        return pulumi.get(self, "dpd_delay")

    @_builtins.property
    @pulumi.getter(name="generatePolicy")
    def generate_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Enable or disable the generation of Security Policy Database entries(SPD) when the device is the responder of the IKE remote node
        """
        return pulumi.get(self, "generate_policy")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[_builtins.int]:
        """
        Defines the lifetime in minutes of an IKE SA which will be proposed in the phase 1 negotiations
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the exchange mode for phase 1 when racoon is the initiator, or the acceptable exchange mode when racoon is the responder
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="myCertFile")
    def my_cert_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the certificate file object
        """
        return pulumi.get(self, "my_cert_file")

    @_builtins.property
    @pulumi.getter(name="myCertKeyFile")
    def my_cert_key_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the certificate key file object
        """
        return pulumi.get(self, "my_cert_key_file")

    @_builtins.property
    @pulumi.getter(name="myCertKeyPassphrase")
    def my_cert_key_passphrase(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the passphrase of the key used for my-cert-key-file
        """
        return pulumi.get(self, "my_cert_key_passphrase")

    @_builtins.property
    @pulumi.getter(name="myIdType")
    def my_id_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier type sent to the remote host to use in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_type")

    @_builtins.property
    @pulumi.getter(name="myIdValue")
    def my_id_value(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier value sent to the remote host in the phase 1 negotiation
        """
        return pulumi.get(self, "my_id_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the ike_peer
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natTraversal")
    def nat_traversal(self) -> pulumi.Output[_builtins.str]:
        """
        Enables use of the NAT-Traversal IPsec extension
        """
        return pulumi.get(self, "nat_traversal")

    @_builtins.property
    @pulumi.getter
    def passive(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the local IKE agent can be the initiator of the IKE negotiation with this ike-peer
        """
        return pulumi.get(self, "passive")

    @_builtins.property
    @pulumi.getter(name="peersCertFile")
    def peers_cert_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the peer’s certificate for authentication
        """
        return pulumi.get(self, "peers_cert_file")

    @_builtins.property
    @pulumi.getter(name="peersCertType")
    def peers_cert_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies that the only peers-cert-type supported is certfile
        """
        return pulumi.get(self, "peers_cert_type")

    @_builtins.property
    @pulumi.getter(name="peersIdType")
    def peers_id_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies which of address, fqdn, asn1dn, user-fqdn or keyid-tag types to use as peers-id-type
        """
        return pulumi.get(self, "peers_id_type")

    @_builtins.property
    @pulumi.getter(name="peersIdValue")
    def peers_id_value(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the peer’s identifier to be received
        """
        return pulumi.get(self, "peers_id_value")

    @_builtins.property
    @pulumi.getter(name="phase1AuthMethod")
    def phase1_auth_method(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the authentication method used for phase 1 negotiation
        """
        return pulumi.get(self, "phase1_auth_method")

    @_builtins.property
    @pulumi.getter(name="phase1EncryptAlgorithm")
    def phase1_encrypt_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the encryption algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_encrypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="phase1HashAlgorithm")
    def phase1_hash_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the hash algorithm used for the isakmp phase 1 negotiation
        """
        return pulumi.get(self, "phase1_hash_algorithm")

    @_builtins.property
    @pulumi.getter(name="phase1PerfectForwardSecrecy")
    def phase1_perfect_forward_secrecy(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the Diffie-Hellman group for key exchange to provide perfect forward secrecy
        """
        return pulumi.get(self, "phase1_perfect_forward_secrecy")

    @_builtins.property
    @pulumi.getter(name="presharedKey")
    def preshared_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the preshared key for ISAKMP SAs
        """
        return pulumi.get(self, "preshared_key")

    @_builtins.property
    @pulumi.getter(name="presharedKeyEncrypted")
    def preshared_key_encrypted(self) -> pulumi.Output[_builtins.str]:
        """
        Display the encrypted preshared-key for the IKE remote node
        """
        return pulumi.get(self, "preshared_key_encrypted")

    @_builtins.property
    @pulumi.getter
    def prf(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the pseudo-random function used to derive keying material for all cryptographic operations
        """
        return pulumi.get(self, "prf")

    @_builtins.property
    @pulumi.getter(name="proxySupport")
    def proxy_support(self) -> pulumi.Output[_builtins.str]:
        """
        If this value is enabled, both values of ID payloads in the phase 2 exchange are used as the addresses of end-point of IPsec-SAs
        """
        return pulumi.get(self, "proxy_support")

    @_builtins.property
    @pulumi.getter(name="remoteAddress")
    def remote_address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address of the IKE remote node
        """
        return pulumi.get(self, "remote_address")

    @_builtins.property
    @pulumi.getter(name="replayWindowSize")
    def replay_window_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the replay window size of the IPsec SAs negotiated with the IKE remote node
        """
        return pulumi.get(self, "replay_window_size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables this IKE remote node
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="trafficSelectors")
    def traffic_selectors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the names of the traffic-selector objects associated with this ike-peer
        """
        return pulumi.get(self, "traffic_selectors")

    @_builtins.property
    @pulumi.getter(name="verifyCert")
    def verify_cert(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to verify the certificate chain of the remote peer based on the trusted certificates in ca-cert-file
        """
        return pulumi.get(self, "verify_cert")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies which version of IKE to be used
        """
        return pulumi.get(self, "versions")

